/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.documentation;

import com.rapidminer.tools.xml.XHTMLEntityResolver;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DownloadOperatorDocumentationTask
extends Task {
    private static final String IMAGE_DIR_NAME = "images";
    private static final String IMAGE_FORMAT = "jpg";
    private static final String WIKI_PREFIX_FOR_IMAGES = "http://www.rapid-i.com";
    private static final String WIKI_PREFIX_FOR_OPERATORS = "http://rapid-i.com/wiki/index.php?title=";
    private static String CORRECT_HTML_STRING_DIRTY = "<html xmlns=\"http://www.w3.org/1999/xhtml\" dir=\"ltr\" lang=\"en\">";
    private static String CURRENT_OPERATOR_NAME_READ_FROM_RAPIDWIKI;
    private static final String RESOURCE_SUB_DIR = "com/rapidminer/resources/doc";
    private File resourceDir;
    private String namespace;
    private File operatorsFile;
    private File operatorsDocFile;

    public void execute() throws BuildException {
        try {
            this.importOperatorsAndImagesFromWiki(this.resourceDir, this.namespace, this.operatorsFile, this.operatorsDocFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Could not download operator documentation:" + e.getMessage(), (Throwable)e);
        }
    }

    public void setResourcedir(File resourceDir) {
        this.resourceDir = resourceDir;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setOperatorsdocfile(File operatorsDocFile) {
        this.operatorsDocFile = operatorsDocFile;
    }

    public void setOperatorsfile(File operatorsFile) {
        this.operatorsFile = operatorsFile;
    }

    private void importOperatorsAndImagesFromWiki(File resourceDir, String targetNamespace, File operatorsFile, File operatorsDocFile) throws BuildException {
        NodeList rootElementList;
        File imageDirectory;
        File namespaceDir;
        File documentationDir = new File(resourceDir, RESOURCE_SUB_DIR);
        if (!documentationDir.exists()) {
            documentationDir.mkdir();
        }
        if (!(namespaceDir = new File(documentationDir, targetNamespace)).exists()) {
            namespaceDir.mkdir();
        }
        if (!(imageDirectory = new File(namespaceDir, IMAGE_DIR_NAME)).exists()) {
            imageDirectory.mkdir();
        }
        this.log("Loading operators from xml...");
        HashMap<String, OperatorInformation> operatorInfos = new HashMap<String, OperatorInformation>();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(operatorsFile);
            rootElementList = document.getElementsByTagName("operators");
            if (rootElementList.getLength() != 1) {
                throw new BuildException("No valid operators xml file: No or multiple <operators> root element.");
            }
            Element operators = (Element)rootElementList.item(0);
            for (Element groupElement : DownloadOperatorDocumentationTask.getChildElements(operators, "group")) {
                this.loadGroupOperators(groupElement, operatorInfos, null);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Loading operator names from xml...");
        document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(operatorsDocFile);
            rootElementList = document.getElementsByTagName("operatorHelp");
            if (rootElementList.getLength() != 1) {
                throw new BuildException("No valid operators doc xml file: No or multiple <operatorHelp> root element.");
            }
            Element operatorsHelp = (Element)rootElementList.item(0);
            for (Element operatorElement : DownloadOperatorDocumentationTask.getChildElements(operatorsHelp, "operator")) {
                OperatorInformation operatorInfo;
                Element keyElement = DownloadOperatorDocumentationTask.getUniqueInnerTag(operatorElement, "key");
                Element nameElement = DownloadOperatorDocumentationTask.getUniqueInnerTag(operatorElement, "name");
                if (keyElement == null || nameElement == null || (operatorInfo = operatorInfos.get(keyElement.getTextContent())) == null) continue;
                operatorInfo.operatorName = nameElement.getTextContent();
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Retrieving operators documentation...");
        int i = 1;
        int total = operatorInfos.size();
        for (OperatorInformation operatorInfo : operatorInfos.values()) {
            if (operatorInfo.operatorName != null) {
                try {
                    this.log("Loading documentation for " + operatorInfo.operatorName + "...(" + i + " / " + total + ")");
                    String operatorWikiName = operatorInfo.operatorName.replaceAll(" ", "_");
                    Document operatorDocument = this.parseDocumentForOperator(operatorWikiName);
                    if (operatorDocument != null) {
                        operatorDocument = this.parseAndSaveImagesForOperator(operatorDocument, operatorInfo.operatorName, imageDirectory);
                        String iconPath = "icon:///24/" + operatorInfo.icon;
                        this.saveOperator(namespaceDir, String.valueOf(operatorInfo.operatorKey) + ".html", DownloadOperatorDocumentationTask.buildHTMLStringForOperator(operatorDocument, iconPath));
                    }
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            ++i;
        }
    }

    private void loadGroupOperators(Element groupElement, HashMap<String, OperatorInformation> operatorInfos, String currentIcon) {
        Element iconElement = DownloadOperatorDocumentationTask.getUniqueInnerTag(groupElement, "icon");
        if (iconElement != null) {
            currentIcon = iconElement.getTextContent();
        }
        for (Element operatorElement : DownloadOperatorDocumentationTask.getChildElements(groupElement, "operator")) {
            if (DownloadOperatorDocumentationTask.getUniqueInnerTag(operatorElement, "deprecatedSince") != null) continue;
            OperatorInformation operatorInfo = new OperatorInformation();
            operatorInfo.icon = currentIcon;
            Element keyElement = DownloadOperatorDocumentationTask.getUniqueInnerTag(operatorElement, "key");
            if (keyElement == null) continue;
            operatorInfo.operatorKey = keyElement.getTextContent();
            Element operatorIconElement = DownloadOperatorDocumentationTask.getUniqueInnerTag(operatorElement, "icon");
            if (operatorIconElement != null) {
                operatorInfo.icon = operatorIconElement.getTextContent();
            }
            operatorInfos.put(operatorInfo.operatorKey, operatorInfo);
        }
        for (Element childGroupElement : DownloadOperatorDocumentationTask.getChildElements(groupElement, "group")) {
            this.loadGroupOperators(childGroupElement, operatorInfos, currentIcon);
        }
    }

    private Document parseAndSaveImagesForOperator(Document documentOperator, String operatorName, File imageDirectory) throws ParserConfigurationException, SAXException, IOException {
        NodeList imgList = documentOperator.getElementsByTagName("img");
        if (imgList != null) {
            int k = 0;
            while (k < imgList.getLength()) {
                Node img = imgList.item(k);
                Element imgElement = (Element)img;
                if (imgElement.getAttribute("class").equals("thumbimage")) {
                    String srcString = imgElement.getAttribute("src");
                    String[] splitSrc = srcString.split("/");
                    String imageFileName = String.valueOf(operatorName) + "-" + splitSrc[splitSrc.length - 1];
                    if (!srcString.trim().isEmpty()) {
                        URL url = new URL(srcString);
                        try {
                            ImageIO.write((RenderedImage)ImageIO.read(url), IMAGE_FORMAT, new File(imageDirectory, imageFileName));
                        }
                        catch (MalformedURLException e) {
                            this.log(e, 0);
                        }
                        catch (IOException e) {
                            this.log(e, 0);
                        }
                        imgElement.removeAttribute("src");
                        imgElement.setAttribute("src", "resource:///doc/" + this.namespace + "/" + IMAGE_DIR_NAME + "/" + imageFileName);
                    }
                }
                ++k;
            }
        }
        return documentOperator;
    }

    private static String buildHTMLStringForOperator(Document documentOperator, String iconPath) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(documentOperator);
        transformer.transform(source, result);
        String htmlString = result.getWriter().toString();
        htmlString = DownloadOperatorDocumentationTask.customizeHTMLStringDirty(htmlString, iconPath);
        return htmlString;
    }

    private static String customizeHTMLStringDirty(String HTMLString, String operatorIconPath) {
        HTMLString = HTMLString.replaceFirst("\\<[^\\>]*>", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        HTMLString = HTMLString.replaceFirst(CORRECT_HTML_STRING_DIRTY, "<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" dir=\"ltr\"><head><table cellpadding=0 cellspacing=0><tr><td><img src=\"" + operatorIconPath + "\" /></td>" + "<td width=\"5\">" + "</td>" + "<td>" + "<h2 class=\"firstHeading\" id=\"firstHeading\">" + CURRENT_OPERATOR_NAME_READ_FROM_RAPIDWIKI + "</h2>" + "</td></tr>" + "</table>" + "<hr noshade=\"true\">" + "</head>");
        HTMLString = HTMLString.replaceAll("<h2>", "<h4>");
        HTMLString = HTMLString.replaceAll("</h2>", "</h4>");
        HTMLString = HTMLString.replaceAll("<ul>", "<ul class=\"ports\">");
        HTMLString = HTMLString.replaceAll("<div class=\"visualClear\"/>", "");
        Pattern pattern = Pattern.compile("\\</div\\>[\\s]*\\<h4\\>|\\</p\\>[\\s]*\\<h4\\>|\\</h4\\>[\\s]*\\<h4\\>|\\</ul\\>[\\s]*\\<h4\\>|\\</h4\\>[\\s]*\\</div\\>");
        Matcher matcher = pattern.matcher(HTMLString);
        while (matcher.find()) {
            String match = matcher.group();
            String replaceString = "";
            if (match.startsWith("</div")) {
                replaceString = "</div><br/><h4>";
            } else if (match.startsWith("</p")) {
                replaceString = "</p><br/><h4>";
            } else if (match.startsWith("</h4") && !match.contains("div")) {
                replaceString = "</h4><br/><h4>";
            } else if (match.startsWith("</ul")) {
                replaceString = "</ul><br/><h4>";
            } else if (match.startsWith("</h4") && match.contains("div")) {
                replaceString = "</h4><br/><div>";
            }
            HTMLString = HTMLString.replace(match, replaceString);
        }
        HTMLString = HTMLString.replaceAll("<pre", "<table class=pre border=0 bordercolor=black style=border-style:dashed;");
        HTMLString = HTMLString.replaceAll("</pre", "</table");
        return HTMLString;
    }

    private void saveOperator(File operatorDir, String operatorName, String operatorContent) {
        String temp = null;
        BufferedReader br = null;
        File targetFile = new File(operatorDir, operatorName);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(targetFile));
            br = new BufferedReader(new StringReader(operatorContent));
            temp = br.readLine();
            while (temp != null) {
                bw.write(temp);
                bw.newLine();
                temp = br.readLine();
            }
            bw.close();
            br.close();
        }
        catch (IOException e) {
            this.log(e, 0);
        }
    }

    private Document parseDocumentForOperator(String operatorWikiName) throws MalformedURLException, ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setIgnoringComments(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new XHTMLEntityResolver());
        Document document = null;
        URL url = new URL(WIKI_PREFIX_FOR_OPERATORS + operatorWikiName);
        if (url != null) {
            try {
                document = documentBuilder.parse(url.openStream());
            }
            catch (IOException e) {
                this.log("Could not open " + url.toString() + " because " + e.getMessage(), e, 0);
            }
            catch (SAXException e) {
                this.log("Could not parse " + url.toString() + " because " + e.getMessage(), e, 0);
            }
            int i = 0;
            if (document != null) {
                NodeList aList;
                Element catlinksElement;
                Element contentSubElement;
                Element siteSubElement;
                Element tocElement;
                Element mwNormalCatlinksElement;
                Element jumpToNavElement;
                Element contentElement = document.getElementById("content");
                if (contentElement != null) {
                    contentElement.getParentNode().removeChild(contentElement);
                }
                NodeList bodies = document.getElementsByTagName("body");
                int k = 0;
                while (k < bodies.getLength()) {
                    Node body = bodies.item(k);
                    while (body.hasChildNodes()) {
                        body.removeChild(body.getFirstChild());
                    }
                    if (k == 0) {
                        body.appendChild(contentElement);
                    }
                    ++k;
                }
                NodeList heads = document.getElementsByTagName("head");
                int k2 = 0;
                while (k2 < heads.getLength()) {
                    Node head = heads.item(k2);
                    while (head.hasChildNodes()) {
                        head.removeChild(head.getFirstChild());
                    }
                    ++k2;
                }
                if (heads != null) {
                    while (i < heads.getLength()) {
                        Node head = heads.item(i);
                        head.getParentNode().removeChild(head);
                    }
                }
                if ((jumpToNavElement = document.getElementById("jump-to-nav")) != null) {
                    jumpToNavElement.getParentNode().removeChild(jumpToNavElement);
                }
                if ((mwNormalCatlinksElement = document.getElementById("mw-normal-catlinks")) != null) {
                    mwNormalCatlinksElement.getParentNode().removeChild(mwNormalCatlinksElement);
                }
                if ((tocElement = document.getElementById("toc")) != null) {
                    tocElement.getParentNode().removeChild(tocElement);
                }
                NodeList nodeListDiv = document.getElementsByTagName("div");
                int k3 = 0;
                while (k3 < nodeListDiv.getLength()) {
                    Element div = (Element)nodeListDiv.item(k3);
                    if (div.getAttribute("class").equals("printfooter")) {
                        div.getParentNode().removeChild(div);
                    }
                    ++k3;
                }
                NodeList spanList = document.getElementsByTagName("span");
                int k4 = 0;
                while (k4 < spanList.getLength()) {
                    Element span = (Element)spanList.item(k4);
                    if (span.getAttribute("class").equals("editsection")) {
                        span.getParentNode().removeChild(span);
                    }
                    ++k4;
                }
                boolean doIt = true;
                NodeList pList = document.getElementsByTagName("p");
                int k5 = 0;
                while (k5 < pList.getLength()) {
                    if (!doIt) break;
                    Node p = pList.item(k5);
                    NodeList pChildList = p.getChildNodes();
                    int j = 0;
                    while (j < pChildList.getLength()) {
                        Node pChild = pChildList.item(j);
                        String nodeValue = pChild.getNodeValue();
                        if (pChild.getNodeType() == 3 && nodeValue != null && !nodeValue.trim().isEmpty()) {
                            String pChildString = nodeValue;
                            Element newPWithoutSpaces = document.createElement("p");
                            newPWithoutSpaces.setTextContent(pChildString);
                            Text synopsis = document.createTextNode("Synopsis");
                            Element span = document.createElement("span");
                            span.setAttribute("class", "mw-headline");
                            span.setAttribute("id", "Synopsis");
                            span.appendChild(synopsis);
                            Element h2 = document.createElement("h2");
                            h2.appendChild(span);
                            Element div = document.createElement("div");
                            div.setAttribute("id", "synopsis");
                            div.appendChild(h2);
                            div.appendChild(newPWithoutSpaces);
                            Node pChildParentParent = pChild.getParentNode().getParentNode();
                            Node pChildParent = pChild.getParentNode();
                            pChildParentParent.replaceChild(div, pChildParent);
                            doIt = false;
                            break;
                        }
                        ++j;
                    }
                    ++k5;
                }
                NodeList brList = document.getElementsByTagName("br");
                while (i < brList.getLength()) {
                    Node br = brList.item(i);
                    Node parentBrNode = br.getParentNode();
                    parentBrNode.removeChild(br);
                }
                NodeList scriptList = document.getElementsByTagName("script");
                while (i < scriptList.getLength()) {
                    Node scriptNode = scriptList.item(i);
                    Node parentNode = scriptNode.getParentNode();
                    parentNode.removeChild(scriptNode);
                }
                NodeList pList2 = document.getElementsByTagName("p");
                int ccc = 0;
                block14: while (ccc < pList2.getLength()) {
                    Node p = pList2.item(ccc);
                    NodeList pChilds = p.getChildNodes();
                    int kk = 0;
                    while (kk < pChilds.getLength()) {
                        Node pChild = pChilds.item(kk);
                        if (pChild.getNodeType() == 3) {
                            String pNodeValue = pChild.getNodeValue();
                            if (pNodeValue != null && !pNodeValue.trim().isEmpty()) {
                                ++ccc;
                                continue block14;
                            }
                        } else {
                            ++ccc;
                            continue block14;
                        }
                        if (++kk != pChilds.getLength()) continue;
                        Node parentBrNode = p.getParentNode();
                        parentBrNode.removeChild(p);
                    }
                }
                Element firstHeadingElement = document.getElementById("firstHeading");
                if (firstHeadingElement != null) {
                    CURRENT_OPERATOR_NAME_READ_FROM_RAPIDWIKI = firstHeadingElement.getFirstChild().getNodeValue();
                    firstHeadingElement.getParentNode().removeChild(firstHeadingElement);
                }
                if ((siteSubElement = document.getElementById("siteSub")) != null) {
                    siteSubElement.getParentNode().removeChild(siteSubElement);
                }
                if ((contentSubElement = document.getElementById("contentSub")) != null) {
                    contentSubElement.getParentNode().removeChild(contentSubElement);
                }
                if ((catlinksElement = document.getElementById("catlinks")) != null) {
                    catlinksElement.getParentNode().removeChild(catlinksElement);
                }
                if ((aList = document.getElementsByTagName("a")) != null) {
                    int k6 = 0;
                    while (k6 < aList.getLength()) {
                        Node a = aList.item(k6);
                        Element aElement = (Element)a;
                        if (aElement.getAttribute("class").equals("internal")) {
                            a.getParentNode().removeChild(a);
                            continue;
                        }
                        Node aChild = a.getFirstChild();
                        if (aChild != null && (aChild.getNodeValue() != null && aChild.getNodeType() == 3 && aChild.getNodeValue().trim().isEmpty() && aChild.getNodeValue().trim().isEmpty() || aChild.getNodeName() != null)) {
                            Element aChildElement = null;
                            if (aChild.getNodeName().startsWith("img")) {
                                aChildElement = (Element)aChild;
                                Element imgElement = document.createElement("img");
                                imgElement.setAttribute("alt", aChildElement.getAttribute("alt"));
                                imgElement.setAttribute("class", aChildElement.getAttribute("class"));
                                imgElement.setAttribute("height", aChildElement.getAttribute("height"));
                                imgElement.setAttribute("src", WIKI_PREFIX_FOR_IMAGES + aChildElement.getAttribute("src"));
                                imgElement.setAttribute("width", aChildElement.getAttribute("width"));
                                imgElement.setAttribute("border", "1");
                                Node aParent = a.getParentNode();
                                aParent.replaceChild(imgElement, a);
                                continue;
                            }
                            ++k6;
                            continue;
                        }
                        a.getParentNode().removeChild(a);
                    }
                }
            }
        }
        return document;
    }

    public static Element getUniqueInnerTag(Element element, String tagName) {
        NodeList children = element.getElementsByTagName(tagName);
        switch (children.getLength()) {
            case 0: {
                return null;
            }
        }
        return (Element)children.item(0);
    }

    public static Collection<Element> getChildElements(Element father, String tagName) {
        LinkedList<Element> elements = new LinkedList<Element>();
        NodeList list = father.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Element && node.getNodeName().equals(tagName)) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements;
    }

    private class OperatorInformation {
        String operatorKey = null;
        String operatorName = null;
        String icon = null;

        private OperatorInformation() {
        }
    }
}

