/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.freehep.graphicsio.swf.LineStyle;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class LineStyleArray {
    protected List lineStyles = new ArrayList();

    public LineStyleArray() {
    }

    public LineStyleArray(SWFInputStream swf, boolean isMorphStyle, boolean hasAlpha, boolean hasStyles) throws IOException {
        this();
        int lineStyleCount = swf.readUnsignedByte();
        if (lineStyleCount == 255) {
            lineStyleCount = swf.readUnsignedShort();
        }
        for (int i = 0; i < lineStyleCount; ++i) {
            this.lineStyles.add(new LineStyle(swf, isMorphStyle, hasAlpha, hasStyles));
        }
    }

    public void add(LineStyle lineStyle) {
        this.lineStyles.add(lineStyle);
    }

    public LineStyle get(int index) {
        return (LineStyle)this.lineStyles.get(index);
    }

    public void write(SWFOutputStream swf, boolean isMorphStyle, boolean hasAlpha, boolean hasStyles) throws IOException {
        if (this.lineStyles.size() >= 255) {
            swf.writeUnsignedByte(255);
            swf.writeUnsignedShort(this.lineStyles.size());
        } else {
            swf.writeUnsignedByte(this.lineStyles.size());
        }
        Iterator i = this.lineStyles.iterator();
        while (i.hasNext()) {
            ((LineStyle)i.next()).write(swf, isMorphStyle, hasAlpha, hasStyles);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("  lineStyles: " + this.lineStyles.size() + "\n");
        int n = 0;
        Iterator i = this.lineStyles.iterator();
        while (i.hasNext()) {
            s.append("    " + (n + 1) + " " + i.next() + "\n");
            ++n;
        }
        return s.toString();
    }
}

