/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.ui;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.DockViewTitleBar;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;

public class DockViewTitleBarUI
extends PanelUI
implements PropertyChangeListener {
    private static boolean useCustomPaint = System.getProperty("os.name").toLowerCase().indexOf("mac os") < 0;
    private static Color panelColor = UIManager.getColor("Panel.background");
    private static Color highlight = UIManager.getColor("VLDocking.highlight");
    private static Color shadow = UIManager.getColor("VLDocking.shadow");
    private static Icon closeIcon = UIManager.getIcon("DockViewTitleBar.close");
    private static Icon closeIconRollover = UIManager.getIcon("DockViewTitleBar.close.rollover");
    private static Icon closeIconPressed = UIManager.getIcon("DockViewTitleBar.close.pressed");
    private static Icon maximizeIcon = UIManager.getIcon("DockViewTitleBar.maximize");
    private static Icon maximizeIconRollover = UIManager.getIcon("DockViewTitleBar.maximize.rollover");
    private static Icon maximizeIconPressed = UIManager.getIcon("DockViewTitleBar.maximize.pressed");
    private static Icon restoreIcon = UIManager.getIcon("DockViewTitleBar.restore");
    private static Icon restoreIconRollover = UIManager.getIcon("DockViewTitleBar.restore.rollover");
    private static Icon restoreIconPressed = UIManager.getIcon("DockViewTitleBar.restore.pressed");
    private static Icon hideIcon = UIManager.getIcon("DockViewTitleBar.hide");
    private static Icon hideIconRollover = UIManager.getIcon("DockViewTitleBar.hide.rollover");
    private static Icon hideIconPressed = UIManager.getIcon("DockViewTitleBar.hide.pressed");
    private static Icon dockIcon = UIManager.getIcon("DockViewTitleBar.dock");
    private static Icon dockIconRollover = UIManager.getIcon("DockViewTitleBar.dock.rollover");
    private static Icon dockIconPressed = UIManager.getIcon("DockViewTitleBar.dock.pressed");
    private static Icon floatIcon = UIManager.getIcon("DockViewTitleBar.float");
    private static Icon floatIconRollover = UIManager.getIcon("DockViewTitleBar.float.rollover");
    private static Icon floatIconPressed = UIManager.getIcon("DockViewTitleBar.float.pressed");
    private static Icon attachIcon = UIManager.getIcon("DockViewTitleBar.attach");
    private static Icon attachIconRollover = UIManager.getIcon("DockViewTitleBar.attach.rollover");
    private static Icon attachIconPressed = UIManager.getIcon("DockViewTitleBar.attach.pressed");
    private static final String CLOSE_TEXT = UIManager.getString("DockViewTitleBar.closeButtonText");
    private static final String ICONIFY_TEXT = UIManager.getString("DockViewTitleBar.minimizeButtonText");
    private static final String RESTORE_TEXT = UIManager.getString("DockViewTitleBar.restoreButtonText");
    private static final String MAXIMIZE_TEXT = UIManager.getString("DockViewTitleBar.maximizeButtonText");
    private static final String FLOAT_TEXT = UIManager.getString("DockViewTitleBar.floatButtonText");
    private static final String ATTACH_TEXT = UIManager.getString("DockViewTitleBar.attachButtonText");
    private static Color selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
    private static Color selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
    private static Color notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
    private static Color notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    private boolean isCloseButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isCloseButtonDisplayed");
    private boolean isHideButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isHideButtonDisplayed");
    private boolean isDockButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isDockButtonDisplayed");
    private boolean isMaximizeButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isMaximizeButtonDisplayed");
    private boolean isRestoreButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isRestoreButtonDisplayed");
    private boolean isFloatButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isFloatButtonDisplayed");
    private boolean isAttachButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isAttachButtonDisplayed");
    protected DockViewTitleBar titleBar;
    private AncestorListener ancestorListener = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            DockViewTitleBarUI.this.configureButtons(DockViewTitleBarUI.this.titleBar);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    };

    public DockViewTitleBarUI(DockViewTitleBar tb) {
        this.titleBar = tb;
    }

    public static ComponentUI createUI(JComponent c) {
        return new DockViewTitleBarUI((DockViewTitleBar)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installTitleBorder(c);
        BoxLayout box = new BoxLayout(this.titleBar, 0);
        this.titleBar.setLayout(box);
        this.titleBar.setOpaque(true);
        this.titleBar.addPropertyChangeListener(this);
        this.titleBar.addAncestorListener(this.ancestorListener);
        this.installButtons();
        this.installLabel();
        Dockable d = this.titleBar.getDockable();
        if (d != null) {
            this.titleBar.getDockable().getDockKey().addPropertyChangeListener(this);
            this.configureButtons(this.titleBar);
        }
        c.setCursor(Cursor.getDefaultCursor());
    }

    protected void layoutTitleBar() {
        this.titleBar.removeAll();
        this.titleBar.add(Box.createHorizontalStrut(4));
        this.titleBar.add(this.titleBar.getTitleLabel());
        this.titleBar.add(Box.createHorizontalGlue());
        int height = UIManager.getInt("DockViewTitleBar.height");
        if (height > 0) {
            this.titleBar.add(Box.createRigidArea(new Dimension(4, height)));
        }
        this.titleBar.add(this.titleBar.getHideOrDockButton());
        this.titleBar.add(this.titleBar.getFloatButton());
        this.titleBar.add(this.titleBar.getMaximizeOrRestoreButton());
        this.titleBar.add(this.titleBar.getCloseButton());
        this.titleBar.finishLayout();
        this.titleBar.revalidate();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallTitleBorder(c);
        this.titleBar.removePropertyChangeListener(this);
        this.titleBar.removeAncestorListener(this.ancestorListener);
        Dockable d = this.titleBar.getDockable();
        if (d != null) {
            d.getDockKey().removePropertyChangeListener(this);
        }
    }

    protected void installLabel() {
        JLabel titleLabel = this.titleBar.getTitleLabel();
        Font f = UIManager.getFont("DockViewTitleBar.titleFont");
        titleLabel.setFont(f);
        titleLabel.setForeground(notSelectedTextColor);
        this.titleBar.setBackground(notSelectedTitleColor);
    }

    protected void installBackground() {
        this.titleBar.setBackground(notSelectedTitleColor);
    }

    protected void installButtons() {
        JButton closeButton = this.titleBar.getCloseButton();
        JButton dockButton = this.titleBar.getHideOrDockButton();
        JButton maximizeButton = this.titleBar.getMaximizeOrRestoreButton();
        JButton floatButton = this.titleBar.getFloatButton();
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        closeButton.setBorder(emptyBorder);
        dockButton.setBorder(emptyBorder);
        maximizeButton.setBorder(emptyBorder);
        floatButton.setBorder(emptyBorder);
        Insets buttonMargin = new Insets(0, 2, 0, 2);
        closeButton.setMargin(buttonMargin);
        dockButton.setMargin(buttonMargin);
        maximizeButton.setMargin(buttonMargin);
        floatButton.setMargin(buttonMargin);
        dockButton.setRolloverEnabled(true);
        dockButton.setBorderPainted(false);
        dockButton.setFocusable(false);
        dockButton.setContentAreaFilled(false);
        closeButton.setRolloverEnabled(true);
        closeButton.setBorderPainted(false);
        closeButton.setFocusable(false);
        closeButton.setContentAreaFilled(false);
        maximizeButton.setRolloverEnabled(true);
        maximizeButton.setBorderPainted(false);
        maximizeButton.setFocusable(false);
        maximizeButton.setContentAreaFilled(false);
        floatButton.setRolloverEnabled(true);
        floatButton.setBorderPainted(false);
        floatButton.setFocusable(false);
        floatButton.setContentAreaFilled(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String pName = e.getPropertyName();
        if (pName.equals("dockable")) {
            Dockable newDockable;
            Dockable old = (Dockable)e.getOldValue();
            if (old != null) {
                old.getDockKey().removePropertyChangeListener(this);
            }
            if ((newDockable = (Dockable)e.getNewValue()) != null) {
                this.configureButtons(this.titleBar);
                newDockable.getDockKey().addPropertyChangeListener(this);
            }
        } else if (pName.equals("autohide")) {
            boolean isMaximized;
            boolean isAutoHideable = (Boolean)e.getNewValue();
            boolean bl = isMaximized = this.titleBar.getDockable().getDockKey().getLocation() == DockableState.Location.MAXIMIZED;
            if (isAutoHideable) {
                if (!isMaximized) {
                    this.titleBar.getHideOrDockButton().setVisible(true);
                    this.configureHideButton(this.titleBar.getHideOrDockButton());
                }
            } else {
                this.titleBar.getHideOrDockButton().setVisible(false);
            }
        } else if (pName.equals("maximizable")) {
            boolean isHidden;
            boolean isMaximizeable = (Boolean)e.getNewValue();
            boolean bl = isHidden = this.titleBar.getDockable().getDockKey().getLocation() == DockableState.Location.HIDDEN;
            if (isMaximizeable) {
                if (!isHidden) {
                    this.titleBar.getMaximizeOrRestoreButton().setVisible(true);
                    this.configureMaximizeButton(this.titleBar.getMaximizeOrRestoreButton());
                }
            } else {
                this.titleBar.getMaximizeOrRestoreButton().setVisible(false);
            }
        } else if (pName.equals("close")) {
            boolean isMaximized;
            boolean isCloseable = (Boolean)e.getNewValue();
            boolean bl = isMaximized = this.titleBar.getDockable().getDockKey().getLocation() == DockableState.Location.MAXIMIZED;
            if (isCloseable) {
                if (!isMaximized) {
                    this.titleBar.getCloseButton().setVisible(true);
                    this.configureCloseButton(this.titleBar.getCloseButton());
                }
            } else {
                this.titleBar.getCloseButton().setVisible(false);
            }
        } else if (pName.equals("floatable")) {
            boolean isMaximized;
            boolean isFloatable = (Boolean)e.getNewValue();
            boolean bl = isMaximized = this.titleBar.getDockable().getDockKey().getLocation() == DockableState.Location.MAXIMIZED;
            if (isFloatable) {
                if (!isMaximized) {
                    this.titleBar.getFloatButton().setVisible(true);
                    this.configureFloatButton(this.titleBar.getFloatButton());
                }
            } else {
                this.titleBar.getFloatButton().setVisible(false);
            }
        } else if (pName.equals("dockablestate")) {
            this.configureButtons(this.titleBar);
        } else if (pName.equals("active")) {
            boolean isActive = (Boolean)e.getNewValue();
            if (isActive) {
                this.titleBar.getTitleLabel().setForeground(selectedTextColor);
                this.titleBar.setBackground(selectedTitleColor);
            } else {
                this.titleBar.getTitleLabel().setForeground(notSelectedTextColor);
                this.titleBar.setBackground(notSelectedTitleColor);
            }
            this.titleBar.repaint();
        } else if (pName.equals("titlebar.notification")) {
            boolean notification = (Boolean)e.getNewValue();
            if (notification) {
                this.titleBar.setBackground(UIManager.getColor("DockingDesktop.notificationColor"));
                this.titleBar.setOpaque(true);
            } else {
                if (this.titleBar.isActive()) {
                    this.titleBar.setBackground(selectedTitleColor);
                } else {
                    this.titleBar.setBackground(notSelectedTitleColor);
                }
                this.titleBar.setOpaque(false);
            }
            this.titleBar.repaint();
        } else if (pName.equals("name")) {
            this.titleBar.repaint();
        } else if (pName.equals("clientProperty.visibleTitleBar")) {
            boolean v = Boolean.TRUE.equals(e.getNewValue());
            this.titleBar.setVisible(v);
        }
    }

    protected void configureButtons(DockViewTitleBar tb) {
        this.layoutTitleBar();
        DockKey key = tb.getDockable().getDockKey();
        DockableState.Location location = key.getLocation();
        JButton closeButton = this.titleBar.getCloseButton();
        JButton maxBtn = this.titleBar.getMaximizeOrRestoreButton();
        JButton hideBtn = this.titleBar.getHideOrDockButton();
        JButton floatBtn = this.titleBar.getFloatButton();
        switch (location) {
            case DOCKED: {
                Dockable max;
                if (key.isCloseEnabled() && this.isCloseButtonDisplayed) {
                    closeButton.setVisible(true);
                    this.configureCloseButton(closeButton);
                } else {
                    closeButton.setVisible(false);
                }
                if (key.isMaximizeEnabled() && this.isMaximizeButtonDisplayed) {
                    maxBtn.setVisible(true);
                    this.configureMaximizeButton(maxBtn);
                } else {
                    maxBtn.setVisible(false);
                }
                boolean isChildOfMaximizedContainer = false;
                DockingDesktop desk = this.titleBar.getDesktop();
                if (desk != null && (max = desk.getMaximizedDockable()) != null && max.getComponent().getParent().isAncestorOf(this.titleBar)) {
                    isChildOfMaximizedContainer = true;
                }
                if (key.isAutoHideEnabled() && this.isHideButtonDisplayed && !isChildOfMaximizedContainer) {
                    hideBtn.setVisible(true);
                    this.configureHideButton(hideBtn);
                } else {
                    hideBtn.setVisible(false);
                }
                if (key.isFloatEnabled() && this.isFloatButtonDisplayed && !isChildOfMaximizedContainer) {
                    floatBtn.setVisible(true);
                    this.configureFloatButton(floatBtn);
                } else {
                    floatBtn.setVisible(false);
                }
                this.titleBar.revalidate();
                break;
            }
            case HIDDEN: {
                if (key.isCloseEnabled() && this.isCloseButtonDisplayed) {
                    closeButton.setVisible(true);
                    this.configureCloseButton(closeButton);
                } else {
                    closeButton.setVisible(false);
                }
                maxBtn.setVisible(false);
                boolean isChildOfCompound = DockingUtilities.isChildOfCompoundDockable(tb.getDockable());
                if (key.isFloatEnabled() && this.isFloatButtonDisplayed && !isChildOfCompound) {
                    floatBtn.setVisible(true);
                    this.configureFloatButton(floatBtn);
                } else {
                    floatBtn.setVisible(false);
                }
                if (isChildOfCompound) {
                    hideBtn.setVisible(false);
                } else if (this.isDockButtonDisplayed && key.isAutoHideEnabled()) {
                    hideBtn.setVisible(true);
                    this.configureDockButton(hideBtn);
                } else {
                    hideBtn.setVisible(false);
                }
                this.titleBar.revalidate();
                break;
            }
            case MAXIMIZED: {
                closeButton.setVisible(false);
                floatBtn.setVisible(false);
                if (this.isRestoreButtonDisplayed) {
                    this.configureRestoreButton(maxBtn);
                    maxBtn.setVisible(true);
                } else {
                    maxBtn.setVisible(false);
                }
                hideBtn.setVisible(false);
                this.titleBar.revalidate();
                break;
            }
            case FLOATING: {
                closeButton.setVisible(false);
                maxBtn.setVisible(false);
                hideBtn.setVisible(false);
                if (DockingUtilities.isChildOfCompoundDockable(tb.getDockable())) {
                    floatBtn.setVisible(false);
                    break;
                }
                floatBtn.setVisible(this.isAttachButtonDisplayed);
                this.configureAttachButton(floatBtn);
            }
        }
    }

    protected void configureCloseButton(JButton btn) {
        btn.setIcon(closeIcon);
        btn.setRolloverIcon(closeIconRollover);
        btn.setPressedIcon(closeIconPressed);
        btn.setRolloverSelectedIcon(closeIconRollover);
        btn.setToolTipText(CLOSE_TEXT);
    }

    protected void configureMaximizeButton(JButton btn) {
        btn.setIcon(maximizeIcon);
        btn.setRolloverIcon(maximizeIconRollover);
        btn.setPressedIcon(maximizeIconPressed);
        btn.setRolloverSelectedIcon(maximizeIconRollover);
        btn.setToolTipText(MAXIMIZE_TEXT);
    }

    protected void configureRestoreButton(JButton btn) {
        btn.setIcon(restoreIcon);
        btn.setRolloverIcon(restoreIconRollover);
        btn.setPressedIcon(restoreIconPressed);
        btn.setRolloverSelectedIcon(restoreIconRollover);
        btn.setToolTipText(RESTORE_TEXT);
    }

    protected void configureHideButton(JButton btn) {
        btn.setIcon(hideIcon);
        btn.setRolloverIcon(hideIconRollover);
        btn.setPressedIcon(hideIconPressed);
        btn.setRolloverSelectedIcon(hideIconRollover);
        btn.setToolTipText(ICONIFY_TEXT);
    }

    protected void configureDockButton(JButton btn) {
        btn.setIcon(dockIcon);
        btn.setRolloverIcon(dockIconRollover);
        btn.setPressedIcon(dockIconPressed);
        btn.setRolloverSelectedIcon(dockIconRollover);
        btn.setToolTipText(RESTORE_TEXT);
    }

    protected void configureFloatButton(JButton btn) {
        btn.setIcon(floatIcon);
        btn.setRolloverIcon(floatIconRollover);
        btn.setPressedIcon(floatIconPressed);
        btn.setRolloverSelectedIcon(floatIconRollover);
        btn.setToolTipText(FLOAT_TEXT);
    }

    protected void configureAttachButton(JButton btn) {
        btn.setIcon(attachIcon);
        btn.setRolloverIcon(attachIconRollover);
        btn.setPressedIcon(attachIconPressed);
        btn.setRolloverSelectedIcon(attachIconRollover);
        btn.setToolTipText(ATTACH_TEXT);
    }

    protected void installTitleBorder(JComponent c) {
        Border b = UIManager.getBorder("DockViewTitleBar.border");
        c.setBorder(b);
    }

    protected void uninstallTitleBorder(JComponent c) {
        c.setBorder(null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        DockViewTitleBar tb = (DockViewTitleBar)c;
        if (useCustomPaint) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(panelColor);
            g2.fillRect(0, 0, tb.getWidth(), tb.getHeight());
            Insets i = tb.getInsets();
            g2.setColor(tb.getBackground());
            Rectangle r = tb.getTitleLabel().getBounds();
            int w = r.x + r.width;
            g2.fillRect(i.left, i.top, w, tb.getHeight() - i.top - i.bottom);
            if (tb.isActive()) {
                g2.setPaint(new GradientPaint(i.left + w, 0.0f, tb.getBackground(), tb.getWidth(), 0.0f, highlight));
            } else {
                g2.setPaint(new GradientPaint(i.left + w, 0.0f, tb.getBackground(), tb.getWidth(), 0.0f, highlight));
            }
            g2.fillRect(i.left + w, i.top, tb.getWidth() - w - i.left - i.right, tb.getHeight() - i.top - i.bottom);
            g2.dispose();
        }
        super.paint(g, c);
    }
}

