/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlDate
extends SqlData {
    private String value = null;
    private SqlDates dates;

    public SqlDate() {
        super(true);
        this.dates = SqlDates.getDefaultInstance();
    }

    public SqlDate(SqlDates sqlDates) {
        super(true);
        this.dates = sqlDates;
    }

    public void set(String string) {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = string;
        }
    }

    public void set(SqlDate sqlDate) {
        if (sqlDate == null || sqlDate.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlDate.value;
        }
    }

    public String get() {
        return this.value;
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            java.sql.Date date;
            try {
                date = java.sql.Date.valueOf(string);
            }
            catch (Exception exception) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setDate(date, null);
        }
    }

    @Override
    public void setDate(java.sql.Date date, TimeZone timeZone) throws SQLException {
        this.set(date, timeZone);
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        this.set(timestamp, timeZone);
    }

    private void set(Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        String string = this.value = timeZone != null ? this.dates.formatDate(date, timeZone) : this.dates.formatDate(date, false);
        if (this.value == null || this.value.length() != 10 || this.value.charAt(4) != '-' || this.value.charAt(7) != '-') {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    @Override
    public String getString() throws SQLException {
        return this.dates.formatDate((Date)this.get(null), false);
    }

    @Override
    public java.sql.Date getDate(TimeZone timeZone) throws SQLException {
        return this.get(timeZone);
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        return new Timestamp(this.get(timeZone).getTime());
    }

    @Override
    public Object getObject() throws SQLException {
        return this.get(null);
    }

    private java.sql.Date get(TimeZone timeZone) throws SQLException {
        return timeZone != null ? this.dates.parseDate(this.value, timeZone) : this.dates.parseDate(this.value, false);
    }
}

