/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteBuffer {
    public static final int DEFAULT_SIZE = 8192;
    private Node root = new Node();
    private int segmentSize = 8192;

    public ByteBuffer() {
        this.root.left = this.root;
    }

    public ByteBuffer(int n) {
        this();
        if (n > 0) {
            this.segmentSize = n;
        }
    }

    public ByteBuffer(byte[] byArray, int n, int n2) {
        this();
        this.append(byArray, n, n2);
    }

    public ByteBuffer(int n, byte[] byArray, int n2, int n3) {
        this(n);
        this.append(byArray, n2, n3);
    }

    public ByteBuffer(InputStream inputStream) {
        this();
        this.append(inputStream);
    }

    public ByteBuffer(int n, InputStream inputStream) {
        this(n);
        this.append(inputStream);
    }

    public void free() {
        this.truncate(0L);
    }

    public long length() {
        return this.root.left.offset + (long)this.root.left.length;
    }

    public long read(long l, byte[] byArray, int n, int n2) {
        long l2 = 0L;
        if (byArray == null || l < 0L || n2 < 1 || n < 0 || n >= byArray.length) {
            return 0L;
        }
        n2 = Math.min(n2, byArray.length - n);
        Node node = this.locate(l);
        while (n2 > 0 && node != null && l >= node.offset) {
            int n3 = (int)Math.min(l - node.offset, (long)node.length);
            int n4 = Math.min(n2, node.length - n3);
            if (n4 > 0) {
                System.arraycopy(node.data, n3, byArray, n, n4);
                l += (long)n4;
                n += n4;
                l2 += (long)n4;
                n2 -= n4;
            }
            node = node.next;
        }
        return l2;
    }

    public long read(long l, OutputStream outputStream, long l2) {
        long l3 = 0L;
        if (outputStream == null || l < 0L || l2 < 1L) {
            return 0L;
        }
        Node node = this.locate(l);
        while (l2 > 0L && node != null && l >= node.offset) {
            int n = (int)Math.min(l - node.offset, (long)node.length);
            int n2 = (int)Math.min(l2, (long)(node.length - n));
            if (n2 > 0) {
                try {
                    outputStream.write(node.data, n, n2);
                }
                catch (IOException iOException) {
                    break;
                }
                l += (long)n2;
                l3 += (long)n2;
                l2 -= (long)n2;
            }
            node = node.next;
        }
        return l3;
    }

    public long read(OutputStream outputStream) {
        return this.read(0L, outputStream, this.length());
    }

    public InputStream getIS() {
        return new ByteBuffIS();
    }

    public InputStream getIS(long l, long l2) {
        return new ByteBuffIS(l, l2);
    }

    public long find(byte[] byArray, long l) {
        long l2 = -1L;
        if (byArray == null || byArray.length < 1 || l < 0L) {
            return -1L;
        }
        Node node = this.locate(l);
        block0: while (node != null && l >= node.offset) {
            int n = (int)Math.min(l - node.offset, (long)node.length);
            l = node.offset + (long)node.length;
            while (n < node.length) {
                block7: {
                    if (node.data[n] == byArray[0]) {
                        Node node2 = node;
                        int n2 = n + 1;
                        for (int i = 1; i < byArray.length; ++i) {
                            while (n2 >= node2.length) {
                                if (node2.next == null) break block0;
                                node2 = node2.next;
                                n2 = 0;
                            }
                            if (node2.data[n2] == byArray[i]) {
                                ++n2;
                                continue;
                            }
                            break block7;
                        }
                        l2 = node.offset + (long)n;
                        break block0;
                    }
                }
                ++n;
            }
            node = node.next;
        }
        return l2;
    }

    public void truncate(long l) {
        if (l < 0L) {
            return;
        }
        if (l == 0L) {
            this.root.right = null;
            this.root.next = null;
            this.root.left = this.root;
            return;
        }
        Node node = this.prune(l - 1L);
        node.length = (int)Math.max(0L, Math.min((long)node.length, l -= node.offset));
    }

    public long append(byte[] byArray, int n, int n2) {
        Node node = this.root.left;
        long l = 0L;
        if (byArray == null || n2 < 1 || n < 0 || n >= byArray.length) {
            return 0L;
        }
        n2 = Math.min(n2, byArray.length - n);
        while (n2 > 0) {
            int n3;
            if (node.length >= node.data.length) {
                node = this.extend();
            }
            if ((n3 = Math.min(n2, node.data.length - node.length)) <= 0) continue;
            System.arraycopy(byArray, n, node.data, node.length, n3);
            node.length += n3;
            n += n2;
            l += (long)n3;
            n2 -= n3;
        }
        return l;
    }

    public long append(InputStream inputStream) {
        Node node = this.root.left;
        long l = 0L;
        if (inputStream == null) {
            return 0L;
        }
        while (true) {
            int n;
            if (node.length >= node.data.length) {
                node = this.extend();
            }
            try {
                n = inputStream.read(node.data, node.length, node.data.length - node.length);
            }
            catch (IOException iOException) {
                n = -1;
            }
            if (n < 0) break;
            node.length += n;
            l += (long)n;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }

    public long write(long l, byte[] byArray, int n, int n2) {
        long l2 = 0L;
        if (byArray == null || l < 0L || n2 < 1 || n < 0 || n >= byArray.length) {
            return 0L;
        }
        n2 = Math.min(n2, byArray.length - n);
        Node node = this.locate(l);
        while (n2 > 0 && node != null && l >= node.offset) {
            int n3 = (int)Math.min(l - node.offset, (long)node.length);
            int n4 = Math.min(n2, node.length - n3);
            if (n4 > 0) {
                System.arraycopy(byArray, n, node.data, n3, n4);
                l += (long)n4;
                n += n4;
                l2 += (long)n4;
                n2 -= n4;
            }
            if (n2 > 0 && l == node.offset + (long)node.length && node.next == null) {
                l2 += this.append(byArray, n, n2);
                break;
            }
            node = node.next;
        }
        return l2;
    }

    public long write(long l, InputStream inputStream) {
        long l2 = 0L;
        if (inputStream == null || l < 0L) {
            return 0L;
        }
        Node node = this.locate(l);
        block4: while (node != null && l >= node.offset) {
            int n;
            int n2 = (int)Math.min(l - node.offset, (long)node.length);
            for (int i = node.length - n2; i > 0; i -= n) {
                try {
                    n = inputStream.read(node.data, n2, i);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n < 0) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block4;
                }
                l += (long)n;
                n2 += n;
                l2 += (long)n;
            }
            if (l == node.offset + (long)node.length && node.next == null) {
                l2 += this.append(inputStream);
                break;
            }
            node = node.next;
        }
        return l2;
    }

    public OutputStream getOS(long l) {
        return l < 0L || l > this.length() ? null : new ByteBuffOS(l);
    }

    private Node locate(long l) {
        Node node = this.root;
        Node node2 = this.root.right;
        while (node2 != null) {
            node = node2;
            if (l < node.offset) {
                node2 = node.left;
                continue;
            }
            if (l < node.offset + (long)node.length) {
                node2 = null;
                continue;
            }
            node2 = node.right;
        }
        return node;
    }

    private Node prune(long l) {
        Node node = this.root;
        Node node2 = this.root;
        Node node3 = this.root.right;
        while (node3 != null) {
            node2 = node3;
            if (l < node2.offset) {
                if (node2.left == null) {
                    node2.right = null;
                    node3 = null;
                    continue;
                }
                node.right = node2.left;
                node3 = node2.left;
                continue;
            }
            if (l < node2.offset + (long)node2.length) {
                node2.right = null;
                node3 = null;
                continue;
            }
            node = node2;
            node3 = node2.right;
        }
        node2.next = null;
        this.root.left = node2;
        return node2;
    }

    private Node extend() {
        Node node;
        Node node2 = this.root.left;
        long l = node2.offset + (long)node2.data.length;
        if (node2.level != 1) {
            node2.right = node = new Node(l, this.segmentSize);
        } else {
            Node node3 = this.root;
            node = this.root;
            while (node.right != null) {
                if (node.level != node.right.level + 1) {
                    node3 = node;
                }
                node = node.right;
            }
            node = new Node(node3.right.level + 1, l, this.segmentSize);
            node.left = node3.right;
            node3.right = node;
        }
        this.root.left = node2.next = node;
        return node;
    }

    private class ByteBuffOS
    extends OutputStream {
        private long position = 0L;
        private byte[] ba = new byte[1];

        public ByteBuffOS(long l) {
            this.position = Math.max(0L, l);
        }

        @Override
        public void close() throws IOException {
            this.position = -1L;
        }

        @Override
        public void write(int n) throws IOException {
            this.ba[0] = (byte)(n & 0xFF);
            this.write(this.ba, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.position < 0L) {
                throw new IOException("Stream closed");
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 > 0 && this.position <= ByteBuffer.this.length()) {
                this.position += ByteBuffer.this.write(this.position, byArray, n, n2);
            }
        }
    }

    private class ByteBuffIS
    extends InputStream {
        private long position = 0L;
        private long limit = -1L;
        private long mark = -1L;
        private byte[] ba = new byte[1];

        public ByteBuffIS() {
        }

        public ByteBuffIS(long l, long l2) {
            if (l < 0L || l2 < 0L) {
                l2 = 0L;
                l = 0L;
            }
            this.position = l;
            this.limit = this.position + l2;
        }

        @Override
        public void close() throws IOException {
            this.mark = -1L;
            this.position = -1L;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int n) {
            this.mark = this.position;
        }

        @Override
        public void reset() throws IOException {
            if (this.position < 0L) {
                throw new IOException("Stream closed");
            }
            if (this.mark < 0L) {
                this.mark = 0L;
            }
            this.position = this.mark;
        }

        @Override
        public int available() throws IOException {
            if (this.position < 0L) {
                throw new IOException("Stream closed");
            }
            int n = 0;
            long l = ByteBuffer.this.length();
            if (this.position < l) {
                n = l - this.position > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(l - this.position);
            }
            return n;
        }

        @Override
        public long skip(long l) throws IOException {
            if (this.position < 0L) {
                throw new IOException("Stream closed");
            }
            long l2 = ByteBuffer.this.length();
            if (this.limit >= 0L) {
                l2 = Math.min(l2, this.limit);
            }
            l = Math.max(0L, Math.min(l, l2 - this.position));
            this.position += l;
            return l;
        }

        @Override
        public int read() throws IOException {
            return this.read(this.ba, 0, 1) == 1 ? this.ba[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.position < 0L) {
                throw new IOException("Stream closed");
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            long l = ByteBuffer.this.length();
            if (this.limit >= 0L) {
                l = Math.min(l, this.limit);
            }
            if (this.position >= l) {
                return -1;
            }
            if (n2 == 0) {
                return 0;
            }
            if ((n2 = (int)ByteBuffer.this.read(this.position, byArray, n, (int)Math.min((long)n2, l - this.position))) > 0) {
                this.position += (long)n2;
            } else {
                n2 = -1;
            }
            return n2;
        }
    }

    private static class Node {
        public static final int ROOT = 0;
        public static final int LEAF = 1;
        public int level = 0;
        public long offset = 0L;
        public int length = 0;
        public byte[] data;
        public Node next = null;
        public Node left = null;
        public Node right = null;
        private static final byte[] empty = new byte[0];

        public Node() {
            this.data = empty;
        }

        public Node(long l, int n) {
            this(1, l, n);
        }

        public Node(int n, long l, int n2) {
            this.level = n;
            this.offset = l;
            this.data = new byte[n2];
        }
    }
}

