/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlExFactory;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

class DrvBlob
extends DrvLOB
implements Blob,
DbmsConst {
    public DrvBlob(DrvConn drvConn, int n) {
        super(drvConn, (short)35, n);
        this.title = this.trace.getTraceName() + "-Blob[" + n + "]";
        this.tr_id = "DrvBlob[" + n + "]";
    }

    @Override
    public void free() throws SQLException {
        super.free();
    }

    @Override
    public long length() throws SQLException {
        this.isValid();
        return super.length();
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        this.isValid();
        return super.getBytes(l, n, n <= this.conn.max_vbyt_len);
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.isValid();
        long l2 = super.position(byArray, l);
        return l2 >= 1L ? l2 : -1L;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        if (blob == null) {
            throw new NullPointerException();
        }
        long l2 = -1L;
        this.isValid();
        l2 = blob instanceof DrvLOB && this.hasSameDomain((DrvLOB)((Object)blob)) ? super.position((DrvLOB)((Object)blob), l) : super.position(blob.getBinaryStream(), l);
        return l2 >= 1L ? l2 : -1L;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.isValid();
        return new BufferedInputStream(super.getByteStream(false), this.conn.cnf_lob_segSize);
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.isValid();
        if (l < 1L || l2 < 0L) {
            throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
        }
        return new BufferedInputStream(super.getByteStream(l, l2), this.conn.cnf_lob_segSize);
    }

    public InputStream get() throws SQLException {
        this.isValid();
        return super.getByteStream(true);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }
}

