/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.validator;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.i18n.filter.UntrustedInput;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import org.bouncycastle.x509.CertPathReviewerException;
import org.bouncycastle.x509.PKIXCertPathReviewer;

public class SignedMailValidator {
    private static final String RESOURCE_NAME = "org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";
    private static final String EXT_KEY_USAGE = X509Extensions.ExtendedKeyUsage.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final int shortKeyLength = 512;
    private static final long THIRTY_YEARS_IN_MILLI_SEC = 946728000000L;
    private CertStore certs;
    private SignerInformationStore signers;
    private Map results;
    private String[] fromAddresses;

    public SignedMailValidator(MimeMessage mimeMessage, PKIXParameters pKIXParameters) throws SignedMailValidatorException {
        try {
            SMIMESigned sMIMESigned;
            Address[] addressArray;
            if (mimeMessage.isMimeType("multipart/signed")) {
                addressArray = (Address[])mimeMessage.getContent();
                sMIMESigned = new SMIMESigned((MimeMultipart)addressArray);
            } else if (mimeMessage.isMimeType("application/pkcs7-mime") || mimeMessage.isMimeType("application/x-pkcs7-mime")) {
                sMIMESigned = new SMIMESigned((Part)mimeMessage);
            } else {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noSignedMessage");
                throw new SignedMailValidatorException(errorBundle);
            }
            this.certs = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            this.signers = sMIMESigned.getSignerInfos();
            addressArray = mimeMessage.getFrom();
            this.fromAddresses = new String[addressArray.length];
            for (int i = 0; i < addressArray.length; ++i) {
                int n;
                String string = addressArray[i].toString();
                int n2 = string.indexOf(60);
                if (n2 != -1 && (n = string.indexOf(62, n2)) != -1) {
                    string = string.substring(n2 + 1, n);
                }
                this.fromAddresses[i] = string;
            }
            this.results = new HashMap();
        }
        catch (Exception exception) {
            if (exception instanceof SignedMailValidatorException) {
                throw (SignedMailValidatorException)((Object)exception);
            }
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionReadingMessage", new Object[]{exception.getMessage(), exception});
            throw new SignedMailValidatorException(errorBundle, exception);
        }
        this.validateSignatures(pKIXParameters);
    }

    protected void validateSignatures(PKIXParameters pKIXParameters) {
        PKIXParameters pKIXParameters2 = (PKIXParameters)pKIXParameters.clone();
        pKIXParameters2.addCertStore(this.certs);
        Collection collection = this.signers.getSigners();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ErrorBundle errorBundle;
            List list;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<ErrorBundle> arrayList2 = new ArrayList<ErrorBundle>();
            SignerInformation signerInformation = (SignerInformation)iterator.next();
            X509Certificate x509Certificate = null;
            try {
                list = this.findCerts(pKIXParameters2.getCertStores(), signerInformation.getSID());
                errorBundle = list.iterator();
                if (errorBundle.hasNext()) {
                    x509Certificate = (X509Certificate)errorBundle.next();
                }
            }
            catch (CertStoreException certStoreException) {
                errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionRetrievingSignerCert", new Object[]{certStoreException.getMessage(), certStoreException});
                arrayList.add(errorBundle);
            }
            if (x509Certificate != null) {
                CertPathBuilder certPathBuilder;
                Object object;
                Object object2;
                boolean bl = false;
                try {
                    bl = signerInformation.verify(x509Certificate.getPublicKey(), "BC");
                    if (!bl) {
                        errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.signatureNotVerified");
                        arrayList.add(errorBundle);
                    }
                }
                catch (Exception exception) {
                    object2 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionVerifyingSignature", new Object[]{exception.getMessage(), exception});
                    arrayList.add(object2);
                }
                this.checkSignerCert(x509Certificate, arrayList, arrayList2);
                errorBundle = signerInformation.getSignedAttributes();
                if (errorBundle != null && (object2 = errorBundle.get(PKCSObjectIdentifiers.id_aa_receiptRequest)) != null) {
                    object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.signedReceiptRequest");
                    arrayList2.add((ErrorBundle)object);
                }
                if ((object2 = this.getSignatureTime(signerInformation)) == null) {
                    object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noSigningTime");
                    arrayList.add(object);
                    object2 = new Date();
                } else {
                    try {
                        x509Certificate.checkValidity((Date)object2);
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        certPathBuilder = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certExpired", new Object[]{object2, x509Certificate.getNotAfter()});
                        arrayList.add(certPathBuilder);
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        certPathBuilder = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certNotYetValid", new Object[]{object2, x509Certificate.getNotBefore()});
                        arrayList.add(certPathBuilder);
                    }
                }
                pKIXParameters2.setDate((Date)object2);
                try {
                    X509CertSelector x509CertSelector;
                    try {
                        certPathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
                        x509CertSelector = new X509CertSelector();
                        x509CertSelector.setCertificate(x509Certificate);
                        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(pKIXParameters2.getTrustAnchors(), (CertSelector)x509CertSelector);
                        pKIXBuilderParameters.setDate(pKIXParameters2.getDate());
                        object = certPathBuilder.build(pKIXBuilderParameters).getCertPath();
                    }
                    catch (Exception exception) {
                        object = this.createCertPath(x509Certificate, pKIXParameters2.getTrustAnchors(), pKIXParameters2.getCertStores());
                    }
                    certPathBuilder = new PKIXCertPathReviewer((CertPath)object, pKIXParameters2);
                    if (!certPathBuilder.isValidCertPath()) {
                        x509CertSelector = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certPathInvalid");
                        arrayList.add(x509CertSelector);
                    }
                    this.results.put(signerInformation, new ValidationResult((PKIXCertPathReviewer)certPathBuilder, bl, arrayList, arrayList2));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    certPathBuilder = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.exceptionCreateCertPath", new Object[]{generalSecurityException.getMessage(), generalSecurityException});
                    arrayList.add(certPathBuilder);
                    this.results.put(signerInformation, new ValidationResult(null, bl, arrayList, arrayList2));
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    arrayList.add(certPathReviewerException.getErrorMessage());
                    this.results.put(signerInformation, new ValidationResult(null, bl, arrayList, arrayList2));
                }
                continue;
            }
            list = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noSignerCert");
            arrayList.add(list);
            this.results.put(signerInformation, new ValidationResult(null, false, arrayList, arrayList2));
        }
    }

    protected Vector getEmailAddresses(X509Certificate x509Certificate) {
        Vector<String> vector = new Vector<String>();
        try {
            byte[] byArray;
            String string;
            X509Principal x509Principal = PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate);
            Vector vector2 = x509Principal.getOIDs();
            Vector vector3 = x509Principal.getValues();
            for (int i = 0; i < vector2.size(); ++i) {
                if (!vector2.get(i).equals(X509Principal.EmailAddress)) continue;
                string = (String)vector3.get(i);
                vector.add(string);
                break;
            }
            if ((byArray = x509Certificate.getExtensionValue(SUBJECT_ALTERNATIVE_NAME)) != null) {
                string = (DERSequence)this.getObject(byArray);
                for (int i = 0; i < string.size(); ++i) {
                    ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)string.getObjectAt(i);
                    if (aSN1TaggedObject.getTagNo() != 1) continue;
                    String string2 = DERIA5String.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)true).getString();
                    vector.add(string2);
                }
            }
        }
        catch (Exception exception) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.certGetEmailError", new Object[]{exception.getMessage(), exception});
        }
        return vector;
    }

    private DERObject getObject(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
        aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
        return aSN1InputStream.readObject();
    }

    protected void checkSignerCert(X509Certificate x509Certificate, List list, List list2) {
        ExtendedKeyUsage extendedKeyUsage;
        Object object;
        Object object2;
        long l;
        PublicKey publicKey = x509Certificate.getPublicKey();
        int n = -1;
        if (publicKey instanceof RSAPublicKey) {
            n = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            n = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (n != -1 && n <= 512) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.shortSigningKey", new Object[]{new Integer(n)});
            list2.add(errorBundle);
        }
        if ((l = x509Certificate.getNotAfter().getTime() - x509Certificate.getNotBefore().getTime()) > 946728000000L) {
            object2 = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.longValidity", new Object[]{x509Certificate.getNotBefore(), x509Certificate.getNotAfter()});
            list2.add(object2);
        }
        if ((object2 = x509Certificate.getKeyUsage()) != null && !object2[0] && !object2[1]) {
            object = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.signingNotPermitted");
            list.add(object);
        }
        try {
            object = x509Certificate.getExtensionValue(EXT_KEY_USAGE);
            if (object != null && !(extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)this.getObject((byte[])object))).hasKeyPurposeId(KeyPurposeId.anyExtendedKeyUsage) && !extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_emailProtection)) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.extKeyUsageNotPermitted");
                list.add(errorBundle);
            }
        }
        catch (Exception exception) {
            extendedKeyUsage = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.extKeyUsageError", new Object[]{exception.getMessage(), exception});
        }
        object = this.getEmailAddresses(x509Certificate);
        if (((Vector)object).isEmpty()) {
            extendedKeyUsage = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.noEmailInCert");
            list.add(extendedKeyUsage);
        } else {
            boolean bl = false;
            for (int i = 0; i < this.fromAddresses.length; ++i) {
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    if (!this.fromAddresses[i].equals(((Vector)object).get(j))) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (!bl) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.emailFromCertMismatch", new Object[]{new UntrustedInput((Object)Arrays.toString(this.fromAddresses)), new UntrustedInput(object)});
                list.add(errorBundle);
            }
        }
    }

    protected Date getSignatureTime(SignerInformation signerInformation) {
        Attribute attribute;
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        Date date = null;
        if (attributeTable != null && (attribute = attributeTable.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance((Object)attribute.getAttrValues().getObjectAt(0).getDERObject());
            date = time.getDate();
        }
        return date;
    }

    private List findCerts(List list, X509CertSelector x509CertSelector) throws CertStoreException {
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
        for (CertStore certStore : list) {
            Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    protected CertPath createCertPath(X509Certificate x509Certificate, Set set, List list) throws GeneralSecurityException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        X509Certificate x509Certificate2 = x509Certificate;
        arrayList.add(x509Certificate2);
        boolean bl = false;
        while (x509Certificate2 != null && !bl) {
            Object object2;
            Object object32;
            for (Object object32 : set) {
                object2 = ((TrustAnchor)object32).getTrustedCert();
                if (object2 != null) {
                    if (!((X509Certificate)object2).getSubjectX500Principal().equals(x509Certificate2.getIssuerX500Principal())) continue;
                    try {
                        x509Certificate2.verify(((Certificate)object2).getPublicKey(), "BC");
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!((TrustAnchor)object32).getCAName().equals(x509Certificate2.getIssuerX500Principal().getName())) continue;
                try {
                    x509Certificate2.verify(((TrustAnchor)object32).getCAPublicKey(), "BC");
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (bl) continue;
            object32 = new X509CertSelector();
            ((X509CertSelector)object32).setSubject(x509Certificate2.getIssuerX500Principal());
            object2 = this.findCerts(list, (X509CertSelector)object32).iterator();
            boolean bl2 = false;
            X509Certificate x509Certificate3 = null;
            while (object2.hasNext()) {
                x509Certificate3 = (X509Certificate)object2.next();
                if (x509Certificate3.equals(x509Certificate2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                x509Certificate2 = x509Certificate3;
                arrayList.add(x509Certificate2);
                continue;
            }
            x509Certificate2 = null;
        }
        if (bl) {
            object = new X509CertSelector();
            ((X509CertSelector)object).setSubject(x509Certificate2.getIssuerX500Principal());
            ((X509CertSelector)object).setIssuer(x509Certificate2.getIssuerX500Principal());
            for (Object object2 : this.findCerts(list, (X509CertSelector)object)) {
                try {
                    x509Certificate2.verify(((Certificate)object2).getPublicKey(), "BC");
                    arrayList.add(object2);
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
        }
        object = CertificateFactory.getInstance("X.509", "BC").generateCertPath(arrayList);
        return object;
    }

    public CertStore getCertsAndCRLs() {
        return this.certs;
    }

    public SignerInformationStore getSignerInformationStore() {
        return this.signers;
    }

    public ValidationResult getValidationResult(SignerInformation signerInformation) throws SignedMailValidatorException {
        if (this.signers.getSigners(signerInformation.getSID()).isEmpty()) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.wrongSigner");
            throw new SignedMailValidatorException(errorBundle);
        }
        return (ValidationResult)this.results.get(signerInformation);
    }

    public class ValidationResult {
        private PKIXCertPathReviewer review;
        private List errors;
        private List notifications;
        private boolean signVerified;

        ValidationResult(PKIXCertPathReviewer pKIXCertPathReviewer, boolean bl, List list, List list2) {
            this.review = pKIXCertPathReviewer;
            this.errors = list;
            this.notifications = list2;
            this.signVerified = bl;
        }

        public List getErrors() {
            return this.errors;
        }

        public List getNotifications() {
            return this.notifications;
        }

        public PKIXCertPathReviewer getCertPathReview() {
            return this.review;
        }

        public boolean isVerifiedSignature() {
            return this.signVerified;
        }

        public boolean isValidSignature() {
            if (this.review != null) {
                return this.signVerified && this.review.isValidCertPath() && this.errors.isEmpty();
            }
            return false;
        }
    }
}

