/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import com.gentlyweb.utils.FilterException;
import com.gentlyweb.utils.Getter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class GeneralFilter {
    public static final int EQUALS = 0;
    public static final int NOT_EQUALS = 9;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = 2;
    public static final int CONTAINS = 3;
    public static final int NOT_CONTAINS = 10;
    private static final int IN_RANGE = 4;
    public static final int STARTS_WITH = 5;
    public static final int ENDS_WITH = 6;
    public static final int KEYS = 7;
    public static final int VALUES = 8;
    private List fields = new ArrayList();
    private Class clazz = null;
    private boolean nullAcceptPolicy = false;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$Comparator;
    static /* synthetic */ Class class$java$util$SortedSet;

    public GeneralFilter(Class c) {
        this.clazz = c;
    }

    public void setNullAcceptPolicy(boolean policy) {
        this.nullAcceptPolicy = policy;
    }

    public boolean getNullAcceptPolicy() {
        return this.nullAcceptPolicy;
    }

    public void addField(String field, Date max, Date min) throws IllegalArgumentException {
        this.fields.add(new DateFilterField(field, max, min, null, 4, this.clazz));
    }

    public void setFieldValue(String field, Date max, Date min) throws IllegalArgumentException {
        FilterField ff = this.getField(field);
        if (ff == null) {
            throw new IllegalArgumentException("Field: " + field + " not found.");
        }
        if (!(ff instanceof DateFilterField)) {
            throw new IllegalArgumentException("Field: " + field + " filters on: " + ff.c.getName() + " but expected to filter on: " + (class$java$util$Date == null ? (class$java$util$Date = GeneralFilter.class$("java.util.Date")) : class$java$util$Date).getName());
        }
        DateFilterField f = (DateFilterField)ff;
        f.max = max;
        f.min = min;
    }

    public void addField(String field, Date value, int type) throws IllegalArgumentException {
        this.fields.add(new DateFilterField(field, null, null, value, type, this.clazz));
    }

    public void setFieldValue(String field, Date value) throws IllegalArgumentException {
        FilterField ff = this.getField(field);
        if (ff == null) {
            throw new IllegalArgumentException("Field: " + field + " not found.");
        }
        if (!(ff instanceof DateFilterField)) {
            throw new IllegalArgumentException("Field: " + field + " filters on: " + ff.c.getName() + " but expected to filter on: " + (class$java$util$Date == null ? (class$java$util$Date = GeneralFilter.class$("java.util.Date")) : class$java$util$Date).getName());
        }
        DateFilterField f = (DateFilterField)ff;
        f.value = value;
    }

    public void addField(String field, boolean value, int type) throws IllegalArgumentException {
        this.fields.add(new BooleanFilterField(field, value, type, this.clazz));
    }

    public void setFieldValue(String field, boolean value) throws IllegalArgumentException {
        FilterField ff = this.getField(field);
        if (ff == null) {
            throw new IllegalArgumentException("Field: " + field + " not found.");
        }
        if (!(ff instanceof BooleanFilterField)) {
            throw new IllegalArgumentException("Field: " + field + " filters on: " + ff.c.getName() + " but expected to filter on: " + (class$java$lang$Boolean == null ? (class$java$lang$Boolean = GeneralFilter.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName());
        }
        BooleanFilterField f = (BooleanFilterField)ff;
        f.value = value;
    }

    public void addField(String field, double value, int type) throws IllegalArgumentException {
        this.fields.add(new NumberFilterField(field, 0.0, 0.0, value, type, this.clazz));
    }

    public void setFieldValue(String field, double value) throws IllegalArgumentException {
        FilterField ff = this.getField(field);
        if (ff == null) {
            throw new IllegalArgumentException("Field: " + field + " not found.");
        }
        if (!(ff instanceof NumberFilterField)) {
            throw new IllegalArgumentException("Field: " + field + " filters on: " + ff.c.getName() + " but expected to filter on: " + (class$java$lang$Number == null ? (class$java$lang$Number = GeneralFilter.class$("java.lang.Number")) : class$java$lang$Number).getName());
        }
        NumberFilterField f = (NumberFilterField)ff;
        f.val = value;
    }

    public void addField(String field, double max, double min) {
        this.fields.add(new NumberFilterField(field, max, min, 0.0, 4, this.clazz));
    }

    public void setFieldValue(String field, double max, double min) throws IllegalArgumentException {
        FilterField ff = this.getField(field);
        if (ff == null) {
            throw new IllegalArgumentException("Field: " + field + " not found.");
        }
        if (!(ff instanceof NumberFilterField)) {
            throw new IllegalArgumentException("Field: " + field + " filters on: " + ff.c.getName() + " but expected to filter on: " + (class$java$lang$Number == null ? (class$java$lang$Number = GeneralFilter.class$("java.lang.Number")) : class$java$lang$Number).getName());
        }
        NumberFilterField f = (NumberFilterField)ff;
        f.max = max;
        f.min = min;
    }

    public void addField(String field, String value, int type) throws IllegalArgumentException {
        this.fields.add(new StringFilterField(field, value, type, this.clazz));
    }

    public void setFieldValue(String field, String value) throws IllegalArgumentException {
        FilterField ff = this.getField(field);
        if (ff == null) {
            throw new IllegalArgumentException("Field: " + field + " not found.");
        }
        if (!(ff instanceof StringFilterField)) {
            throw new IllegalArgumentException("Field: " + field + " filters on: " + ff.c.getName() + " but expected to filter on: " + (class$java$lang$String == null ? (class$java$lang$String = GeneralFilter.class$("java.lang.String")) : class$java$lang$String).getName());
        }
        StringFilterField f = (StringFilterField)ff;
        f.val = value;
    }

    public void addField(String field, Object object, int type) throws IllegalArgumentException {
        if (object.getClass().isAssignableFrom(class$java$lang$Comparable == null ? (class$java$lang$Comparable = GeneralFilter.class$("java.lang.Comparable")) : class$java$lang$Comparable)) {
            throw new IllegalArgumentException("Object does implement the: " + (class$java$lang$Comparable == null ? (class$java$lang$Comparable = GeneralFilter.class$("java.lang.Comparable")) : class$java$lang$Comparable).getName() + " interface.");
        }
        this.fields.add(new ObjectFilterField(field, object, null, type, this.clazz));
    }

    public void setFieldValue(String field, Object value) throws IllegalArgumentException {
        FilterField ff = this.getField(field);
        if (ff == null) {
            throw new IllegalArgumentException("Field: " + field + " not found.");
        }
        if (!(ff instanceof ObjectFilterField)) {
            throw new IllegalArgumentException("Field: " + field + " filters on: " + ff.c.getName() + " but expected to filter on: " + (class$java$lang$Object == null ? (class$java$lang$Object = GeneralFilter.class$("java.lang.Object")) : class$java$lang$Object).getName());
        }
        ObjectFilterField f = (ObjectFilterField)ff;
        f.obj = value;
    }

    public void addField(String field, Object object, Comparator comp, int type) throws IllegalArgumentException {
        this.fields.add(new ObjectFilterField(field, object, comp, type, this.clazz));
    }

    private FilterField getField(String field) {
        for (int i = 0; i < this.fields.size(); ++i) {
            FilterField f = (FilterField)this.fields.get(i);
            if (!f.field.equals(field)) continue;
            return f;
        }
        return null;
    }

    public Class getFilterClass() {
        return this.clazz;
    }

    public boolean accept(Object o) throws IllegalAccessException, InvocationTargetException, FilterException {
        for (int i = 0; i < this.fields.size(); ++i) {
            FilterField f = (FilterField)this.fields.get(i);
            if (f.accept(o)) continue;
            return false;
        }
        return true;
    }

    public void filter(Set set, Set newSet) throws IllegalAccessException, InvocationTargetException, FilterException {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!this.accept(o)) continue;
            newSet.add(o);
        }
    }

    public void filter(Set set, List newList) throws IllegalAccessException, InvocationTargetException, FilterException {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!this.accept(o)) continue;
            newList.add(o);
        }
    }

    public void filter(List list, Set newSet) throws IllegalAccessException, InvocationTargetException, FilterException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object o = list.get(i);
            if (!this.accept(o)) continue;
            newSet.add(o);
        }
    }

    public void filter(Map map, int type, Map newMap) throws IllegalAccessException, InvocationTargetException, FilterException {
        if (type != 7 && type != 8) {
            type = 8;
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = map.get(key);
            if (type == 7 && this.accept(key)) {
                newMap.put(key, value);
            }
            if (type != 8 || !this.accept(value)) continue;
            newMap.put(key, value);
        }
    }

    public void filter(Collection collection, Collection newCollection) throws IllegalAccessException, InvocationTargetException, FilterException {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            if (!this.accept(val)) continue;
            newCollection.add(val);
        }
    }

    public void filter(List list, List newList) throws IllegalAccessException, InvocationTargetException, FilterException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object o = list.get(i);
            if (!this.accept(o)) continue;
            newList.add(o);
        }
    }

    public Object[] filter(Object[] objects) throws IllegalAccessException, InvocationTargetException, FilterException {
        ArrayList<Object> l = new ArrayList<Object>();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            if (!this.accept(objects[i])) continue;
            l.add(objects[i]);
        }
        return l.toArray();
    }

    public Map filter(Map map, int type) throws IllegalAccessException, InvocationTargetException, FilterException {
        Class<?> c = map.getClass();
        if (c.isAssignableFrom(class$java$util$SortedMap == null ? (class$java$util$SortedMap = GeneralFilter.class$("java.util.SortedMap")) : class$java$util$SortedMap)) {
            return this.filter((SortedMap)map, type);
        }
        Map nMap = null;
        try {
            nMap = (Map)c.newInstance();
        }
        catch (Exception e) {
            throw new FilterException("Unable to create new instance of: " + map.getClass().getName() + ", root cause: " + e.getMessage(), e);
        }
        this.filter(map, type, nMap);
        return nMap;
    }

    public SortedMap filter(SortedMap map, int type) throws IllegalAccessException, InvocationTargetException, FilterException {
        SortedMap nMap = null;
        try {
            Class[] types = new Class[]{class$java$util$Comparator == null ? (class$java$util$Comparator = GeneralFilter.class$("java.util.Comparator")) : class$java$util$Comparator};
            Constructor<?> con = map.getClass().getConstructor(types);
            try {
                Object[] parms = new Object[]{map.comparator()};
                nMap = (SortedMap)con.newInstance(parms);
            }
            catch (Exception e) {
                throw new FilterException("Unable to create new instance of: " + map.getClass().getName() + " using the constructor that takes a single: " + (class$java$util$Comparator == null ? (class$java$util$Comparator = GeneralFilter.class$("java.util.Comparator")) : class$java$util$Comparator).getName() + " argument, root cause: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            try {
                nMap = (SortedMap)map.getClass().newInstance();
            }
            catch (Exception ee) {
                throw new FilterException("Unable to create a new instance of: " + map.getClass().getName() + ", cannot find no argument constructor or constructor that takes java.util.Comparator as it's only argument, root cause: " + ee.getMessage(), ee);
            }
        }
        this.filter(map, type, nMap);
        return nMap;
    }

    public Collection filter(Collection collection) throws IllegalAccessException, InvocationTargetException, FilterException {
        Class<?> c = collection.getClass();
        if (c.isAssignableFrom(class$java$util$SortedSet == null ? (class$java$util$SortedSet = GeneralFilter.class$("java.util.SortedSet")) : class$java$util$SortedSet)) {
            return this.filter((SortedSet)collection);
        }
        Collection nCol = null;
        try {
            nCol = (Collection)c.newInstance();
        }
        catch (Exception e) {
            throw new FilterException("Unable to create new instance of: " + collection.getClass().getName() + ", root cause: " + e.getMessage(), e);
        }
        this.filter(collection, nCol);
        return nCol;
    }

    public Set filter(Set set) throws IllegalAccessException, InvocationTargetException, FilterException {
        Class<?> c = set.getClass();
        if (c.isAssignableFrom(class$java$util$SortedSet == null ? (class$java$util$SortedSet = GeneralFilter.class$("java.util.SortedSet")) : class$java$util$SortedSet)) {
            return this.filter((SortedSet)set);
        }
        Set nSet = null;
        try {
            nSet = (Set)c.newInstance();
        }
        catch (Exception e) {
            throw new FilterException("Unable to create new instance of: " + set.getClass().getName() + ", root cause: " + e.getMessage(), e);
        }
        this.filter(set, nSet);
        return nSet;
    }

    public SortedSet filter(SortedSet set) throws IllegalAccessException, InvocationTargetException, FilterException {
        SortedSet nSet = null;
        try {
            Class[] types = new Class[]{class$java$util$Comparator == null ? (class$java$util$Comparator = GeneralFilter.class$("java.util.Comparator")) : class$java$util$Comparator};
            Constructor<?> con = set.getClass().getConstructor(types);
            try {
                Object[] parms = new Object[]{set.comparator()};
                nSet = (SortedSet)con.newInstance(parms);
            }
            catch (Exception e) {
                throw new FilterException("Unable to create new instance of: " + set.getClass().getName() + " using the constructor that takes a single: " + (class$java$util$Comparator == null ? (class$java$util$Comparator = GeneralFilter.class$("java.util.Comparator")) : class$java$util$Comparator).getName() + " argument, root cause: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            try {
                nSet = (SortedSet)set.getClass().newInstance();
            }
            catch (Exception ee) {
                throw new FilterException("Unable to create a new instance of: " + set.getClass().getName() + ", cannot find no argument constructor or constructor that takes java.util.Comparator as it's only argument, root cause: " + ee.getMessage(), ee);
            }
        }
        this.filter((Set)set, (Set)nSet);
        return nSet;
    }

    public List filter(List list) throws IllegalAccessException, InvocationTargetException, FilterException {
        Class<?> c = list.getClass();
        List nList = null;
        try {
            nList = (List)c.newInstance();
        }
        catch (Exception e) {
            throw new FilterException("Unable to create new instance of: " + list.getClass().getName() + ", root cause: " + e.getMessage(), e);
        }
        this.filter(list, nList);
        return nList;
    }

    public void filterAndRemove(List list) throws IllegalAccessException, InvocationTargetException, FilterException {
        this.filterAndRemove((Collection)list);
    }

    public void filterAndRemove(Collection col) throws IllegalAccessException, InvocationTargetException, FilterException {
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            if (this.accept(iter.next())) continue;
            iter.remove();
        }
    }

    public void filterAndRemove(Set set) throws IllegalAccessException, InvocationTargetException, FilterException {
        this.filterAndRemove((Collection)set);
    }

    public void filterAndRemove(Map map, int type) throws IllegalAccessException, InvocationTargetException, FilterException {
        if (type != 7 && type != 8) {
            type = 8;
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (type == 7 && !this.accept(key)) {
                iter.remove();
            }
            if (type != 8 || this.accept(map.get(key))) continue;
            iter.remove();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Class: ");
        buf.append(this.clazz.getName());
        buf.append('\n');
        buf.append("  Fields (filter object class/type/field/value[/extras]:\n");
        for (int i = 0; i < this.fields.size(); ++i) {
            buf.append("    ");
            buf.append(this.fields.get(i).toString());
            buf.append('\n');
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private abstract class FilterField {
        protected Getter getter = null;
        private Class c = null;
        private String field = null;

        private FilterField(String field, Class c) throws IllegalArgumentException {
            this.field = field;
            this.c = c;
            this.getter = new Getter(field, c);
        }

        protected Object getValue(Object o) throws IllegalAccessException, InvocationTargetException {
            return this.getter.getValue(o);
        }

        protected String getField() {
            return this.field;
        }

        protected abstract boolean accept(Object var1) throws IllegalAccessException, InvocationTargetException, FilterException;
    }

    private class StringFilterField
    extends FilterField {
        private String val = "";
        private int type = 0;

        private StringFilterField(String field, String value, int type, Class c) throws IllegalArgumentException {
            super(field, c);
            if (type != 0 && type != 9 && type != 3 && type != 10 && type != 5 && type != 6) {
                throw new IllegalArgumentException(type + " is not supported for a String comparison.");
            }
            this.type = type;
            this.val = value;
        }

        public String toString() {
            return (class$java$lang$String == null ? (class$java$lang$String = GeneralFilter.class$("java.lang.String")) : class$java$lang$String).getName() + "/" + this.type + "/" + this.getField() + "/" + this.val;
        }

        protected boolean accept(Object o) throws IllegalAccessException, InvocationTargetException, FilterException {
            Object ro = this.getValue(o);
            if (ro == null) {
                return GeneralFilter.this.getNullAcceptPolicy();
            }
            String v = ro.toString();
            if (this.type == 0 && v.equals(this.val)) {
                return true;
            }
            if (this.type == 9 && !v.equals(this.val)) {
                return true;
            }
            if (this.type == 10 && v.indexOf(this.val) == -1) {
                return true;
            }
            if (this.type == 3 && v.indexOf(this.val) != -1) {
                return true;
            }
            if (this.type == 6 && v.endsWith(this.val)) {
                return true;
            }
            return this.type == 5 && v.startsWith(this.val);
        }
    }

    private class NumberFilterField
    extends FilterField {
        private double max = 0.0;
        private double min = 0.0;
        private double val = 0.0;
        private int type = 0;

        private NumberFilterField(String field, double max, double min, double value, int type, Class c) throws IllegalArgumentException {
            super(field, c);
            if (type != 0 && type != 9 && type != 4 && type != 2 && type != 1) {
                throw new IllegalArgumentException(type + " is not supported for a Number comparison.");
            }
            this.max = max;
            this.min = min;
            this.val = value;
            this.type = type;
        }

        public String toString() {
            return (class$java$lang$Number == null ? (class$java$lang$Number = GeneralFilter.class$("java.lang.Number")) : class$java$lang$Number).getName() + "/" + this.type + "/" + this.getField() + "/" + this.val + "/" + "max:" + this.max + "/" + "min:" + this.min;
        }

        protected boolean accept(Object o) throws IllegalAccessException, InvocationTargetException, FilterException {
            Object v = this.getValue(o);
            if (v == null) {
                return GeneralFilter.this.getNullAcceptPolicy();
            }
            if (!v.getClass().isAssignableFrom(class$java$lang$Number == null ? (class$java$lang$Number = GeneralFilter.class$("java.lang.Number")) : class$java$lang$Number)) {
                throw new FilterException("Type of value returned from getter: " + this.getter.getType().getName() + " is NOT of type: " + (class$java$lang$Number == null ? (class$java$lang$Number = GeneralFilter.class$("java.lang.Number")) : class$java$lang$Number).getName());
            }
            double oVal = ((Number)v).doubleValue();
            if (this.type == 0 && oVal == this.val) {
                return true;
            }
            if (this.type == 9 && oVal != this.val) {
                return true;
            }
            if (this.type == 4 && oVal <= this.max && oVal >= this.min) {
                return true;
            }
            if (this.type == 2 && oVal < this.val) {
                return true;
            }
            return this.type == 1 && oVal > this.val;
        }
    }

    private class DateFilterField
    extends FilterField {
        private Date max = null;
        private Date min = null;
        private Date value = null;
        private int type = 0;

        private DateFilterField(String field, Date max, Date min, Date value, int type, Class c) throws IllegalArgumentException {
            super(field, c);
            if (type != 0 && type != 9 && type != 4 && type != 2 && type != 1) {
                throw new IllegalArgumentException(type + " is not supported for a Date comparison.");
            }
            this.max = max;
            this.min = min;
            this.value = value;
            this.type = type;
        }

        public String toString() {
            return (class$java$util$Date == null ? (class$java$util$Date = GeneralFilter.class$("java.util.Date")) : class$java$util$Date).getName() + "/" + this.type + "/" + this.getField() + "/" + this.value + "/" + "max:" + this.max + "/" + "min:" + this.min;
        }

        protected boolean accept(Object o) throws IllegalAccessException, InvocationTargetException, FilterException {
            Object v = this.getValue(o);
            if (v == null) {
                return GeneralFilter.this.getNullAcceptPolicy();
            }
            if (!v.getClass().isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = GeneralFilter.class$("java.util.Date")) : class$java$util$Date)) {
                throw new FilterException("Type of value returned from getter: " + this.getter.getType().getClass() + " is NOT of type: " + (class$java$util$Date == null ? (class$java$util$Date = GeneralFilter.class$("java.util.Date")) : class$java$util$Date).getName());
            }
            Date d = (Date)v;
            if (this.type == 0 && d.equals(this.value)) {
                return true;
            }
            if (this.type == 9 && !d.equals(this.value)) {
                return true;
            }
            if (this.type == 4) {
                if (d.equals(this.max) || d.equals(this.min)) {
                    return true;
                }
                if (d.before(this.max) && d.after(this.min)) {
                    return true;
                }
            }
            if (this.type == 2 && d.before(this.value)) {
                return true;
            }
            return this.type == 1 && d.after(this.value);
        }
    }

    private class BooleanFilterField
    extends FilterField {
        private boolean value = false;
        private int type = 0;

        private BooleanFilterField(String field, boolean value, int type, Class c) throws IllegalArgumentException {
            super(field, c);
            if (type != 0 && type != 9) {
                throw new IllegalArgumentException(type + " is not supported for a Boolean comparison.");
            }
            this.value = value;
            this.type = type;
        }

        public String toString() {
            return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = GeneralFilter.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName() + "/" + this.type + "/" + this.getField() + "/" + this.value;
        }

        protected boolean accept(Object o) throws IllegalAccessException, InvocationTargetException, FilterException {
            Object v = this.getValue(o);
            if (v == null) {
                return GeneralFilter.this.getNullAcceptPolicy();
            }
            if (!v.getClass().isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = GeneralFilter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                throw new FilterException("Type of value returned from getter: " + this.getter.getType().getName() + " is NOT of type: " + (class$java$lang$Boolean == null ? (class$java$lang$Boolean = GeneralFilter.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName());
            }
            boolean b = (Boolean)v;
            if (this.type == 0 && b == this.value) {
                return true;
            }
            return this.type == 9 && b != this.value;
        }
    }

    private class ObjectFilterField
    extends FilterField {
        private Object obj = null;
        private Comparator comp = null;
        private int type = 0;

        private ObjectFilterField(String field, Object obj, Comparator comp, int type, Class c) throws IllegalArgumentException {
            super(field, c);
            if (type != 0 && type != 9 && type != 2 && type != 1) {
                throw new IllegalArgumentException(type + " is not supported for an Object comparison.");
            }
            this.obj = obj;
            this.comp = comp;
            this.type = type;
        }

        public String toString() {
            return (class$java$lang$Object == null ? (class$java$lang$Object = GeneralFilter.class$("java.lang.Object")) : class$java$lang$Object).getName() + "/" + this.type + "/" + this.getField() + "/" + this.obj.toString() + "/" + this.comp.toString();
        }

        protected boolean accept(Object o) throws IllegalAccessException, InvocationTargetException, FilterException {
            Object v = this.getValue(o);
            if (v == null) {
                return GeneralFilter.this.getNullAcceptPolicy();
            }
            int res = 0;
            if (this.comp != null) {
                res = this.comp.compare(this.obj, v);
            } else {
                Comparable compObj = (Comparable)this.obj;
                res = compObj.compareTo(o);
            }
            if (this.type == 1 && res > 0) {
                return true;
            }
            if (this.type == 2 && res < 0) {
                return true;
            }
            if (this.type == 0 && res == 0) {
                return true;
            }
            return this.type == 9 && res != 0;
        }
    }
}

