/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.templates;

import com.gentlyweb.properties.Properties;
import com.gentlyweb.templates.EmailTemplate;
import com.gentlyweb.utils.IOUtils;
import com.gentlyweb.xml.JDOMUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;

public class TemplateManager {
    public static final String EMAIL = "email";
    public static final String DEPENDS_SEPARATOR = ",";
    private Map templates = new HashMap();
    private Map emailTemplates = new HashMap();
    private Map loadedFiles = new HashMap();

    public TemplateManager() {
    }

    public TemplateManager(File file, String zipExtension, Properties properties) throws JDOMException, IOException {
        this.loadTemplates(file, zipExtension, properties);
    }

    public void loadTemplates(File file, String zipExtension, Properties properties) throws JDOMException, IOException {
        if (this.loadedFiles.containsKey(file)) {
            return;
        }
        Element root = JDOMUtils.getFileAsElement(file, zipExtension);
        JDOMUtils.checkName(root, "templates", true);
        String deps = JDOMUtils.getAttributeValue(root, "depends", false);
        if (!deps.equals("")) {
            StringTokenizer t = new StringTokenizer(deps, DEPENDS_SEPARATOR);
            while (t.hasMoreTokens()) {
                File f;
                String tok = t.nextToken().trim();
                if (tok.startsWith("/")) {
                    f = new File(tok);
                    this.loadTemplates(f, zipExtension, properties);
                    continue;
                }
                f = new File(file.getParentFile().getPath() + "/" + tok);
                this.loadTemplates(f, zipExtension, properties);
            }
        }
        List templateEls = JDOMUtils.getChildElements(root, "template", false);
        for (int i = 0; i < templateEls.size(); ++i) {
            Element el = (Element)templateEls.get(i);
            String id = JDOMUtils.getAttributeValue(el, "id");
            String type = JDOMUtils.getAttributeValue(el, "type", false);
            if (type.equals(EMAIL)) {
                Element bodyEl;
                Element subEl = JDOMUtils.getChildElement(el, "subject", false);
                String subject = null;
                String body = null;
                if (subEl != null) {
                    subject = this.getTemplateContent(subEl, templateEls, properties);
                }
                if ((bodyEl = JDOMUtils.getChildElement(el, "body", false)) != null) {
                    body = this.getTemplateContent(bodyEl, templateEls, properties);
                }
                EmailTemplate eTemp = new EmailTemplate(subject, body);
                if (this.emailTemplates.containsKey(id)) {
                    throw new JDOMException("Found duplicate email template id: " + id + " at: " + JDOMUtils.getPath(el));
                }
                this.emailTemplates.put(id, eTemp);
                continue;
            }
            String content = this.getTemplateContent(el, templateEls, properties);
            if (this.templates.containsKey(id)) {
                throw new JDOMException("Found duplicate template id: " + id + " at: " + JDOMUtils.getPath(el));
            }
            this.templates.put(id, content);
        }
        this.loadedFiles.put(file, file);
    }

    private String getTemplateContent(Element templateEl, List templateEls, Properties properties) throws JDOMException {
        StringBuffer content = new StringBuffer();
        List contentEls = templateEl.getContent();
        if (contentEls.size() == 0) {
            throw new JDOMException("Template: " + JDOMUtils.getPath(templateEl) + " does not contain any content");
        }
        for (int j = 0; j < contentEls.size(); ++j) {
            String eid;
            Object o = contentEls.get(j);
            if (o instanceof String) {
                content.append((String)o);
            }
            if (o instanceof Text) {
                content.append(((Text)o).getText());
            }
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            if (e.getName().equals("file")) {
                StringBuffer b = new StringBuffer();
                List fileContent = e.getContent();
                for (int i = 0; i < fileContent.size(); ++i) {
                    Element propEl;
                    Object oo = fileContent.get(i);
                    if (oo instanceof String) {
                        b.append((String)oo);
                    }
                    if (oo instanceof Text) {
                        b.append(((Text)oo).getText());
                    }
                    if (!(oo instanceof Element) || !(propEl = (Element)oo).getName().equals("property")) continue;
                    String eid2 = JDOMUtils.getAttributeValue(propEl, "id");
                    String v = properties.getProperty(eid2);
                    if (v == null) {
                        throw new JDOMException("Cannot find property: " + eid2 + " referenced by " + JDOMUtils.getPath(propEl));
                    }
                    b.append(v);
                }
                File f = new File(b.toString());
                if (!f.exists()) {
                    throw new JDOMException("Unable to create template: " + JDOMUtils.getPath(templateEl) + " from file: " + f.getPath() + ", file does not exist in file system.");
                }
                try {
                    content.append(IOUtils.getFile(new File(b.toString())));
                }
                catch (Exception ee) {
                    throw new JDOMException("Unable to get contents of file: " + f.getPath() + ", root cause: " + ee.getMessage());
                }
            }
            if (e.getName().equals("property")) {
                eid = JDOMUtils.getAttributeValue(e, "id");
                String val = properties.getProperty(eid);
                if (val == null) {
                    throw new JDOMException("Template: " + JDOMUtils.getPath(e) + " references property: " + eid + " but property has no value.");
                }
                content.append(val);
            }
            if (!e.getName().equals("template")) continue;
            eid = JDOMUtils.getAttributeValue(e, "id");
            Element el = JDOMUtils.getElementWithId("id", eid, templateEls);
            if (el == null) {
                String temp = (String)this.templates.get(eid);
                if (temp == null) {
                    throw new JDOMException("Template: " + JDOMUtils.getPath(e) + " references template: " + eid + " but that template does not exist");
                }
                content.append(temp);
                continue;
            }
            content.append(this.getTemplateContent(el, templateEls, properties));
        }
        return content.toString();
    }

    public EmailTemplate getEmailTemplate(String id) {
        return (EmailTemplate)this.emailTemplates.get(id);
    }

    public String getTemplate(String id) {
        return (String)this.templates.get(id);
    }

    public class XMLConstants {
        public static final String root = "templates";
        public static final String template = "template";
        public static final String id = "id";
        public static final String property = "property";
        public static final String file = "file";
        public static final String type = "type";
        public static final String subject = "subject";
        public static final String body = "body";
        public static final String depends = "depends";
    }
}

