/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet.formatting;

import com.gentlyweb.servlet.ServletUtils;
import com.gentlyweb.servlet.formatting.AnonymousTableFormatter;
import com.gentlyweb.servlet.formatting.FormattingException;
import com.gentlyweb.servlet.formatting.TableFormatter;
import com.gentlyweb.utils.GeneralComparator;
import com.gentlyweb.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class SortableTable {
    private Map columnFieldMap = new HashMap();
    private TableFormatter tf = null;
    protected List columns = null;
    private String headerTemplate = "<td nowrap=\"nowrap\"><table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"><tr><td nowrap=\"nowrap\" class=\"[[HEADER_CLASS]]\">[[COLUMN_NAME]]</td><td><table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td><a [[TARGET]] href=\"[[SERVLET]]?[[SEARCH_PARM_NAME]]=[[ESCAPED_COLUMN_NAME]]&amp;[[DIR_PARM_NAME]]=ASC[[PARMS]]\"><img border=\"0\" src=\"[[UP_ARROW]]\" alt=\"Re-sort in Ascending Order\" /></a></td></tr><tr><td><a [[TARGET]] href=\"[[SERVLET]]?[[SEARCH_PARM_NAME]]=[[ESCAPED_COLUMN_NAME]]&amp;[[DIR_PARM_NAME]]=DESC[[PARMS]]\"><img border=\"0\" src=\"[[DOWN_ARROW]]\" alt=\"Re-sort in Descending Order\" /></a></td></tr></table></td></tr></table></td>";
    private String upImgURL = "up.gif";
    private String downImgURL = "down.gif";
    private String searchParmName = "col";
    private String dirParmName = "dir";
    private String headerClass = "header";
    private Map headerParms = null;
    private Class clazz = null;
    private boolean addTableTags = true;
    private String tableTag = "<table>";
    private String target = null;
    private String startParmName = "start";

    public SortableTable(List columns, TableFormatter tf) {
        this.columns = columns;
        this.tf = tf;
        this.tf.setStartID(this.startParmName);
    }

    public SortableTable(List columns, List fields, Class clazz, AnonymousTableFormatter atf) throws FormattingException, IllegalArgumentException {
        this(columns, atf);
        this.clazz = clazz;
        if (columns.size() != fields.size()) {
            throw new FormattingException("Columns and fields Lists must be of equal size.");
        }
        for (int i = 0; i < columns.size(); ++i) {
            this.columnFieldMap.put(columns.get(i), fields.get(i));
        }
    }

    public SortableTable(List columns, List fields, Class clazz) throws FormattingException, IllegalArgumentException {
        this(columns, fields, clazz, new AnonymousTableFormatter(fields, clazz));
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String t) {
        this.target = t;
    }

    public void setStartParmName(String name) {
        this.tf.setStartID(name);
        this.startParmName = name;
    }

    public String getStartParmName() {
        return this.startParmName;
    }

    public String getDownImageUrl() {
        return this.downImgURL;
    }

    public void setDownImageUrl(String url) {
        this.downImgURL = url;
    }

    public String getUpImageUrl() {
        return this.upImgURL;
    }

    public void setUpImageUrl(String url) {
        this.upImgURL = url;
    }

    public String getHeaderStyleClass() {
        return this.headerClass;
    }

    public void setHeaderStyleClass(String c) {
        this.headerClass = c;
    }

    public String getDirectionParmName() {
        return this.dirParmName;
    }

    public void setDirectionParmName(String name) {
        this.dirParmName = name;
    }

    public String getSearchParmName() {
        return this.searchParmName;
    }

    public void setSearchParmName(String name) {
        this.searchParmName = name;
    }

    public void setTableHeaderColumnTemplate(String temp) {
        this.headerTemplate = temp;
    }

    public void setTableFormatter(TableFormatter tf) {
        this.tf = tf;
    }

    public TableFormatter getTableFormatter() {
        return this.tf;
    }

    public boolean isAddTableTags() {
        return this.addTableTags;
    }

    public void setAddTableTags(boolean val) {
        this.addTableTags = val;
    }

    public String getTableTag() {
        return this.tableTag;
    }

    public void setTableTag(String tag) {
        this.tableTag = tag;
    }

    public void setHeaderParms(Map parms) {
        this.headerParms = parms;
    }

    public Map getHeaderParms() {
        return this.headerParms;
    }

    public String getHeaderRow() {
        StringBuffer buf = new StringBuffer("<tr>");
        for (int i = 0; i < this.columns.size(); ++i) {
            String col = (String)this.columns.get(i);
            String t = StringUtils.replaceString(this.headerTemplate, "[[HEADER_CLASS]]", this.headerClass);
            try {
                String ecol = URLEncoder.encode(col, "utf-8");
                t = StringUtils.replaceString(t, "[[ESCAPED_COLUMN_NAME]]", ecol);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            t = StringUtils.replaceString(t, "[[UP_ARROW]]", this.upImgURL);
            t = StringUtils.replaceString(t, "[[DOWN_ARROW]]", this.downImgURL);
            String hp = "";
            if (this.headerParms != null) {
                hp = "&amp;" + ServletUtils.buildRequestString(this.headerParms);
            }
            t = StringUtils.replaceString(t, "[[PARMS]]", hp);
            t = StringUtils.replaceString(t, "[[SEARCH_PARM_NAME]]", this.searchParmName);
            t = StringUtils.replaceString(t, "[[DIR_PARM_NAME]]", this.dirParmName);
            t = StringUtils.replaceString(t, "[[COLUMN_NAME]]", col);
            String tar = "";
            if (this.target != null) {
                tar = "target=\"" + this.target + "\"";
            }
            t = StringUtils.replaceString(t, "[[TARGET]]", tar);
            t = StringUtils.replaceString(t, "[[SERVLET]]", this.tf.getServletName());
            buf.append(t);
        }
        buf.append("</tr>");
        return buf.toString();
    }

    public String getTable(List objects) throws FormattingException {
        StringBuffer buf = new StringBuffer();
        if (this.addTableTags) {
            buf.append(this.tableTag);
        }
        buf.append(this.getHeaderRow());
        this.tf.setResultsSize(objects.size());
        buf.append(this.tf.format(this.tf.getDisplaySlice(objects)));
        if (this.addTableTags) {
            buf.append("</table>");
        }
        return buf.toString();
    }

    public String getTable(List objects, Comparator comp) throws FormattingException {
        Collections.sort(objects, comp);
        return this.getTable(objects);
    }

    public String getTable(HttpServletRequest request, List objects) throws FormattingException {
        if (this.clazz == null) {
            throw new FormattingException("Illegal state: no class specified for use in GeneralComparator, use the constructor: SortableTable(java.util.List,java.util.List,java.lang.Class) in conjunction with this method.");
        }
        HashMap<String, String> parms = this.tf.getParms();
        if (parms == null) {
            parms = new HashMap<String, String>();
            this.tf.setParms(parms);
        }
        GeneralComparator comp = new GeneralComparator(this.clazz);
        String singleSearchParm = request.getParameter(this.searchParmName);
        if (singleSearchParm != null) {
            String dir = request.getParameter(this.dirParmName);
            if (dir == null) {
                dir = "DESC";
            }
            parms.put(this.searchParmName, singleSearchParm);
            parms.put(this.dirParmName, dir);
            comp.addField((String)this.columnFieldMap.get(request.getParameter(this.searchParmName)), dir);
        } else {
            TreeMap<Integer, String[]> searchFields = new TreeMap<Integer, String[]>();
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                if (!name.startsWith(this.searchParmName)) continue;
                String num = name.substring(this.searchParmName.length());
                try {
                    Integer i = new Integer(num);
                    searchFields.put(i, request.getParameterValues(name));
                }
                catch (NumberFormatException e) {}
            }
            String headerParms = "";
            Iterator iter = searchFields.keySet().iterator();
            while (iter.hasNext()) {
                Integer key = (Integer)iter.next();
                String[] values = (String[])searchFields.get(key);
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    String dir = request.getParameter(this.dirParmName + key.toString());
                    if (dir == null) {
                        dir = "DESC";
                    }
                    parms.put(this.searchParmName + key.toString(), values[i]);
                    parms.put(this.dirParmName + key.toString(), dir);
                    comp.addField((String)this.columnFieldMap.get(values[i]), dir);
                }
            }
        }
        String start = request.getParameter(this.startParmName);
        if (start != null) {
            try {
                int i = Integer.parseInt(start);
                if (i > objects.size()) {
                    this.tf.setStart(0);
                } else {
                    this.tf.setStart(i);
                }
            }
            catch (NumberFormatException e) {
                this.tf.setStart(0);
            }
        }
        return this.getTable(objects, comp);
    }
}

