/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet;

import com.gentlyweb.servlet.Referer;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;

public class RefererManager
implements Runnable,
JDOMXmlOutputter {
    private Map referers = Collections.synchronizedMap(new HashMap());
    private File outputFile = null;
    private boolean overWrite = false;
    private Thread shutdownThread = null;

    public RefererManager() {
    }

    public RefererManager(Element root) throws Exception {
        JDOMUtils.checkName(root, "referers", true);
        List refererEls = JDOMUtils.getChildElements(root, "referer", false);
        for (int i = 0; i < refererEls.size(); ++i) {
            Element el = (Element)refererEls.get(i);
            Referer ref = new Referer(el);
            this.referers.put(ref.getHost(), ref);
        }
    }

    public synchronized void writeToFileAtShutdown(File file, boolean overWrite) throws IllegalArgumentException {
        if (file == null && this.outputFile == null) {
            throw new IllegalArgumentException("Unable to add as shutdown hook since no file specified to write referers to.");
        }
        this.shutdownThread = new Thread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public synchronized void cancelWriteToFileAtShutdown() throws Exception {
        if (this.shutdownThread == null) {
            return;
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        this.shutdownThread = null;
    }

    public synchronized void addReferer(URL pageFrom, URI requestPage, String ipAddr) {
        String host = pageFrom.getHost();
        int port = pageFrom.getPort();
        if (port != -1) {
            host = host + ":" + String.valueOf(port);
        }
        if (this.referers.containsKey(host)) {
            Referer ref = (Referer)this.referers.get(host);
            ref.addHit(requestPage, ipAddr);
        } else {
            Referer ref = new Referer(pageFrom);
            ref.addHit(requestPage, ipAddr);
            this.referers.put(host, ref);
        }
    }

    public synchronized void run() {
        if (this.outputFile == null) {
            return;
        }
        if (this.outputFile.exists() && !this.overWrite) {
            return;
        }
        try {
            JDOMUtils.writeObjectToFile(this, this.outputFile, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Element getAsJDOMElement() {
        Element root = new Element("referers");
        Iterator iter = this.referers.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Referer ref = (Referer)this.referers.get(key);
            root.addContent((Content)ref.getAsJDOMElement());
        }
        return root;
    }

    public class XMLConstants {
        public static final String root = "referers";
        public static final String referer = "referer";
    }
}

