/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet;

import com.gentlyweb.servlet.Hit;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class Referer
implements JDOMXmlOutputter {
    private String host = "";
    private String page = "";
    private Map hits = Collections.synchronizedMap(new HashMap());

    public Referer(URL pageFrom) {
        this.host = pageFrom.getHost();
        int port = pageFrom.getPort();
        if (port != -1) {
            this.host = this.host + ":" + String.valueOf(port);
        }
        this.page = pageFrom.getPath();
    }

    public Referer(Element root) throws Exception {
        JDOMUtils.checkName(root, "referer", true);
        this.host = JDOMUtils.getAttributeValue(root, "host", true);
        this.page = JDOMUtils.getChildElementContent(root, "page");
        List hitEls = JDOMUtils.getChildElements(root, "hit", true);
        for (int i = 0; i < hitEls.size(); ++i) {
            Element e = (Element)hitEls.get(i);
            Hit hit = new Hit(e);
            this.hits.put(hit.getDate(), hit);
        }
    }

    public String getHost() {
        return this.host;
    }

    public synchronized void addHit(URI requestPage, String ipAddr) {
        Hit hit = new Hit(requestPage, ipAddr);
        this.hits.put(hit.getDate(), hit);
    }

    public synchronized Element getAsJDOMElement() {
        Element root = new Element("referer");
        root.setAttribute("host", this.host);
        Element page = new Element("page");
        page.addContent((Content)new CDATA(this.page));
        root.addContent((Content)page);
        Iterator iter = this.hits.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Hit hit = (Hit)this.hits.get(key);
            root.addContent((Content)hit.getAsJDOMElement());
        }
        return root;
    }

    public class XMLConstants {
        public static final String root = "referer";
        public static final String page = "page";
        public static final String hit = "hit";
        public static final String host = "host";
    }
}

