/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet;

import com.gentlyweb.properties.Properties;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.servlet.PageOutputterException;
import com.gentlyweb.servlet.Parameters;
import com.gentlyweb.utils.IOUtils;
import com.gentlyweb.utils.StringUtils;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.Xml2Html;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;

public class PageOutputter {
    public static final String URI_TAG = "[[URI]]";
    public static final String REMOTE_ADDR_TAG = "[[REMOTE_ADDR]]";
    public static final String PROTOCOL_TAG = "[[PROTOCOL]]";
    public static final String CONTENT_TYPE_TAG = "[[CONTENT_TYPE]]";
    public static final String CONTENT_LENGTH_TAG = "[[CONTENT_LENGTH]]";
    public static final String METHOD_TAG = "[[METHOD]]";
    public static final String PATH_INFO_TAG = "[[PATH_INFO]]";
    public static final String NAME_TAG = "[[NAME]]";
    public static final String VALUE_TAG = "[[VALUE]]";
    public static final String DATA_TAG = "[[DATA]]";
    public static final String REMOTE_USER_TAG = "[[REMOTE_USER]]";
    public static final String SESSION_TAG = "[[SESSION]]";
    public static final String REQUEST_HEADERS_TAG = "[[REQ_HEADERS]]";
    public static final String PARAMETERS_TAG = "[[PARAMETERS]]";
    public static final String COOKIES_TAG = "[[COOKIES]]";
    public static final String RESPONSE_HEADERS_TAG = "[[REQ_HEADERS]]";
    public static final String RESPONSE_CONTENT_TYPE = "[[RES_CONTENT_TYPE]]";
    public static final String CONTENT_TAG = "[[CONTENT]]";
    public static final String ID_TAG = "[[ID]]";
    public static final String CREATE_TIME_TAG = "[[CREATE_TIME]]";
    public static final String EXPIRES_TIME_TAG = "[[EXPIRES_TIME]]";
    public static final String LAST_ACCESS_TIME_TAG = "[[LAST_ACCESS_TIME]]";
    public static String DEFAULT_SHOW_PAGE_DETAILS_PARAMETER_NAME = "_showDetails";
    public static String DEFAULT_OVERRIDE_PARAMETER_NAME = "_override";
    public static String DEFAULT_HTMLIZE_PARAMETER_NAME = "_htmlize";
    public static String DEFAULT_CHARSET = "iso-8859-1";
    public static final String HTML = "html";
    public static final String PDF = "pdf";
    public static final String COMPRESS = "compress";
    public static final String PRETTIFY = "prettify";
    public static final String LEAVE = "leave";
    private Map settings = new HashMap();
    private String dataTableTemplate = null;
    private String dataRowTemplate = null;
    private String pageDetailsTemplate = null;
    private String sessionDataTemplate = null;
    private String sessionDateFormat = null;

    public PageOutputter(File file, String zipExtension) throws IOException, JDOMException, PropertyException {
        Element pdtEl;
        Element root = JDOMUtils.getFileAsElement(file, zipExtension);
        JDOMUtils.checkName(root, "outputter", true);
        this.dataRowTemplate = JDOMUtils.getChildElementContent(root, "dataRowTemplate", false);
        this.dataTableTemplate = JDOMUtils.getChildElementContent(root, "dataTableTemplate", false);
        Element sdEl = JDOMUtils.getChildElement(root, "sessionDataTemplate", false);
        if (sdEl != null) {
            this.sessionDataTemplate = JDOMUtils.getChildElementContent(root, "sessionDataTemplate", false);
            this.sessionDateFormat = JDOMUtils.getAttributeValue(sdEl, "dateFormat");
        }
        if ((pdtEl = JDOMUtils.getChildElement(root, "pageDetailsTemplate", false)) != null) {
            List content = pdtEl.getContent();
            if (content.size() == 0) {
                throw new JDOMException("Expected element: " + JDOMUtils.getPath(pdtEl) + " to contain either string content or a: " + "file" + " element pointing to a file within the file system.");
            }
            if (content.get(0) instanceof Element) {
                Element fEl = (Element)content.get(0);
                JDOMUtils.checkName(fEl, "file", false);
                File f = new File(JDOMUtils.getChildContent(fEl));
                this.pageDetailsTemplate = IOUtils.getFile(f);
            } else {
                this.pageDetailsTemplate = JDOMUtils.getChildContent(pdtEl);
            }
        }
        List els = JDOMUtils.getChildElements(root, "pageType", false);
        for (int i = 0; i < els.size(); ++i) {
            Element el = (Element)els.get(i);
            PageSettings ps = new PageSettings(el, zipExtension);
            if (this.settings.containsKey(ps.getID())) {
                throw new JDOMException("Found repeated page type id: " + ps.getID() + " at: " + JDOMUtils.getPath(el));
            }
            this.settings.put(ps.getID(), ps);
        }
    }

    private String generatePageDetails(Parameters params, HttpServletResponse response, PageSettings settings) {
        int i;
        StringBuffer buf;
        String t = this.pageDetailsTemplate;
        HttpServletRequest request = params.getRequest();
        t = StringUtils.replaceString(t, URI_TAG, request.getRequestURI());
        t = StringUtils.replaceString(t, REMOTE_ADDR_TAG, request.getRemoteAddr());
        t = StringUtils.replaceString(t, PROTOCOL_TAG, request.getProtocol());
        String cType = request.getContentType();
        if (cType == null) {
            cType = "No Content Type Specified";
        }
        t = StringUtils.replaceString(t, CONTENT_TYPE_TAG, cType);
        t = StringUtils.replaceString(t, CONTENT_LENGTH_TAG, String.valueOf(request.getContentLength()));
        t = StringUtils.replaceString(t, METHOD_TAG, request.getMethod());
        String pInfo = request.getPathInfo();
        if (pInfo == null) {
            pInfo = "";
        }
        t = StringUtils.replaceString(t, PATH_INFO_TAG, pInfo);
        String rUser = request.getRemoteUser();
        if (rUser == null) {
            rUser = "";
        }
        t = StringUtils.replaceString(t, REMOTE_USER_TAG, rUser);
        HttpSession ses = request.getSession(false);
        String sesData = "No Current Session";
        if (ses != null) {
            String sT = this.sessionDataTemplate;
            SimpleDateFormat sd = new SimpleDateFormat(this.sessionDateFormat);
            sT = StringUtils.replaceString(sT, ID_TAG, ses.getId());
            sT = StringUtils.replaceString(sT, CREATE_TIME_TAG, sd.format(new Date(ses.getCreationTime())));
            sT = StringUtils.replaceString(sT, LAST_ACCESS_TIME_TAG, sd.format(new Date(ses.getLastAccessedTime())));
            sesData = sT = StringUtils.replaceString(sT, EXPIRES_TIME_TAG, String.valueOf(ses.getMaxInactiveInterval()));
        }
        t = StringUtils.replaceString(t, SESSION_TAG, sesData);
        Enumeration hEnum = request.getHeaderNames();
        ArrayList hNames = new ArrayList();
        while (hEnum.hasMoreElements()) {
            hNames.add(hEnum.nextElement());
        }
        Collections.sort(hNames);
        String rT = this.dataRowTemplate;
        String dT = this.dataTableTemplate;
        StringBuffer headers = new StringBuffer();
        for (int i2 = 0; i2 < hNames.size(); ++i2) {
            String n = (String)hNames.get(i2);
            String v = request.getHeader(n);
            String s = StringUtils.replaceString(rT, NAME_TAG, n);
            s = StringUtils.replaceString(s, VALUE_TAG, v);
            headers.append(s);
        }
        String d = StringUtils.replaceString(dT, DATA_TAG, headers.toString());
        t = StringUtils.replaceString(t, "[[REQ_HEADERS]]", d);
        String parms = "No parameters";
        if (cType != null) {
            Iterator iter = params.iterator();
            ArrayList pNames = new ArrayList();
            while (iter.hasNext()) {
                pNames.add(iter.next());
            }
            Collections.sort(pNames);
            buf = new StringBuffer();
            for (i = 0; i < pNames.size(); ++i) {
                String n = (String)pNames.get(i);
                List vs = params.getParameterValues(n);
                StringBuffer vals = new StringBuffer();
                for (int j = 0; j < vs.size(); ++j) {
                    vals.append(vs.get(j));
                    if (j >= vs.size() - 1) continue;
                    vals.append("<br />");
                }
                String s = StringUtils.replaceString(rT, NAME_TAG, n);
                s = StringUtils.replaceString(s, VALUE_TAG, vals.toString());
                buf.append(s);
            }
            if (buf.length() > 0) {
                parms = StringUtils.replaceString(dT, DATA_TAG, buf.toString());
            }
        }
        t = StringUtils.replaceString(t, PARAMETERS_TAG, parms);
        Cookie[] cs = request.getCookies();
        String cookies = "No Cookies";
        if (cs != null) {
            buf = new StringBuffer();
            for (i = 0; i < cs.length; ++i) {
                Cookie c = cs[i];
                String s = StringUtils.replaceString(rT, NAME_TAG, c.getName());
                s = StringUtils.replaceString(s, VALUE_TAG, c.getValue());
                buf.append(s);
            }
            cookies = StringUtils.replaceString(dT, DATA_TAG, buf.toString());
        }
        t = StringUtils.replaceString(t, COOKIES_TAG, cookies);
        return t;
    }

    public void outputTextPage(Parameters parms, HttpServletResponse response, String type, String page) throws IOException, PageOutputterException {
        Map headers;
        PageSettings settings = (PageSettings)this.settings.get(type);
        if (settings == null) {
            throw new PageOutputterException("No output settings available for type: " + type);
        }
        if (parms.getParameter(settings.getShowPageDetailsParameterName()) != null) {
            page = this.generatePageDetails(parms, response, settings);
        }
        if ((headers = settings.getHeaders()) != null) {
            Iterator iter = headers.keySet().iterator();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                Object v = headers.get(k);
                if (v instanceof Integer) {
                    response.setIntHeader(k, ((Integer)v).intValue());
                }
                if (v instanceof String) {
                    response.setHeader(k, (String)v);
                }
                if (!(v instanceof Date)) continue;
                response.setDateHeader(k, ((Date)v).getTime());
            }
        }
        String ct = settings.getContentType();
        String cs = settings.getCharSet();
        if (cs != null) {
            ct = ct + "; charset=" + cs;
        }
        response.setContentType(ct);
        if (settings.isXml()) {
            String overridePolicy = parms.getParameter(settings.getOverrideParameterName());
            String policy = settings.getDefaultOutputPolicy();
            if (overridePolicy != null) {
                policy = overridePolicy;
            }
            if (parms.getParameter(settings.getHtmlizeParameterName()) != null) {
                try {
                    page = Xml2Html.htmlizeXML(page, settings.getHtml2XmlProperties());
                    String p = settings.getHtmlWrapperPageTemplate();
                    page = StringUtils.replaceString(p, settings.getReplaceTag(), page);
                }
                catch (Exception e) {
                    throw new PageOutputterException("Unable to htmlize page for type: " + type, e);
                }
            }
            try {
                if (policy.equals(COMPRESS)) {
                    page = JDOMUtils.compressXML(page);
                }
                if (policy.equals(PRETTIFY)) {
                    page = JDOMUtils.prettifyXML(page);
                }
            }
            catch (Exception e) {
                throw new PageOutputterException("Unable to: " + policy + " page.", e);
            }
        }
        response.setBufferSize(settings.getBufferSize());
        PrintWriter out = response.getWriter();
        out.print(page);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputBinaryPage(Parameters parms, HttpServletResponse response, String type, InputStream in) throws IOException, PageOutputterException {
        PageSettings settings = (PageSettings)this.settings.get(type);
        if (settings == null) {
            throw new PageOutputterException("No output settings available for type: " + type);
        }
        Map headers = settings.getHeaders();
        if (headers != null) {
            Iterator iter = headers.keySet().iterator();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                Object v = headers.get(k);
                if (v instanceof Integer) {
                    response.setIntHeader(k, ((Integer)v).intValue());
                }
                if (v instanceof String) {
                    response.setHeader(k, (String)v);
                }
                if (!(v instanceof Date)) continue;
                response.setDateHeader(k, ((Date)v).getTime());
            }
        }
        String ct = settings.getContentType();
        response.setContentType(ct);
        response.setBufferSize(settings.getBufferSize());
        ServletOutputStream s = response.getOutputStream();
        InputStream bin = in;
        if (!(in instanceof BufferedInputStream)) {
            bin = new BufferedInputStream(in, settings.getBufferSize());
        }
        try {
            byte[] buf = new byte[settings.getBufferSize()];
            int bytesRead = -1;
            int totalBytes = 0;
            while ((bytesRead = bin.read(buf)) != -1) {
                s.write(buf, 0, bytesRead);
                totalBytes += bytesRead;
            }
            response.setContentLength(totalBytes);
            s.flush();
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public void outputBinaryPage(Parameters parms, HttpServletResponse response, String type, byte[] page) throws IOException, PageOutputterException {
        PageSettings settings = (PageSettings)this.settings.get(type);
        if (settings == null) {
            throw new PageOutputterException("No output settings available for type: " + type);
        }
        Map headers = settings.getHeaders();
        if (headers != null) {
            Iterator iter = headers.keySet().iterator();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                Object v = headers.get(k);
                if (v instanceof Integer) {
                    response.setIntHeader(k, ((Integer)v).intValue());
                }
                if (v instanceof String) {
                    response.setHeader(k, (String)v);
                }
                if (!(v instanceof Date)) continue;
                response.setDateHeader(k, ((Date)v).getTime());
            }
        }
        String ct = settings.getContentType();
        response.setContentType(ct);
        ServletOutputStream s = response.getOutputStream();
        response.setContentLength(page.length);
        s.write(page);
        s.flush();
    }

    public void outputTextPage(HttpServletRequest request, HttpServletResponse response, String type, String page) throws IOException, PageOutputterException {
        this.outputTextPage(new Parameters(request), response, type, page);
    }

    public void outputHTMLPage(Parameters parms, HttpServletResponse response, String page) throws IOException, PageOutputterException {
        this.outputTextPage(parms, response, HTML, page);
    }

    public void outputHTMLPage(HttpServletRequest request, HttpServletResponse response, String page) throws IOException, PageOutputterException {
        this.outputTextPage(request, response, HTML, page);
    }

    public void outputPDFPage(HttpServletRequest request, HttpServletResponse response, byte[] page) throws IOException, PageOutputterException {
        this.outputBinaryPage(new Parameters(request), response, PDF, page);
    }

    public class PageSettings {
        public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 4096;
        private String id = null;
        private String contentType = null;
        private String charSet = DEFAULT_CHARSET;
        private boolean isXml = false;
        private String defaultPolicy = "leave";
        private String overrideParmName = DEFAULT_OVERRIDE_PARAMETER_NAME;
        private String htmlizeParmName = DEFAULT_HTMLIZE_PARAMETER_NAME;
        private Properties html2XmlProperties = null;
        private String htmlWrapperPage = null;
        private String htmlReplaceTag = null;
        private String showPageDetailsParmName = DEFAULT_SHOW_PAGE_DETAILS_PARAMETER_NAME;
        private Map headers = new HashMap();
        private int bufSize = -1;

        public PageSettings(Element root, String zipExtension) throws JDOMException, IOException, PropertyException {
            Element hwpEl;
            Attribute spdA;
            Attribute hpnA;
            Attribute opnA;
            JDOMUtils.checkName(root, "pageType", true);
            this.id = JDOMUtils.getAttributeValue(root, "id");
            this.bufSize = JDOMUtils.getAttributeValueAsInt(root, "bufferSize", false);
            if (this.bufSize == 0) {
                this.bufSize = 4096;
            }
            this.contentType = JDOMUtils.getAttributeValue(root, "contentType");
            Attribute csA = root.getAttribute("charSet");
            if (csA != null) {
                this.charSet = JDOMUtils.getAttributeValue(root, "charSet");
            }
            this.isXml = JDOMUtils.getAttributeValueAsBoolean(root, "isXml", false);
            Attribute dopA = root.getAttribute("defaultOutputPolicy");
            if (dopA != null) {
                this.defaultPolicy = JDOMUtils.getAttributeValue(root, "defaultOutputPolicy");
            }
            if ((opnA = root.getAttribute("overrideParameterName")) != null) {
                this.overrideParmName = JDOMUtils.getAttributeValue(root, "overrideParameterName");
            }
            if ((hpnA = root.getAttribute("htmlizeParameterName")) != null) {
                this.htmlizeParmName = JDOMUtils.getAttributeValue(root, "htmlizeParameterName");
            }
            if ((spdA = root.getAttribute("showPageDetailsParameterName")) != null) {
                this.showPageDetailsParmName = JDOMUtils.getAttributeValue(root, "showPageDetailsParameterName");
            }
            List hEls = JDOMUtils.getChildElementSet(root, "headers", "header", false);
            for (int i = 0; i < hEls.size(); ++i) {
                Element e = (Element)hEls.get(i);
                String id = JDOMUtils.getAttributeValue(e, "id");
                String value = JDOMUtils.getChildContent(e);
                if (value.equals("")) {
                    throw new JDOMException("Element: " + JDOMUtils.getPath(e) + " contains no content.");
                }
                if (this.headers.containsKey(id)) {
                    throw new JDOMException("Found repeated header: " + id + " at: " + JDOMUtils.getPath(e));
                }
                this.headers.put(id, value);
            }
            Element propsEl = JDOMUtils.getChildElement(root, "html2XmlProperties", false);
            if (propsEl != null) {
                String fName = JDOMUtils.getChildContent(propsEl);
                if (fName.equals("")) {
                    throw new JDOMException("Expected file name in element: " + JDOMUtils.getPath(propsEl));
                }
                this.html2XmlProperties = new Properties(new File(fName), zipExtension);
            }
            if ((hwpEl = JDOMUtils.getChildElement(root, "htmlWrapperPage", false)) != null) {
                this.htmlReplaceTag = JDOMUtils.getAttributeValue(hwpEl, "replaceTag");
                List content = hwpEl.getContent();
                if (content.size() == 0) {
                    throw new JDOMException("Expected element: " + JDOMUtils.getPath(hwpEl) + " to contain either string content or a: " + "file" + " element pointing to a file within the file system.");
                }
                if (content.get(0) instanceof Element) {
                    Element fEl = (Element)content.get(0);
                    JDOMUtils.checkName(fEl, "file", false);
                    File f = new File(JDOMUtils.getChildContent(fEl));
                    this.htmlWrapperPage = IOUtils.getFile(f);
                } else {
                    this.htmlWrapperPage = JDOMUtils.getChildContent(hwpEl);
                }
            }
        }

        public int getBufferSize() {
            return this.bufSize;
        }

        public String getOverrideParameterName() {
            return this.overrideParmName;
        }

        public Properties getHtml2XmlProperties() {
            return this.html2XmlProperties;
        }

        public String getDefaultOutputPolicy() {
            return this.defaultPolicy;
        }

        public boolean isXml() {
            return this.isXml;
        }

        public String getShowPageDetailsParameterName() {
            return this.showPageDetailsParmName;
        }

        public String getHtmlizeParameterName() {
            return this.htmlizeParmName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getCharSet() {
            return this.charSet;
        }

        public String getID() {
            return this.id;
        }

        public Map getHeaders() {
            return this.headers;
        }

        public String getReplaceTag() {
            return this.htmlReplaceTag;
        }

        public String getHtmlWrapperPageTemplate() {
            return this.htmlWrapperPage;
        }

        public class XMLConstants {
            public static final String id = "id";
            public static final String root = "pageType";
            public static final String contentType = "contentType";
            public static final String charSet = "charSet";
            public static final String isXml = "isXml";
            public static final String defaultOutputPolicy = "defaultOutputPolicy";
            public static final String overrideParameterName = "overrideParameterName";
            public static final String htmlizeParameterName = "htmlizeParameterName";
            public static final String headers = "headers";
            public static final String header = "header";
            public static final String html2XmlProperties = "html2XmlProperties";
            public static final String file = "file";
            public static final String replaceTag = "replaceTag";
            public static final String htmlWrapperPage = "htmlWrapperPage";
            public static final String showPageDetailsParameterName = "showPageDetailsParameterName";
            public static final String bufferSize = "bufferSize";
        }
    }

    public class XMLConstants {
        public static final String root = "outputter";
        public static final String pageType = "pageType";
        public static final String pageDetailsTemplate = "pageDetailsTemplate";
        public static final String file = "file";
        public static final String dataTableTemplate = "dataTableTemplate";
        public static final String dataRowTemplate = "dataRowTemplate";
        public static final String sessionDataTemplate = "sessionDataTemplate";
        public static final String dateFormat = "dateFormat";
    }
}

