/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.properties;

import com.gentlyweb.properties.AbstractProperty;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.xml.JDOMUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class NumberProperty
extends AbstractProperty {
    protected double val = -1.0;
    protected double max = 0.0;
    protected double min = 0.0;
    protected boolean hasMax = false;
    protected boolean hasMin = false;

    public NumberProperty(String id, double f) {
        super(id, String.valueOf(f), "number");
        this.val = f;
    }

    public NumberProperty(String id, double f, double max, double min) throws PropertyException {
        super(id, String.valueOf(f), "number");
        this.val = f;
        if (this.val > max) {
            throw new PropertyException("Property: " + id + " with value: " + f + ": is greater than specified max value: " + max);
        }
        if (this.val > min) {
            throw new PropertyException("Property: " + id + " with value: " + f + ": is less than specified min value: " + min);
        }
    }

    public void setNoMax(boolean v) {
        this.hasMax = v;
    }

    public void setNoMin(boolean v) {
        this.hasMin = v;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double f) {
        this.min = f;
        this.hasMin = true;
    }

    public boolean hasMax() {
        return this.hasMax;
    }

    public boolean hasMin() {
        return this.hasMin;
    }

    public void setMax(double f) {
        this.max = f;
        this.hasMax = true;
    }

    public NumberProperty(Element root, String id, String type, String value) throws JDOMException, PropertyException {
        super(root, id, type, value);
        try {
            this.val = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyException("Property: " + JDOMUtils.getPath(root) + " with value: " + value + ": is not a valid number", e);
        }
        if (root.getAttribute("max") != null) {
            this.max = JDOMUtils.getAttributeValueAsDouble(root, "max");
            if (this.val > this.max) {
                throw new PropertyException("Property: " + JDOMUtils.getPath(root) + " with value: " + value + ": is greater than specified max value: " + this.max);
            }
            this.hasMax = true;
        }
        if (root.getAttribute("min") != null) {
            this.min = JDOMUtils.getAttributeValueAsDouble(root, "min");
            if (this.min > this.val) {
                throw new PropertyException("Property: " + JDOMUtils.getPath(root) + " with value: " + value + ": is less than specified min value: " + this.min);
            }
            this.hasMin = true;
        }
    }

    public int getInteger() {
        return (int)this.val;
    }

    public float getFloat() {
        return (float)this.val;
    }

    public double getDouble() {
        return this.val;
    }

    public Element getAsJDOMElement() {
        Element root = super.getAsJDOMElement();
        if (this.hasMax) {
            root.setAttribute("max", String.valueOf(this.max));
        }
        if (this.hasMin) {
            root.setAttribute("min", String.valueOf(this.min));
        }
        return root;
    }

    public class XMLConstants {
        public static final String max = "max";
        public static final String min = "min";
    }
}

