/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.properties;

import com.gentlyweb.properties.AbstractProperty;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.xml.JDOMUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class EnumeratedProperty
extends AbstractProperty {
    private Set values = new HashSet();

    public EnumeratedProperty(String id, String value, Set values) {
        super(id, value, "enum");
        this.values = values;
    }

    public EnumeratedProperty(String id, String value, List values) {
        super(id, value, "enum");
        if (values == null) {
            values = new ArrayList<String>();
            values.add(value);
        }
        this.values.addAll(values);
    }

    public EnumeratedProperty(Element root, String id, String type, String value) throws JDOMException, PropertyException {
        super(root, id, type, value);
        String vals = JDOMUtils.getAttributeValue(root, "values", false);
        StringTokenizer t = new StringTokenizer(vals, ",");
        while (t.hasMoreTokens()) {
            this.values.add(t.nextToken());
        }
        List childValues = JDOMUtils.getChildElementsContent(root, "option", false);
        this.values.addAll(childValues);
        if (!this.values.contains(value)) {
            throw new PropertyException("Property: " + JDOMUtils.getPath(root) + " with value: " + value + " is not one of the defined enumerated values");
        }
    }

    public Set getValues() {
        return this.values;
    }

    public boolean isValueValid(String value) {
        return this.values.contains(value);
    }

    public Element getAsJDOMElement() {
        Element root = super.getAsJDOMElement();
        Iterator iter = this.values.iterator();
        while (iter.hasNext()) {
            Element opt = new Element("option");
            opt.addContent((Content)new CDATA(iter.next().toString()));
            root.addContent((Content)opt);
        }
        return root;
    }

    public class XMLConstants {
        public static final String values = "values";
        public static final String value = "value";
        public static final String option = "option";
    }
}

