/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.properties;

import com.gentlyweb.properties.AbstractProperty;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.xml.JDOMUtils;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jdom.JDOMException;

public class EmailProperty
extends AbstractProperty {
    public EmailProperty(String id, String email) throws PropertyException {
        super(id, email, "email");
        this.init(null, id, email);
    }

    public EmailProperty(Element parent, String id, String type, String value) throws PropertyException, JDOMException {
        super(parent, id, type, value);
        this.init(parent, null, value);
    }

    private void init(Element parent, String pid, String value) throws PropertyException {
        StringTokenizer t;
        String prop = pid;
        if (parent != null) {
            prop = JDOMUtils.getPath(parent);
        }
        if ((t = new StringTokenizer(value, "@")).countTokens() != 2) {
            throw new PropertyException("Property: " + prop + " does not appear to be an email address");
        }
        String left = t.nextToken();
        String right = t.nextToken();
        if (left.length() == 0 || right.length() == 0) {
            throw new PropertyException("Property: " + prop + " does not appear to be an email address");
        }
        StringTokenizer tt = new StringTokenizer(right, ".");
        if (tt.countTokens() < 2) {
            throw new PropertyException("Property: " + prop + " does not appear to be an email address");
        }
        String l = tt.nextToken();
        String r = tt.nextToken();
        if (l.length() == 0 || r.length() == 0) {
            throw new PropertyException("Property: " + prop + " does not appear to be an email address");
        }
    }
}

