/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.properties;

import com.gentlyweb.properties.AbstractProperty;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.xml.JDOMUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ClassProperty
extends AbstractProperty {
    private boolean loadClass = false;

    public ClassProperty(String id, Class c) {
        super(id, c.getName(), "class");
    }

    public void setLoadClass(boolean c) {
        this.loadClass = c;
    }

    public ClassProperty(Element parent, String id, String type, String value) throws JDOMException, PropertyException {
        super(parent, id, type, value);
        this.loadClass = JDOMUtils.getAttributeValueAsBoolean(parent, "loadClass", false);
        if (this.loadClass) {
            try {
                Class.forName(value);
            }
            catch (Exception e) {
                throw new PropertyException("Property: " + id + " with value: " + value + " does not appear to be a valid class", e);
            }
        }
    }

    public Class getClazz() {
        try {
            return Class.forName(this.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Element getAsJDOMElement() {
        Element root = super.getAsJDOMElement();
        root.setAttribute("loadClass", Boolean.toString(this.loadClass));
        return root;
    }

    public class XMLConstants {
        public static final String loadClass = "loadClass";
    }
}

