/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.properties;

import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class AbstractProperty
implements Comparable,
JDOMXmlOutputter {
    protected String id = "";
    private String type = "";
    protected String desc = "";
    protected String value = "";

    public AbstractProperty(String id, String value, String type) {
        this.value = value;
        this.id = id;
        this.type = type;
    }

    public AbstractProperty(Element parent, String id, String type, String value) throws JDOMException {
        this.id = id;
        this.type = type;
        this.value = value;
        Element descEl = JDOMUtils.getChildElement(parent, "description", false);
        if (descEl != null) {
            this.desc = JDOMUtils.getChildContent(descEl);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getID() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public boolean contains(String val) {
        return this.value.indexOf(val) != -1;
    }

    public int compareTo(Object o) {
        AbstractProperty s = (AbstractProperty)o;
        return this.value.compareTo(s.getValue());
    }

    public Element getAsJDOMElement() {
        Element root = new Element("property");
        root.setAttribute("id", this.id);
        root.setAttribute("type", this.type);
        Element desc = new Element("description");
        desc.addContent((Content)new CDATA(this.desc));
        root.addContent((Content)desc);
        Element val = new Element("value");
        val.addContent((Content)new CDATA(this.value));
        root.addContent((Content)val);
        return root;
    }

    protected void setType(String t) {
        this.type = t;
    }

    public class XMLConstants {
        public static final String description = "description";
    }
}

