/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.jsql;

import com.gentlyweb.jsql.Clause;
import com.gentlyweb.jsql.ClauseFactory;
import com.gentlyweb.jsql.Query;
import com.gentlyweb.jsql.QueryExecutionException;
import com.gentlyweb.jsql.QueryParseException;
import com.gentlyweb.utils.StringUtils;

public class WhereClause
extends Clause {
    private static final String AND = " and ";
    private static final String OR = " or ";
    private Clause left = null;
    private String joinBy = null;
    private Clause right = null;
    private String indent = "";
    private String clause = null;
    private boolean leftLRes = false;

    public WhereClause() {
    }

    public WhereClause(String indent) {
        this.indent = indent;
    }

    public void init(String c, Query q) throws QueryParseException {
        c = StringUtils.replaceString(c, String.valueOf('\n'), " ");
        String lhs = this.getClause(c);
        this.clause = c;
        if (lhs.length() < c.length()) {
            lhs = this.trimBrackets(lhs).trim();
            String rhs = c.substring(lhs.length());
            String lc = rhs.trim().toLowerCase();
            int ai = lc.indexOf(AND);
            int oi = lc.indexOf(OR);
            if (ai == -1 && oi == -1) {
                throw new QueryParseException("Expected to find AND or OR");
            }
            int i = -1;
            if (ai != -1) {
                i = ai;
                this.joinBy = AND;
            }
            if (oi != -1 && (oi < ai || ai == -1)) {
                this.joinBy = OR;
                i = oi;
            }
            rhs = rhs.substring(i + this.joinBy.length()).trim();
            this.left = new WhereClause(this.indent + "|  ");
            this.left.init(lhs, q);
            this.right = new WhereClause(this.indent + "|  ");
            this.right.init(rhs, q);
        } else {
            c = this.trimBrackets(c);
            String lc = c.toLowerCase();
            int ai = lc.indexOf(AND);
            int oi = lc.indexOf(OR);
            if (ai != -1 || oi != -1) {
                int i = -1;
                if (ai != -1) {
                    i = ai;
                    this.joinBy = AND;
                }
                if (oi != -1 && (oi < ai || ai == -1)) {
                    this.joinBy = OR;
                    i = oi;
                }
                String rlhs = c.substring(0, i);
                rlhs = rlhs.trim();
                String rhs = c.substring(i + this.joinBy.length() - 1).trim();
                this.left = new WhereClause(this.indent + "|  ");
                this.left.init(rlhs, q);
                this.right = new WhereClause(this.indent + "|  ");
                this.right.init(rhs, q);
            } else {
                lhs = this.trimBrackets(lhs);
                this.left = ClauseFactory.getClause(lhs, q);
                if (this.left == null) {
                    throw new QueryParseException("Unable to parse WHERE clause: \"" + lhs + "\" no suitable handler class found.");
                }
                if (this.left.isFixedResult()) {
                    this.leftLRes = this.left.getFixedResult();
                    this.left = null;
                }
            }
        }
    }

    private String trimBrackets(String c) {
        String nc = c;
        while (nc.startsWith("(")) {
            nc = nc.substring(1);
            nc = nc.substring(0, nc.length() - 1);
        }
        return nc;
    }

    private String getClause(String c) throws QueryParseException {
        char[] chars = c.trim().toCharArray();
        int obCount = 0;
        int cbCount = 0;
        boolean hasB = false;
        if (c.startsWith("(")) {
            hasB = true;
        }
        StringBuffer cl = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            cl.append(chars[i]);
            if (chars[i] == '(') {
                ++obCount;
            }
            if (chars[i] == ')' && ++cbCount > obCount) {
                throw new QueryParseException("Bad clause: \"" + c + "\", un-balanced brackets.");
            }
            if (obCount == cbCount && hasB) break;
        }
        return cl.toString();
    }

    public boolean isTrue(Query q, Object o) throws QueryExecutionException {
        boolean lres = false;
        boolean rres = false;
        if (this.left != null && this.right != null) {
            if (this.joinBy.equals(OR)) {
                lres = this.left.isTrue(q, o);
                if (lres) {
                    return true;
                }
                rres = this.right.isTrue(q, o);
                return rres;
            }
            if (this.joinBy.equals(AND)) {
                lres = this.left.isTrue(q, o);
                if (!lres) {
                    return false;
                }
                rres = this.right.isTrue(q, o);
                return rres;
            }
        }
        if (this.left != null) {
            boolean res = this.left.isTrue(q, o);
            return res;
        }
        return this.leftLRes;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.left != null) {
            String lhs = this.left.toString();
            buf.append('\n');
            buf.append(this.indent);
            buf.append("+ ");
            if (this.left instanceof WhereClause) {
                buf.append("LHS ");
            }
            buf.append(lhs);
            if (this.right != null) {
                buf.append('\n');
            }
        }
        if (this.joinBy != null) {
            buf.append(this.indent);
            buf.append("+ JOIN BY: ");
            buf.append(this.joinBy.toUpperCase().trim());
            buf.append('\n');
        }
        if (this.right != null) {
            WhereClause whr;
            String rhs = this.right.toString();
            buf.append(this.indent);
            buf.append("+ ");
            if (this.right instanceof WhereClause) {
                buf.append("RHS ");
            }
            buf.append(rhs);
            if (this.right instanceof WhereClause && (whr = (WhereClause)this.right).getRHS() == null) {
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public Clause getRHS() {
        return this.right;
    }

    public Clause getLHS() {
        return this.left;
    }

    public boolean getFixedResult() {
        return this.leftLRes;
    }

    public boolean isFixedResult() {
        return this.left == null;
    }
}

