/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.jsql;

import com.gentlyweb.jsql.Query;
import com.gentlyweb.jsql.QueryExecutionException;
import com.gentlyweb.jsql.QueryParseException;
import com.gentlyweb.utils.Getter;
import java.text.NumberFormat;

public class Value {
    public static final String INT_BIND_VAR_PREFIX = "^^^";
    public static final String NULL = "null";
    private StringBuffer value = null;
    private boolean quoted = false;
    private Getter get = null;
    private boolean bindVar = false;
    private double number = 0.0;
    private boolean isNumber = false;
    private boolean isNull = false;

    public Value(String c, Query q) throws QueryParseException {
        this.value = new StringBuffer(c);
        char char0 = c.charAt(0);
        char charL = c.charAt(c.length() - 1);
        if (char0 == '\'' || char0 == '\"') {
            if (charL != char0) {
                throw new QueryParseException("A value must start and end with the same quote character, in this case: " + char0);
            }
            c = c.substring(0, c.length() - 2);
            this.quoted = true;
        }
        if (this.value.charAt(0) == ':') {
            this.bindVar = true;
            this.value.deleteCharAt(0);
            if (this.value.length() == 0) {
                throw new QueryParseException("Bind variable names must be at least 1 character long.");
            }
        } else if (!this.quoted) {
            if (this.value.toString().equalsIgnoreCase(NULL)) {
                this.isNull = true;
                return;
            }
            NumberFormat nf = NumberFormat.getNumberInstance();
            try {
                this.number = nf.parse(this.value.toString()).doubleValue();
                this.isNumber = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.isNumber) {
                try {
                    this.get = q.getAccessor(this.value.toString());
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            if (!this.isNumber && this.get == null) {
                throw new QueryParseException("Unable to resolve value: \"" + this.value + "\", does not appear to be a valid accessor or a parsable number or NULL.");
            }
        }
    }

    public String getValue() {
        return this.value.toString();
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public Object getValue(Query q, Object o) throws QueryExecutionException {
        if (this.isNumber) {
            return new Double(this.number);
        }
        if (this.bindVar) {
            String bv = this.value.toString();
            Object b = q.getVariable(bv);
            if (b == null) {
                if (bv.startsWith(INT_BIND_VAR_PREFIX)) {
                    throw new QueryExecutionException("Unable to find value for anonymous bind variable (question mark, ?): " + bv.substring(INT_BIND_VAR_PREFIX.length()));
                }
                throw new QueryExecutionException("Unable to find value for bind variable: " + bv);
            }
            return b;
        }
        if (this.isNull) {
            return null;
        }
        if (this.get != null) {
            try {
                return this.get.getValue(o);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from object: " + o.getClass().getName() + " using accessor: " + this.value.toString(), e);
            }
        }
        if (this.quoted) {
            return this.value.substring(1, this.value.length() - 1);
        }
        return this.value.toString();
    }

    public String toString() {
        if (this.isNull) {
            return NULL.toUpperCase();
        }
        if (this.bindVar) {
            return ":" + this.value.toString() + " (Bind Variable)";
        }
        if (this.get != null) {
            return this.value.toString() + " (Accessor from class: " + this.get.getBaseClass().getName() + ", returns type of: " + this.get.getType().getName() + ")";
        }
        if (this.isNumber) {
            return this.value.toString() + " (Number)";
        }
        return this.value.toString() + " (Constant, quoted)";
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isNumber() {
        return this.isNumber;
    }
}

