/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.jsql;

import com.gentlyweb.jsql.Clause;
import com.gentlyweb.jsql.Query;
import com.gentlyweb.jsql.QueryExecutionException;
import com.gentlyweb.jsql.QueryParseException;
import com.gentlyweb.jsql.Value;

public class RangeClause
extends Clause {
    private static final int GTE = 0;
    private static final int GT = 1;
    private static final int LT = 2;
    private static final int LTE = 3;
    private Value lhs = null;
    private Value rhs = null;
    private int type = -1;
    private String rtype = null;
    private boolean isFixedResult = false;
    private boolean fixedResult = false;

    public boolean getFixedResult() {
        return this.fixedResult;
    }

    public boolean isFixedResult() {
        return this.isFixedResult;
    }

    public boolean isTrue(Query q, Object o) throws QueryExecutionException {
        if (this.isFixedResult) {
            return this.fixedResult;
        }
        Object l = null;
        try {
            l = this.lhs.getValue(q, o);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to get LHS value of: " + this.toString(), e);
        }
        if (l == null) {
            q.addExecutionLine(this, "LHS is NULL, RHS not executed, expect " + this.type + ", result: FALSE");
            return false;
        }
        Object r = null;
        try {
            r = this.rhs.getValue(q, o);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to get RHS value of: " + this.toString(), e);
        }
        if (l == null) {
            q.addExecutionLine(this, "LHS is NOT NULL, RHS is NULL, expect " + this.rtype + ", result: FALSE");
            return false;
        }
        return this.compare(l, r, q);
    }

    public void init(String c, Query q) throws QueryParseException {
        int gtei = c.indexOf(">");
        int ltei = c.indexOf("<");
        int indL = -1;
        int indR = -1;
        if (gtei != -1) {
            indL = gtei;
            this.type = 1;
            this.rtype = ">";
            if (c.charAt(gtei + 1) == '=') {
                this.type = 0;
                this.rtype = ">=";
                ++gtei;
            }
            indR = gtei + ">".length();
        }
        if (ltei != -1) {
            indL = ltei;
            this.type = 2;
            this.rtype = "<";
            if (c.charAt(ltei + 1) == '=') {
                this.type = 3;
                this.rtype = "<=";
                ++ltei;
            }
            indR = ltei + "<".length();
        }
        String lv = c.substring(0, indL).trim();
        this.lhs = new Value(lv, q);
        String rv = c.substring(indR).trim();
        this.rhs = new Value(rv, q);
        if ((this.lhs.isNumber() || this.lhs.isQuoted()) && (this.rhs.isQuoted() || this.rhs.isNumber())) {
            Object o = new Object();
            try {
                Object ln = this.lhs.getValue(q, o);
                Object rn = this.rhs.getValue(q, o);
                this.isFixedResult = true;
                this.fixedResult = this.compare(ln, rn, q);
            }
            catch (QueryExecutionException e) {
                // empty catch block
            }
        }
    }

    private boolean compare(Object l, Object r, Query q) {
        if (l instanceof Comparable && r instanceof Comparable && l.getClass().isAssignableFrom(r.getClass())) {
            Comparable lc = (Comparable)l;
            Comparable rc = (Comparable)r;
            return this.compare(lc, rc, q);
        }
        if (l instanceof Number && r instanceof Number) {
            return this.compare(new Double(((Number)l).doubleValue()), new Double(((Number)r).doubleValue()), q);
        }
        String ls = l.toString();
        String rs = r.toString();
        if (ls == null) {
            ls = "";
        }
        if (rs == null) {
            rs = "";
        }
        return this.compare((Comparable)((Object)ls), (Comparable)((Object)rs), q);
    }

    private boolean compare(Comparable l, Comparable r, Query q) {
        int c = l.compareTo(r);
        if (c < 0) {
            return this.type == 2 || this.type == 3;
        }
        if (c > 0) {
            return this.type == 1 || this.type == 0;
        }
        return this.type == 0 || this.type == 3;
    }
}

