/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.jsql;

import com.gentlyweb.jsql.File2;
import com.gentlyweb.jsql.QueryExecutionException;
import com.gentlyweb.jsql.QueryParseException;
import com.gentlyweb.jsql.Value;
import com.gentlyweb.jsql.ValueTokenizer;
import com.gentlyweb.jsql.WhereClause;
import com.gentlyweb.utils.GeneralComparator;
import com.gentlyweb.utils.Getter;
import com.gentlyweb.utils.Grouper;
import com.gentlyweb.utils.IOUtils;
import com.gentlyweb.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Query {
    private static final String ORDER = "order";
    private static final String GROUP = "group";
    private static final String WHERE = "where";
    private static final String FROM = "from";
    private static final String SELECT = "select";
    private static final String BY = "by";
    private static final String RET_OBJS = "*";
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private Map aliases = new HashMap();
    private List groupBys = null;
    private GeneralComparator orderByComp = null;
    private Grouper grouper = null;
    private List orderBys = null;
    private List cols = null;
    private boolean retObjs = false;
    private WhereClause where = null;
    private Class c = null;
    private Map bindVars = null;
    private List execInfo = null;
    private List results = null;
    private String query = null;
    private boolean wantExecInfo = false;
    private boolean wantTimings = false;
    private Map timings = null;
    static /* synthetic */ Class class$com$gentlyweb$utils$Getter;
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] argv) {
        Query q = new Query();
        try {
            File f = new File(argv[0]);
            String qs = IOUtils.getFile(f);
            String oldCols = ":name1, :name2, 'he\"l\\lo', 12345, type.package.toString.class, type.hashCode, type.declaredMethods.class.name.length";
            String qq = "INTO com.gentlyweb.utils.Setter MAP 1 -> name, 2 -> type";
            q.parse(qs);
            File pd = new File("D:/development/gently/gentlyweb/src");
            ArrayList fs2 = new ArrayList();
            long s = System.currentTimeMillis();
            q.getAllFiles(pd, fs2);
            System.out.println("CONVERT TO FILE2 TOOK: " + (System.currentTimeMillis() - s));
            Getter get = new Getter("type", class$com$gentlyweb$utils$Getter == null ? (class$com$gentlyweb$utils$Getter = Query.class$("com.gentlyweb.utils.Getter")) : class$com$gentlyweb$utils$Getter);
            ArrayList<Getter> items = new ArrayList<Getter>();
            items.add(get);
            HashMap<String, String> bindVars = new HashMap<String, String>();
            bindVars.put("parentDir", pd.getPath());
            bindVars.put("name2", "bentley");
            bindVars.put("name3", (class$java$lang$String == null ? (class$java$lang$String = Query.class$("java.lang.String")) : class$java$lang$String).getName());
            q.setVariables(bindVars);
            s = System.currentTimeMillis();
            List objs = q.execute(fs2);
            System.out.println("EXECUTE TOOK: " + (System.currentTimeMillis() - s));
            List execInfo = q.getExecutionInfo();
            System.out.println("RESULTS SIZE: " + objs.size());
            for (int i = 0; i < objs.size(); ++i) {
                List l = (List)objs.get(i);
                System.out.println(l);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public Map getTimings() {
        return this.timings;
    }

    public void setWantExecutionInfo(boolean v) {
        this.wantExecInfo = v;
    }

    public void setWantTimings(boolean v) {
        this.wantTimings = v;
    }

    protected void addTiming(String id, double time) {
        if (this.wantTimings) {
            if (this.timings == null) {
                this.timings = new LinkedHashMap();
            }
            this.timings.put(id, new Double(time));
        }
    }

    public List getExecutionInfo() {
        return this.execInfo;
    }

    public List getResults() {
        return this.results;
    }

    public boolean hasResults() {
        return this.results != null;
    }

    protected void addExecutionLine(Object obj, String message) {
        if (this.wantExecInfo) {
            if (this.execInfo == null) {
                this.execInfo = new ArrayList();
            }
            this.execInfo.add(new ExecutionInfo(obj, message));
        }
    }

    public Object getVariable(int index) {
        return this.getVariable("^^^" + index);
    }

    public Object getVariable(String name) {
        if (this.bindVars == null) {
            return null;
        }
        return this.bindVars.get(name);
    }

    public void setVariable(String name, Object v) {
        if (this.bindVars == null) {
            this.bindVars = new HashMap();
        }
        this.bindVars.put(name, v);
    }

    public void setVariable(int index, Object v) {
        this.setVariable("^^^" + index, v);
    }

    public Map getVariables() {
        return this.bindVars;
    }

    public void setVariables(Map bVars) {
        this.bindVars = bVars;
    }

    public List execute(List objs) throws QueryExecutionException {
        if (this.execInfo != null) {
            this.execInfo.clear();
        }
        List results = new ArrayList();
        long s = System.currentTimeMillis();
        if (this.where != null) {
            for (int i = 0; i < objs.size(); ++i) {
                Object o = objs.get(i);
                boolean res = this.where.isTrue(this, o);
                if (!res) continue;
                results.add(o);
            }
        } else {
            results = objs;
        }
        double wet = (double)System.currentTimeMillis() - (double)s;
        this.addTiming("Total time to execute Where clause on all objects", wet);
        this.addTiming("Where took average over: " + objs.size() + " objects", wet / (double)objs.size());
        if (this.grouper != null) {
            try {
                s = System.currentTimeMillis();
                Map mres = this.grouper.group(results);
                long t = System.currentTimeMillis();
                this.addTiming("Group took", t - s);
                Iterator iter = mres.keySet().iterator();
                HashMap<List, List> nres = new HashMap<List, List>();
                while (iter.hasNext()) {
                    List l = (List)iter.next();
                    List lr = (List)mres.get(l);
                    if (lr.size() > 1 && this.orderByComp != null) {
                        Collections.sort(lr, this.orderByComp);
                    }
                    List cvs = this.getColumnValues(lr);
                    nres.put(l, cvs);
                }
                t = System.currentTimeMillis();
                this.addTiming("Group collection and sort took", t - s);
                return new ArrayList();
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to perform group by operation", e);
            }
        }
        if (results.size() > 1 && this.orderByComp != null) {
            s = System.currentTimeMillis();
            Collections.sort(results, this.orderByComp);
            this.addExecutionLine(this, "Performed: " + this.orderByComp.getCount() + " compares");
            this.addTiming("Order by took", System.currentTimeMillis() - s);
        }
        if (!this.retObjs) {
            s = System.currentTimeMillis();
            List l = this.getColumnValues(results);
            this.addTiming("Collection of results took", System.currentTimeMillis() - s);
            return l;
        }
        return results;
    }

    private List getColumnValues(List res) throws QueryExecutionException {
        ArrayList rs = new ArrayList();
        int s = res.size();
        for (int i = 0; i < s; ++i) {
            Object o = res.get(i);
            ArrayList<Object> sRes = new ArrayList<Object>();
            for (int j = 0; j < this.cols.size(); ++j) {
                Value v = (Value)this.cols.get(j);
                try {
                    sRes.add(v.getValue(this, o));
                    continue;
                }
                catch (Exception e) {
                    throw new QueryExecutionException("Unable to value for column: " + j + " for: " + v.toString() + " from result: " + i + " (" + o + ")");
                }
            }
            rs.add(sRes);
        }
        return rs;
    }

    public String getQuery() {
        return this.query;
    }

    public void parse(String q) throws QueryParseException {
        int fr;
        int wh;
        int gbi;
        if (q == null) {
            throw new QueryParseException("No statement provided.");
        }
        this.query = q;
        String ql = q.toLowerCase();
        ql = ql.trim();
        ql = StringUtils.replaceString(ql, String.valueOf('\n'), " ");
        String orderBy = null;
        String groupBy = null;
        String where = null;
        String from = null;
        String select = null;
        int obi = ql.indexOf(ORDER);
        int ind = -1;
        if (obi != -1) {
            orderBy = q.substring(obi + ORDER.length());
            ind = obi;
            if ((orderBy = orderBy.trim()).toLowerCase().startsWith(BY)) {
                orderBy = orderBy.substring(BY.length());
                orderBy = orderBy.trim();
            }
            ql = ql.substring(0, obi);
        }
        if ((gbi = ql.indexOf(GROUP)) != -1) {
            groupBy = q.substring(gbi + 5, ind);
            ind = gbi;
            if ((groupBy = groupBy.trim()).toLowerCase().startsWith(BY)) {
                groupBy = groupBy.substring(BY.length());
                groupBy = groupBy.trim();
            }
            ql = ql.substring(0, gbi);
        }
        if ((wh = ql.indexOf(WHERE)) != -1) {
            where = q.substring(wh + 5, ind);
            ind = wh;
            where = where.trim();
            ql = ql.substring(0, wh);
        }
        if ((fr = ql.indexOf(FROM)) == -1) {
            throw new QueryParseException("Query: \n" + q + " does NOT contain a FROM clause indicating the class names of the object(s)");
        }
        from = q.substring(fr + 4, ind);
        from = from.trim();
        ql = ql.substring(0, fr);
        this.configureFrom(from);
        if (wh != -1) {
            int qi;
            this.where = new WhereClause("  ");
            int bindVarC = 1;
            StringBuffer wb = new StringBuffer(where);
            int li = 0;
            while ((qi = where.indexOf("?", li)) != -1) {
                wb.replace(qi, qi + 1, ":^^^" + bindVarC);
                li = qi + 2 + ":^^^".length() + String.valueOf(++bindVarC).length();
                where = wb.toString();
            }
            where = wb.toString();
            this.where.init(where, this);
        }
        if (orderBy != null) {
            this.configureOrderByComparator(orderBy);
        }
        if (groupBy != null) {
            this.configureGrouper(groupBy);
        }
        if (!ql.startsWith(SELECT)) {
            throw new QueryParseException("Query must start with SELECT.");
        }
        select = q.substring(SELECT.length(), fr);
        if ((select = select.trim()).equals(RET_OBJS)) {
            this.retObjs = true;
        } else {
            this.cols = new ArrayList();
            ValueTokenizer vt = new ValueTokenizer(select, ',');
            while (vt.hasMoreTokens()) {
                String tok = vt.nextToken().trim();
                try {
                    this.cols.add(new Value(tok, this));
                }
                catch (Exception e) {
                    throw new QueryParseException("Invalid select column value: " + tok, e);
                }
            }
        }
    }

    private void configureFrom(String from) throws QueryParseException {
        StringTokenizer ft = new StringTokenizer(from, ",");
        if (ft.countTokens() > 1) {
            throw new QueryParseException("Sorry, multiple objects types are not yet supported.");
        }
        int find = 1;
        while (ft.hasMoreTokens()) {
            String tok;
            String cl = tok = ft.nextToken().trim();
            int sind = tok.indexOf(" ");
            String alias = null;
            if (sind != -1) {
                cl = tok.substring(0, sind);
                alias = tok.substring(sind).trim();
            } else {
                alias = String.valueOf(find);
                ++find;
            }
            String a = alias.toLowerCase();
            if (this.aliases.containsKey(a)) {
                throw new QueryParseException("Got duplicate FROM class alias: " + alias);
            }
            Class<?> c = null;
            try {
                this.c = c = Class.forName(cl);
            }
            catch (Exception e) {
                throw new QueryParseException("Unable to load class: " + cl, e);
            }
            this.aliases.put(a, c);
        }
    }

    private void configureGrouper(String groupBy) throws QueryParseException {
        this.grouper = new Grouper(this.c);
        StringTokenizer t = new StringTokenizer(groupBy, ",");
        while (t.hasMoreTokens()) {
            String tok = t.nextToken().trim();
            if (tok.length() <= 0) continue;
            Getter g = this.getAccessor(tok);
            this.grouper.addGroupBy(g);
        }
    }

    private void configureOrderByComparator(String orderBy) throws QueryParseException {
        this.orderByComp = new GeneralComparator(this.c);
        StringTokenizer t = new StringTokenizer(orderBy, ",");
        while (t.hasMoreTokens()) {
            String tok = t.nextToken().trim();
            if (tok.length() <= 0) continue;
            int sind = tok.indexOf(" ");
            String ad = "ASC";
            if (sind != -1) {
                String v = tok.substring(sind + 1).trim().toUpperCase();
                tok = tok.substring(0, sind);
                if (v.equalsIgnoreCase("DESC")) {
                    ad = "DESC";
                }
            }
            Getter g = this.getAccessor(tok);
            this.orderByComp.addField(g, ad);
        }
    }

    public Getter getAccessor(String val) throws QueryParseException {
        String a;
        Class c;
        int pind = val.indexOf(".");
        if (pind != -1 && (c = (Class)this.aliases.get((a = val.substring(0, pind)).toLowerCase())) != null) {
            try {
                return new Getter(val.substring(pind + 1), c);
            }
            catch (Exception e) {
                throw new QueryParseException("Unable to find accessor: " + val + " in class: " + c.getName() + " aliased by: " + a, e);
            }
        }
        Getter g = null;
        int count = 0;
        Class c2 = null;
        Iterator iter = this.aliases.keySet().iterator();
        while (iter.hasNext()) {
            c2 = (Class)this.aliases.get(iter.next());
            try {
                g = new Getter(val, c2);
                if (g == null) continue;
                ++count;
            }
            catch (Exception e) {}
        }
        if (g == null) {
            throw new QueryParseException("Unable to find accessor: " + val + " in any of the classes listed in the FROM clause");
        }
        if (count > 1) {
            throw new QueryParseException("Accessor: " + val + " matches multiple classes listed in the FROM clause");
        }
        return g;
    }

    public void getAllFiles(File dir, List res) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.getAllFiles(files[i], res);
                }
                res.add(new File2(files[i]));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ExecutionInfo {
        private long timeStamp = System.currentTimeMillis();
        private String message = null;
        private Object creator = null;

        public ExecutionInfo(Object creator, String message) {
            this.message = message;
            this.creator = creator;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getCreator() {
            return this.creator;
        }

        public long getTimestamp() {
            return this.timeStamp;
        }
    }
}

