/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.jsql;

import com.gentlyweb.jsql.Clause;
import com.gentlyweb.jsql.Query;
import com.gentlyweb.jsql.QueryExecutionException;
import com.gentlyweb.jsql.QueryParseException;
import com.gentlyweb.jsql.Value;
import java.util.StringTokenizer;

public class EqualsClause
extends Clause {
    public static final String NULL = "null";
    public static final String NOT = "not";
    public static final String IS = " is ";
    public static final String EQUALS = "=";
    public static final String NOT_EQUALS = "!=";
    public static final String NOT_EQUALS2 = "<>";
    public static final String IGNORE_CASE = "$";
    private boolean isNull = false;
    private boolean not = false;
    private boolean ignoreCase = false;
    private Value lhs = null;
    private Value rhs = null;
    private boolean isFixedResult = false;
    private boolean fixedRes = false;

    public void init(String c, Query q) throws QueryParseException {
        String n;
        StringTokenizer t;
        try {
            this.lhs = new Value(c, q);
        }
        catch (Exception e) {
            throw new QueryParseException("Unable to get left-hand side of clause: \"" + c + "\"", e);
        }
        String rest = c.substring(this.lhs.getValue().length()).trim();
        String rhs = null;
        if (rest.indexOf(EQUALS) != -1) {
            t = new StringTokenizer(rest, " ");
            if (t.countTokens() < 2) {
                throw new QueryParseException("Expected clause to be form: [ACCESSOR|BIND_NAME|CONSTANT] !=|=|$=|$!=|<>|$<> [ACCESSOR|BIND_NAME|CONSTANT], clause is: " + c);
            }
            n = t.nextToken();
            if (n.endsWith(NOT_EQUALS)) {
                this.not = true;
            }
            if (n.startsWith(IGNORE_CASE)) {
                this.ignoreCase = true;
            }
            rhs = rest.substring(n.length()).trim();
        }
        if (rest.indexOf(NOT_EQUALS2) != -1) {
            t = new StringTokenizer(rest, " ");
            if (t.countTokens() < 2) {
                throw new QueryParseException("Expected clause to be form: [ACCESSOR|BIND_NAME|CONSTANT] !=|=|$=|$!=|<>|$<> [ACCESSOR|BIND_NAME|CONSTANT], clause is: " + c);
            }
            n = t.nextToken();
            if (n.startsWith(IGNORE_CASE)) {
                this.ignoreCase = true;
            }
            rhs = rest.substring(n.length()).trim();
            this.not = true;
        }
        if (rest.toLowerCase().indexOf(IS) != -1) {
            String nn;
            t = new StringTokenizer(rest, " ");
            n = t.nextToken();
            String last = nn = t.nextToken();
            if (!nn.equalsIgnoreCase(NULL) && !nn.equalsIgnoreCase(NOT)) {
                throw new QueryParseException("Expected to find NULL or NOT after: \"" + n + "\" in clause: " + c + ", got: \"" + nn + "\"");
            }
            if (nn.equalsIgnoreCase(NULL)) {
                this.isNull = true;
                return;
            }
            if (nn.equalsIgnoreCase(NOT)) {
                this.not = true;
                this.isNull = true;
                String nnn = t.nextToken();
                if (!nnn.equalsIgnoreCase(NULL)) {
                    throw new QueryParseException("Expected to find NULL after: \"" + nn + "\" in clause: " + c + ", got: \"" + nnn + "\"");
                }
            }
            return;
        }
        if (rhs == null) {
            throw new QueryParseException("Unable to parse clause: \"" + c + "\", probably caused by un-balanced quotes.");
        }
        try {
            this.rhs = new Value(rhs, q);
        }
        catch (Exception e) {
            throw new QueryParseException("Unable to get right-hand side of clause: \"" + c + "\"", e);
        }
        if (this.rhs.isNull()) {
            this.isNull = true;
        }
    }

    public boolean isTrue(Query q, Object o) throws QueryExecutionException {
        Object l = null;
        try {
            l = this.lhs.getValue(q, o);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to get LHS value of: " + this.toString(), e);
        }
        if (this.isNull) {
            if (l == null) {
                return true;
            }
            return this.not && l != null;
        }
        Object r = null;
        try {
            r = this.rhs.getValue(q, o);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to get RHS value of: " + this.toString(), e);
        }
        if (l == null && r == null) {
            return !this.not;
        }
        if (l != null || r != null) {
            if (l != null && r == null) {
                return this.not;
            }
            if (r != null && l == null) {
                return this.not;
            }
        }
        if (this.ignoreCase) {
            String ls = l.toString();
            String rs = r.toString();
            if (ls == null || rs == null) {
                return false;
            }
            boolean eq = ls.equalsIgnoreCase(rs);
            if (this.not && !eq) {
                return true;
            }
            return eq;
        }
        if (l instanceof Comparable && r instanceof Comparable) {
            boolean eq;
            System.out.println("HERE!!");
            Comparable lc = (Comparable)l;
            Comparable rc = (Comparable)r;
            boolean bl = eq = lc.compareTo(rc) == 0;
            if (this.not && !eq) {
                return true;
            }
            return eq;
        }
        String ls = l.toString();
        String rs = r.toString();
        if (ls == null) {
            ls = "";
        }
        if (rs == null) {
            rs = "";
        }
        boolean eq = false;
        eq = this.ignoreCase ? ls.equalsIgnoreCase(rs) : ls.equals(rs);
        if (eq) {
            return !this.not;
        }
        return this.not;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getIndent() + " Equals Clause - ");
        buf.append(this.lhs.toString());
        if (this.isNull) {
            buf.append(" IS");
            if (this.not) {
                buf.append(" NOT");
            }
            buf.append(" NULL");
            return buf.toString();
        }
        buf.append(" ");
        if (this.ignoreCase) {
            buf.append(IGNORE_CASE);
        }
        if (this.not) {
            buf.append(NOT_EQUALS);
        } else {
            buf.append(EQUALS);
        }
        buf.append(" ");
        buf.append(this.rhs.toString());
        return buf.toString();
    }

    public boolean getFixedResult() {
        return this.fixedRes;
    }

    public boolean isFixedResult() {
        return this.isFixedResult;
    }
}

