/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.encryption.symmetric;

import com.gentlyweb.encryption.symmetric.EncryptData;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtils {
    public static String encrypt(EncryptData edata, String text) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException {
        return EncryptUtils.handleEncryptDecrypt(1, edata.getEncryptionAlgorithmId(), edata.getKeyAlgorithmId(), text, edata.getKey(), edata.getInitVector());
    }

    public static String encrypt(String encalg, String keyalg, String text, String key, String iv) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException {
        return EncryptUtils.handleEncryptDecrypt(1, encalg, keyalg, text, key, iv);
    }

    public static String decrypt(EncryptData edata, String text) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException {
        return EncryptUtils.handleEncryptDecrypt(2, edata.getEncryptionAlgorithmId(), edata.getKeyAlgorithmId(), text, edata.getKey(), edata.getInitVector());
    }

    public static String decrypt(String encalg, String keyalg, String text, String key, String iv) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException {
        return EncryptUtils.handleEncryptDecrypt(2, encalg, keyalg, text, key, iv);
    }

    public static String generateMAC(EncryptData edata, String text) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (edata.wantMAC()) {
            return EncryptUtils.generateMAC(text, edata.getMACAlgorithmId(), edata.getMACKey(), edata.getMACInitVector());
        }
        return "";
    }

    public static String generateMAC(String text, String macalg, String mackey, String maciv) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivspec = new IvParameterSpec(maciv.getBytes());
        SecretKeySpec skey = new SecretKeySpec(mackey.getBytes(), macalg);
        Mac mac = Mac.getInstance(macalg);
        mac.init(skey, ivspec);
        return new String(mac.doFinal(text.getBytes()));
    }

    private static String handleEncryptDecrypt(int mode, String encalg, String keyalg, String text, String key, String iv) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException {
        IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
        SecretKeySpec skey = new SecretKeySpec(key.getBytes(), keyalg);
        Cipher cipher = Cipher.getInstance(encalg);
        cipher.init(mode, (Key)skey, ivspec);
        byte[] ciphertext = text.getBytes();
        return new String(cipher.doFinal(ciphertext));
    }

    public static String generateSymmetricKey(String keyalg, int keysize) {
        SecureRandom sr = new SecureRandom();
        byte[] keybytes = new byte[keysize];
        sr.nextBytes(keybytes);
        SecretKeySpec key = new SecretKeySpec(keybytes, keyalg);
        return new String(key.getEncoded());
    }
}

