/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.email;

import com.gentlyweb.email.Email;
import com.gentlyweb.utils.GZIPFileDataSource;
import com.gentlyweb.utils.HTMLDataSource;
import com.gentlyweb.utils.URLDataSource;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailUtils {
    public static void sendEmail(Email email, boolean bodyIsHTML, String smtpHost, String zipExtension, String textEncoding) throws MessagingException {
        if (textEncoding == null) {
            textEncoding = "iso-8859-1";
        }
        MimeBodyPart[] parts = null;
        Map attachments = email.getAttachments();
        if (attachments != null) {
            parts = new MimeBodyPart[attachments.size()];
            Iterator iter = attachments.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                String name = (String)iter.next();
                MimeBodyPart att = new MimeBodyPart();
                Object bodyPart = attachments.get(name);
                att.setFileName(name);
                parts[i] = att;
                if (bodyPart instanceof URL) {
                    URL u = (URL)bodyPart;
                    URLDataSource uf = new URLDataSource(u);
                    att.setDataHandler(new DataHandler((DataSource)uf));
                    continue;
                }
                if (bodyPart instanceof File) {
                    File f = (File)bodyPart;
                    Object ds = new FileDataSource(f);
                    if (zipExtension != null && f.getName().endsWith(zipExtension)) {
                        ds = new GZIPFileDataSource(f, zipExtension);
                    }
                    att.setDataHandler(new DataHandler((DataSource)ds));
                    continue;
                }
                if (bodyPart instanceof String) {
                    att.setText((String)bodyPart, textEncoding);
                    continue;
                }
                att.setText(bodyPart.toString(), textEncoding);
            }
        }
        InternetAddress f = new InternetAddress(email.getFrom());
        InternetAddress[] to = new InternetAddress[]{new InternetAddress(email.getTo())};
        EmailUtils.sendEmail(f, to, null, email.getSubject(), email.getBody(), parts, bodyIsHTML, smtpHost, textEncoding);
    }

    public static void sendEmail(InternetAddress from, InternetAddress[] tolist, InternetAddress[] cclist, String subject, String body, MimeBodyPart[] attachments, boolean bodyIsHTML, String smtpHost, String textEncoding) throws MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtpHost);
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)from);
        msg.setRecipients(Message.RecipientType.TO, (Address[])tolist);
        if (cclist != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])cclist);
        }
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        MimeMultipart multi = new MimeMultipart("alternative");
        MimeBodyPart main = new MimeBodyPart();
        if (bodyIsHTML) {
            main.setDataHandler(new DataHandler((DataSource)new HTMLDataSource(body)));
            main.setHeader("Content-Transfer-Encoding", "7bit");
        } else if (textEncoding == null) {
            main.setText(body, "iso-8859-1");
        } else {
            main.setText(body, textEncoding);
        }
        multi.addBodyPart((BodyPart)main);
        if (attachments != null) {
            for (int i = 0; i < attachments.length; ++i) {
                multi.addBodyPart((BodyPart)attachments[i]);
            }
        }
        msg.setContent((Multipart)multi);
        Transport.send((Message)msg);
    }
}

