/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.ecom.ACL;
import com.gentlyweb.ecom.AbstractDataManager;
import com.gentlyweb.ecom.Account;
import com.gentlyweb.ecom.StockItem;
import com.gentlyweb.templates.TemplateManager;
import com.gentlyweb.utils.GeneralFilter;
import com.gentlyweb.utils.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StockManager
extends AbstractDataManager {
    public static final String UPDATE = "stockUpdate";
    public static final String DELETE = "stockDelete";
    public static final String READ = "stockRead";
    public static final String STOCK_QUANTITY_CHANGED_DEFAULT_TEMPLATE_NAME = "STOCK_QUANTITY_CHANGED";
    private ACL acl = null;
    private TemplateManager templateManager = null;
    private String stockQuantityChangedTemplateName = "STOCK_QUANTITY_CHANGED";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$gentlyweb$ecom$StockItem;

    public StockManager(boolean cache, int policy) {
        super(cache, policy);
    }

    public void setACL(ACL acl) {
        this.acl = acl;
    }

    public void setTemplateManager(TemplateManager man) {
        this.templateManager = man;
    }

    private void checkAction(Account acc, String act) throws DataStoreException {
        if (this.acl != null) {
            if (acc == null) {
                throw new DataStoreException("No Account passed.");
            }
            if (!this.acl.actionAllowed(acc.getType(), acc.getUsername(), act)) {
                throw new DataStoreException("Account: " + acc.getType() + "/" + acc.getUsername() + " does not have the: " + act + " action allowed.");
            }
        }
    }

    public void saveStockItem(Account acc, StockItem item) throws DataStoreException {
        this.checkAction(acc, UPDATE);
        this.putObject(item.getID(), item);
    }

    public StockItem getStockItem(Account acc, String id) throws DataStoreException {
        this.checkAction(acc, READ);
        return (StockItem)this.getObject(id);
    }

    public boolean hasStockItem(Account acc, String id) throws DataStoreException {
        this.checkAction(acc, READ);
        return this.hasKey(id);
    }

    public synchronized List getStockItems(Account acc, String id) throws DataStoreException {
        this.checkAction(acc, READ);
        GeneralFilter f = new GeneralFilter(class$java$lang$String == null ? (class$java$lang$String = StockManager.class$("java.lang.String")) : class$java$lang$String);
        f.addField("toString", id, 3);
        return this.getObjects(f);
    }

    public synchronized List getAllStockItems(Account acc) throws DataStoreException {
        this.checkAction(acc, READ);
        return this.getAllObjects();
    }

    public void addAll(Account acc, Map map) throws IllegalArgumentException, DataStoreException {
        this.checkAction(acc, UPDATE);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = map.get(key);
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Expected key to be of type: " + (class$java$lang$String == null ? (class$java$lang$String = StockManager.class$("java.lang.String")) : class$java$lang$String).getName() + ", got: " + key.getClass().getName());
            }
            if (!(class$com$gentlyweb$ecom$StockItem == null ? StockManager.class$("com.gentlyweb.ecom.StockItem") : class$com$gentlyweb$ecom$StockItem).isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Expected value to be of type: " + (class$com$gentlyweb$ecom$StockItem == null ? (class$com$gentlyweb$ecom$StockItem = StockManager.class$("com.gentlyweb.ecom.StockItem")) : class$com$gentlyweb$ecom$StockItem).getName() + ", got: " + value.getClass().getName());
            }
            this.putObject(key, value);
        }
    }

    public void setStockQuantityChangedTemplateName(String template) {
        this.stockQuantityChangedTemplateName = template;
    }

    public synchronized void addStockNote(Account acc, String id, String text) throws DataStoreException {
        this.checkAction(acc, UPDATE);
        StockItem t = this.getStockItem(acc, id);
        if (t == null) {
            throw new DataStoreException("Cannot find stock item for id: " + id);
        }
        t.addNote(acc.getUsername(), text);
        this.saveStockItem(acc, t);
    }

    public synchronized void incrementStockQuantity(Account acc, String id, int quantity, String text) throws DataStoreException {
        String note;
        this.checkAction(acc, UPDATE);
        StockItem t = this.getStockItem(acc, id);
        if (t == null) {
            throw new DataStoreException("Cannot find stock item for id: " + id);
        }
        String u = "--NO USERNAME--";
        if (acc != null) {
            u = acc.getUsername();
        }
        int o = t.getQuantity();
        int n = quantity + o;
        if (this.templateManager != null && (note = this.templateManager.getTemplate(this.stockQuantityChangedTemplateName)) != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("[[OLD]]", String.valueOf(o));
            map.put("[[NEW]]", String.valueOf(n));
            t.addNote(u, StringUtils.replaceAllStrings(note, map));
        }
        t.setQuantity(t.getQuantity() + quantity);
        if (text != null) {
            t.addNote(u, text);
        }
        this.saveStockItem(acc, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

