/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.ecom.Note;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import com.gentlyweb.xml.XmlConversionException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class StockItem
implements JDOMXmlOutputter {
    public static final String AVAILABLE = "available";
    public static final String NOT_AVAILABLE = "notAvailable";
    private Map costs = new HashMap();
    private String name = "";
    private String id = "";
    private String description = "";
    private int quantity = 0;
    private Map attributes = new HashMap();
    private List notes = new ArrayList();
    private String type = "";
    private String status = "available";

    public StockItem(Element root) throws JDOMException, XmlConversionException {
        JDOMUtils.checkName(root, "stockItem", true);
        this.type = JDOMUtils.getAttributeValue(root, "type");
        this.name = JDOMUtils.getChildElementContent(root, "name");
        this.status = JDOMUtils.getAttributeValue(root, "status");
        this.id = JDOMUtils.getChildElementContent(root, "id");
        this.description = JDOMUtils.getChildElementContent(root, "description");
        this.quantity = JDOMUtils.getAttributeValueAsInt(root, "quantity");
        if (root.getChild("attributes") != null) {
            Element attr = JDOMUtils.getChildElement(root, "attributes");
            Element map = JDOMUtils.getChildElement(attr, "map");
            JDOMUtils.buildMap(map, this.attributes);
        }
        List costs = JDOMUtils.getChildElementSet(root, "costs", "cost", true);
        for (int i = 0; i < costs.size(); ++i) {
            Element e = (Element)costs.get(i);
            String cur = JDOMUtils.getAttributeValue(e, "currency");
            float value = JDOMUtils.getAttributeValueAsFloat(e, "value");
            if (this.costs.containsKey(cur)) {
                throw new JDOMException("Found repeated currency: " + cur + " at: " + JDOMUtils.getPath(e));
            }
            this.costs.put(cur.toLowerCase(), new Float(value));
        }
        List noteEls = JDOMUtils.getChildElementSet(root, "notes", "note", false);
        for (int i = 0; i < noteEls.size(); ++i) {
            Element e = (Element)noteEls.get(i);
            this.notes.add(new Note(e));
        }
    }

    public StockItem() {
    }

    public void setCostForCurrency(String currency, float cost) {
        this.costs.put(currency.toLowerCase(), new Float(cost));
    }

    public float getCostForCurrency(String currency) {
        Float i = (Float)this.costs.get(currency.toLowerCase());
        if (i == null) {
            return -1.0f;
        }
        return i.floatValue();
    }

    public boolean isCurrencyValid(String cur) {
        return this.costs.containsKey(cur.toLowerCase());
    }

    public void addNote(String username, String text) {
        this.notes.add(new Note(username, text, new Date()));
    }

    public List getNotes() {
        return this.notes;
    }

    public void addNote(Note note) {
        this.notes.add(note);
    }

    public void setAttributes(Map attrs) {
        this.attributes = attrs;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Element getAsJDOMElement() {
        Element root = new Element("stockItem");
        root.setAttribute("type", this.type);
        root.setAttribute("status", this.status);
        root.addContent((Content)new Element("name").addContent((Content)new CDATA(this.name)));
        root.addContent((Content)new Element("id").addContent((Content)new CDATA(this.id)));
        root.addContent((Content)new Element("description").addContent((Content)new CDATA(this.description)));
        root.setAttribute("quantity", String.valueOf(this.quantity));
        if (this.attributes.size() > 0) {
            Element attributes = new Element("attributes");
            root.addContent((Content)attributes);
            try {
                attributes.addContent((Content)JDOMUtils.convertMap(this.attributes));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Element costsEl = new Element("costs");
        root.addContent((Content)costsEl);
        Iterator iter = this.costs.keySet().iterator();
        while (iter.hasNext()) {
            String cur = (String)iter.next();
            float val = ((Float)this.costs.get(cur)).floatValue();
            Element el = new Element("cost");
            el.setAttribute("currency", cur);
            el.setAttribute("value", String.valueOf(val));
            costsEl.addContent((Content)el);
        }
        if (this.notes.size() > 0) {
            Element notes = new Element("notes");
            root.addContent((Content)notes);
            for (int i = 0; i < this.notes.size(); ++i) {
                Note n = (Note)this.notes.get(i);
                notes.addContent((Content)n.getAsJDOMElement());
            }
        }
        return root;
    }

    public class XMLConstants {
        public static final String root = "stockItem";
        public static final String name = "name";
        public static final String description = "description";
        public static final String id = "id";
        public static final String attributes = "attributes";
        public static final String notes = "notes";
        public static final String note = "note";
        public static final String quantity = "quantity";
        public static final String map = "map";
        public static final String type = "type";
        public static final String status = "status";
        public static final String costs = "costs";
        public static final String cost = "cost";
        public static final String value = "value";
        public static final String currency = "currency";
        public static final String AUD = "AUD";
        public static final String USD = "USD";
        public static final String GBP = "GBP";
    }
}

