/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.ecom.CartItem;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class OrderItem
implements JDOMXmlOutputter {
    private String stockID = null;
    private Map attributes = new HashMap();
    private int quantity = 0;
    private float cost = 0.0f;

    public OrderItem(CartItem item) {
        this.stockID = item.getStockID();
        this.quantity = item.getQuantity();
        this.attributes = new HashMap();
        this.attributes.putAll(item.getAttributes());
    }

    public OrderItem(Element root) throws JDOMException {
        JDOMUtils.checkName(root, "item", true);
        this.quantity = JDOMUtils.getAttributeValueAsInt(root, "quantity");
        this.cost = JDOMUtils.getAttributeValueAsFloat(root, "cost");
        this.stockID = JDOMUtils.getChildElementContent(root, "stockID");
        Element attr = JDOMUtils.getChildElement(root, "attributes", false);
        if (attr != null) {
            try {
                JDOMUtils.buildMap(JDOMUtils.getChildElement(attr, "map"), this.attributes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public float getItemCost() {
        return this.cost;
    }

    public void setItemCost(float cost) {
        this.cost = cost;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String getStockID() {
        return this.stockID;
    }

    public void setStockID(String id) {
        this.stockID = id;
    }

    public float getCostOfItems() {
        return this.cost * (float)this.quantity;
    }

    public Element getAsJDOMElement() {
        Element root = new Element("item");
        root.setAttribute("quantity", String.valueOf(this.quantity));
        root.setAttribute("cost", String.valueOf(this.cost));
        root.addContent((Content)new Element("stockID").addContent(this.stockID));
        if (this.attributes.size() > 0) {
            Element attr = new Element("attributes");
            root.addContent((Content)attr);
            try {
                attr.addContent((Content)JDOMUtils.convertMap(this.attributes));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return root;
    }

    public class XMLConstants {
        public static final String root = "item";
        public static final String stockID = "stockID";
        public static final String quantity = "quantity";
        public static final String cost = "cost";
        public static final String attributes = "attributes";
        public static final String map = "map";
    }
}

