/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.ecom.Account;
import com.gentlyweb.ecom.Address;
import com.gentlyweb.ecom.Note;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class Customer
implements JDOMXmlOutputter {
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String EMAIL = "email";
    private String account = null;
    private Account acc = null;
    private Address addr = null;
    private String name = "";
    private String id = "";
    private String email = "";
    private String fax = null;
    private String phone = null;
    private List orders = new ArrayList();
    private List notes = new ArrayList();

    public Customer() {
    }

    public Customer(Element root) throws JDOMException {
        this.name = JDOMUtils.getChildElementContent(root, NAME);
        this.addr = new Address(JDOMUtils.getChildElement(root, "address"));
        if (root.getChild("account") != null) {
            this.account = JDOMUtils.getChildElementContent(root, "account");
        }
        this.email = JDOMUtils.getChildElementContent(root, EMAIL, false);
        this.phone = JDOMUtils.getChildElementContent(root, "phone", false);
        this.fax = JDOMUtils.getChildElementContent(root, "fax", false);
        this.id = JDOMUtils.getAttributeValue(root, ID);
        this.orders = JDOMUtils.getChildElementContentSet(root, "orders", "order", false);
        Element notes = JDOMUtils.getChildElement(root, "notes", false);
        if (notes != null) {
            List noteEls = JDOMUtils.getChildElements(notes, "note", true);
            for (int i = 0; i < noteEls.size(); ++i) {
                Element el = (Element)noteEls.get(i);
                this.notes.add(new Note(el));
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addOrderID(String id) {
        this.orders.add(id);
    }

    public List getOrderIDs() {
        return this.orders;
    }

    public Address getAddress() {
        return this.addr;
    }

    public void setAddress(Address addr) {
        this.addr = addr;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public Account getAccount() {
        return this.acc;
    }

    public void setAccount(Account acc) {
        this.acc = acc;
    }

    public String getAccountID() {
        return this.account;
    }

    public void setAccountID(String id) {
        this.account = id;
    }

    public void addNote(String username, String text) {
        this.notes.add(new Note(username, text, new Date()));
    }

    public void addNote(Note note) {
        this.notes.add(note);
    }

    public List getNotes() {
        return this.notes;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Element getAsJDOMElement() {
        int i;
        Element root = new Element("customer");
        root.setAttribute(ID, this.id);
        root.addContent((Content)new Element(NAME).addContent(this.name));
        root.addContent((Content)this.addr.getAsJDOMElement());
        if (this.account != null) {
            root.addContent((Content)new Element("account").addContent(this.account));
        }
        root.addContent((Content)new Element(EMAIL).addContent(this.email));
        if (this.phone != null) {
            root.addContent((Content)new Element("phone").addContent(this.phone));
        }
        if (this.fax != null) {
            root.addContent((Content)new Element("fax").addContent(this.fax));
        }
        if (this.orders.size() > 0) {
            Element ordersEl = new Element("orders");
            root.addContent((Content)ordersEl);
            for (i = 0; i < this.orders.size(); ++i) {
                ordersEl.addContent((Content)new Element("order").addContent((String)this.orders.get(i)));
            }
        }
        if (this.notes.size() > 0) {
            Element notesEl = new Element("notes");
            root.addContent((Content)notesEl);
            for (i = 0; i < this.notes.size(); ++i) {
                notesEl.addContent((Content)((Note)this.notes.get(i)).getAsJDOMElement());
            }
        }
        return root;
    }

    public class XMLConstants {
        public static final String root = "customer";
        public static final String name = "name";
        public static final String address = "address";
        public static final String account = "account";
        public static final String phone = "phone";
        public static final String fax = "fax";
        public static final String email = "email";
        public static final String id = "id";
        public static final String orders = "orders";
        public static final String notes = "notes";
        public static final String note = "note";
        public static final String order = "order";
    }
}

