/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.ecom.ConfigDataException;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import com.gentlyweb.xml.XmlMapConverter;
import com.gentlyweb.xml.XmlOutputterException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ConfigMap
implements JDOMXmlOutputter {
    private String id = null;
    private Map map = null;
    private boolean synch = false;
    private boolean canModify = false;
    private Comparator comparator = null;
    private XmlMapConverter xmc = null;
    private int fileWatchTime = 0;
    private boolean sorted = false;
    private String desc = null;
    private String zipExtension = ".gz";
    private Exception fileChangedException = null;
    static /* synthetic */ Class class$java$util$Comparator;
    static /* synthetic */ Class class$org$jdom$Element;
    static /* synthetic */ Class class$com$gentlyweb$xml$JDOMXmlOutputter;

    public ConfigMap(String id, Map m) {
        this.map = m;
        this.id = id;
    }

    public ConfigMap(Element el) throws JDOMException, ConfigDataException {
        String convName;
        JDOMUtils.checkName(el, "configData", false);
        this.id = JDOMUtils.getAttributeValue(el, "id");
        this.desc = JDOMUtils.getChildElementContent(el, "description", false);
        String mapClass = JDOMUtils.getAttributeValue(el, "mapClass", false);
        this.sorted = JDOMUtils.getAttributeValueAsBoolean(el, "sorted", false);
        if (this.sorted) {
            String compClass = JDOMUtils.getAttributeValue(el, "comparatorClass", false);
            if (!compClass.equals("")) {
                String compElName = JDOMUtils.getAttributeValue(el, "comparatorElementName");
                Element cEl = JDOMUtils.getChildElement(el, compElName);
                Class<?> cc = null;
                try {
                    cc = Class.forName(compClass);
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to load comparator class: " + compClass, e);
                }
                Constructor con = this.getComparatorConstructorAndCheck(cc);
                Object[] parms = new Object[]{cEl};
                try {
                    this.comparator = (Comparator)con.newInstance(parms);
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to create new instance of: " + compClass, e);
                }
            }
            if (!mapClass.equals("")) {
                Class<?> mapC = null;
                try {
                    mapC = Class.forName(mapClass);
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to load class: " + mapClass, e);
                }
                if (this.comparator != null) {
                    Class[] parms = new Class[]{class$java$util$Comparator == null ? (class$java$util$Comparator = ConfigMap.class$("java.util.Comparator")) : class$java$util$Comparator};
                    Constructor<?> con = null;
                    try {
                        con = mapC.getConstructor(parms);
                    }
                    catch (Exception e) {
                        throw new ConfigDataException("Unable to find constructor that takes single: " + (class$java$util$Comparator == null ? (class$java$util$Comparator = ConfigMap.class$("java.util.Comparator")) : class$java$util$Comparator).getName() + " argument in class: " + mapClass, e);
                    }
                    Object[] args = new Object[]{this.comparator};
                    this.map = null;
                    try {
                        this.map = (SortedMap)con.newInstance(args);
                    }
                    catch (Exception e) {
                        throw new ConfigDataException("Unable to create new instance of: " + mapClass + " with single: " + (class$java$util$Comparator == null ? (class$java$util$Comparator = ConfigMap.class$("java.util.Comparator")) : class$java$util$Comparator).getName() + " argument", e);
                    }
                }
                this.map = null;
                try {
                    this.map = (SortedMap)mapC.newInstance();
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to create new instance of: " + mapClass, e);
                }
            }
            this.map = this.comparator != null ? new TreeMap(this.comparator) : new TreeMap();
        } else {
            if (!mapClass.equals("")) {
                Class<?> mapC = null;
                try {
                    mapC = Class.forName(mapClass);
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to load class: " + mapClass, e);
                }
                this.map = null;
                try {
                    this.map = (Map)mapC.newInstance();
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to create new instance of: " + mapClass, e);
                }
            }
            this.map = new HashMap();
        }
        this.synch = JDOMUtils.getAttributeValueAsBoolean(el, "synch", false);
        if (this.synch) {
            this.map = this.sorted ? Collections.synchronizedSortedMap((SortedMap)this.map) : Collections.synchronizedMap(this.map);
        }
        if (!(convName = JDOMUtils.getAttributeValue(el, "xmlMapConverterClass", false)).equals("")) {
            Class<?> c = null;
            try {
                c = Class.forName(convName);
            }
            catch (Exception e) {
                throw new ConfigDataException("Unable to load: XmlMapConverter class: " + convName, e);
            }
            this.xmc = null;
            try {
                this.xmc = (XmlMapConverter)c.newInstance();
            }
            catch (Exception e) {
                throw new ConfigDataException("Unable to create new instance of class: " + convName, e);
            }
        }
        try {
            JDOMUtils.buildMap(el, this.map, this.xmc);
        }
        catch (Exception e) {
            throw new ConfigDataException("Unable to build map", e);
        }
        this.canModify = JDOMUtils.getAttributeValueAsBoolean(el, "canModify", false);
        if (!this.canModify) {
            this.map = this.sorted ? Collections.unmodifiableSortedMap((SortedMap)this.map) : Collections.unmodifiableMap(this.map);
        }
        this.fileWatchTime = JDOMUtils.getAttributeValueAsInt(el, "fileWatchTime", false);
    }

    private Constructor getComparatorConstructorAndCheck(Class c) throws ConfigDataException {
        Constructor con = null;
        try {
            Class[] args = new Class[]{class$org$jdom$Element == null ? (class$org$jdom$Element = ConfigMap.class$("org.jdom.Element")) : class$org$jdom$Element};
            con = c.getConstructor(args);
        }
        catch (Exception e) {
            throw new ConfigDataException("Comparator class: " + c.getName() + " does not contain a constructor which takes a single: " + (class$org$jdom$Element == null ? (class$org$jdom$Element = ConfigMap.class$("org.jdom.Element")) : class$org$jdom$Element).getName() + " argument", e);
        }
        if (!(class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = ConfigMap.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter).isAssignableFrom(c)) {
            throw new ConfigDataException("Comparator class: " + c.getName() + " does not implement the: " + (class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = ConfigMap.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter).getName() + " interface");
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Element getAsJDOMElement() throws XmlOutputterException {
        HashMap m = null;
        m = this.sorted ? new LinkedHashMap() : new HashMap();
        Map map = this.map;
        synchronized (map) {
            m.putAll(this.map);
        }
        Element root = new Element("configData");
        if (this.id != null) {
            root.setAttribute("id", this.id);
        }
        root.setAttribute("mapClass", this.map.getClass().getName());
        if (this.synch) {
            root.setAttribute("synch", String.valueOf(this.synch));
        }
        if (this.canModify) {
            root.setAttribute("canModify", String.valueOf(this.canModify));
        }
        if (this.xmc != null) {
            root.setAttribute("xmlMapConverterClass", this.xmc.getClass().getName());
        }
        if (this.fileWatchTime != 0) {
            root.setAttribute("fileWatchTime", String.valueOf(this.fileWatchTime));
        }
        if (this.comparator != null) {
            root.setAttribute("comparatorClass", this.comparator.getClass().getName());
            Element compEl = ((JDOMXmlOutputter)((Object)this.comparator)).getAsJDOMElement();
            root.addContent((Content)compEl);
            root.setAttribute("comparatorElementName", compEl.getName());
        }
        try {
            root.addContent((Content)JDOMUtils.convertMap(m, this.xmc));
        }
        catch (Exception e) {
            throw new XmlOutputterException("Unable to convert map to JDOM element", e);
        }
        return root;
    }

    public void setFileWatchTime(int time) {
        this.fileWatchTime = time;
    }

    public void setXmlMapConverter(XmlMapConverter xmc) {
        this.xmc = xmc;
    }

    public String getID() {
        return this.id;
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Map getMap() {
        return this.map;
    }

    public String getDescription() {
        return this.desc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class XMLConstants {
        public static final String root = "configData";
        public static final String id = "id";
        public static final String mapClass = "mapClass";
        public static final String synch = "synch";
        public static final String xmlMapConverterClass = "xmlMapConverterClass";
        public static final String canModify = "canModify";
        public static final String sorted = "sorted";
        public static final String fileWatchTime = "fileWatchTime";
        public static final String comparatorClass = "comparatorClass";
        public static final String comparatorElementName = "comparatorElementName";
        public static final String description = "description";
    }
}

