/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.ecom.ConfigDataException;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import com.gentlyweb.xml.XmlListConverter;
import com.gentlyweb.xml.XmlOutputterException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ConfigList
implements JDOMXmlOutputter {
    private String id = null;
    private List list = null;
    private boolean synch = false;
    private boolean canModify = false;
    private Comparator comparator = null;
    private XmlListConverter xlc = null;
    private int fileWatchTime = 0;
    private String desc = null;
    static /* synthetic */ Class class$com$gentlyweb$xml$XmlListConverter;
    static /* synthetic */ Class class$org$jdom$Element;
    static /* synthetic */ Class class$com$gentlyweb$xml$JDOMXmlOutputter;

    public ConfigList(String id, List l) {
        this.list = l;
        this.id = id;
    }

    public ConfigList(Element el) throws JDOMException, ConfigDataException {
        String convName;
        JDOMUtils.checkName(el, "configData", false);
        this.id = JDOMUtils.getAttributeValue(el, "id");
        this.desc = JDOMUtils.getChildElementContent(el, "description", false);
        String listClass = JDOMUtils.getAttributeValue(el, "listClass", false);
        this.synch = JDOMUtils.getAttributeValueAsBoolean(el, "synch", false);
        if (!listClass.equals("")) {
            Class<?> c = null;
            try {
                c = Class.forName(listClass);
            }
            catch (Exception e) {
                throw new ConfigDataException("Unable to load list class: " + listClass, e);
            }
            this.list = null;
            try {
                this.list = (List)c.newInstance();
            }
            catch (Exception e) {
                throw new ConfigDataException("Unable to create new instance of class: " + listClass, e);
            }
        }
        this.list = new ArrayList();
        if (this.synch) {
            this.list = Collections.synchronizedList(this.list);
        }
        if (!(convName = JDOMUtils.getAttributeValue(el, "xmlListConverterClass", false)).equals("")) {
            Class<?> c = null;
            try {
                c = Class.forName(convName);
            }
            catch (Exception e) {
                throw new ConfigDataException("Unable to load: " + (class$com$gentlyweb$xml$XmlListConverter == null ? (class$com$gentlyweb$xml$XmlListConverter = ConfigList.class$("com.gentlyweb.xml.XmlListConverter")) : class$com$gentlyweb$xml$XmlListConverter).getName() + " class: " + convName, e);
            }
            this.xlc = null;
            try {
                this.xlc = (XmlListConverter)c.newInstance();
            }
            catch (Exception e) {
                throw new ConfigDataException("Unable to create new instance of class: " + convName, e);
            }
        }
        try {
            JDOMUtils.buildList(el, this.list, this.xlc);
        }
        catch (Exception e) {
            throw new ConfigDataException("Unable to build list", e);
        }
        boolean sorted = JDOMUtils.getAttributeValueAsBoolean(el, "sorted", false);
        if (sorted) {
            String compClass = JDOMUtils.getAttributeValue(el, "comparatorClass", false);
            if (!compClass.equals("")) {
                String compElName = JDOMUtils.getAttributeValue(el, "comparatorElementName");
                Element cEl = JDOMUtils.getChildElement(el, compElName);
                Class<?> cc = null;
                try {
                    cc = Class.forName(compClass);
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to load comparator class: " + compClass, e);
                }
                Constructor con = this.getComparatorConstructorAndCheck(cc);
                Object[] parms = new Object[]{cEl};
                try {
                    this.comparator = (Comparator)con.newInstance(parms);
                }
                catch (Exception e) {
                    throw new ConfigDataException("Unable to create new instance of: " + compClass, e);
                }
                Collections.sort(this.list, this.comparator);
            } else {
                Collections.sort(this.list);
            }
        }
        this.canModify = JDOMUtils.getAttributeValueAsBoolean(el, "canModify", false);
        if (!this.canModify) {
            this.list = Collections.unmodifiableList(this.list);
        }
        this.fileWatchTime = JDOMUtils.getAttributeValueAsInt(el, "fileWatchTime", false);
    }

    private Constructor getComparatorConstructorAndCheck(Class c) throws ConfigDataException {
        Constructor con = null;
        try {
            Class[] args = new Class[]{class$org$jdom$Element == null ? (class$org$jdom$Element = ConfigList.class$("org.jdom.Element")) : class$org$jdom$Element};
            con = c.getConstructor(args);
        }
        catch (Exception e) {
            throw new ConfigDataException("Comparator class: " + c.getName() + " does not contain a constructor which takes a single: " + (class$org$jdom$Element == null ? (class$org$jdom$Element = ConfigList.class$("org.jdom.Element")) : class$org$jdom$Element).getName() + " argument", e);
        }
        if (!(class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = ConfigList.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter).isAssignableFrom(c)) {
            throw new ConfigDataException("Comparator class: " + c.getName() + " does not implement the: " + (class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = ConfigList.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter).getName() + " interface");
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Element getAsJDOMElement() throws XmlOutputterException {
        ArrayList l = new ArrayList();
        List list = this.list;
        synchronized (list) {
            l.addAll(this.list);
        }
        Element root = new Element("configData");
        if (this.id != null) {
            root.setAttribute("id", this.id);
        }
        root.setAttribute("listClass", this.list.getClass().getName());
        if (this.synch) {
            root.setAttribute("synch", String.valueOf(this.synch));
        }
        if (this.canModify) {
            root.setAttribute("canModify", String.valueOf(this.canModify));
        }
        if (this.xlc != null) {
            root.setAttribute("xmlListConverterClass", this.xlc.getClass().getName());
        }
        if (this.fileWatchTime != 0) {
            root.setAttribute("fileWatchTime", String.valueOf(this.fileWatchTime));
        }
        if (this.comparator != null) {
            root.setAttribute("comparatorClass", this.comparator.getClass().getName());
            Element compEl = ((JDOMXmlOutputter)((Object)this.comparator)).getAsJDOMElement();
            root.addContent((Content)compEl);
            root.setAttribute("comparatorElementName", compEl.getName());
        }
        try {
            root.addContent((Content)JDOMUtils.convertList(l, this.xlc));
        }
        catch (Exception e) {
            throw new XmlOutputterException("Unable to convert list to JDOM element", e);
        }
        return root;
    }

    public void setFileWatchTime(int time) {
        this.fileWatchTime = time;
    }

    public void setXmlListConverter(XmlListConverter xlc) {
        this.xlc = xlc;
    }

    public String getID() {
        return this.id;
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public void setComparator(Comparator comp) throws ConfigDataException {
        this.getComparatorConstructorAndCheck(comp.getClass());
        this.comparator = comp;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resort(Comparator comp) {
        if (this.canModify) {
            if (this.synch) {
                List list = this.list;
                synchronized (list) {
                    Collections.sort(this.list, comp);
                }
            } else {
                Collections.sort(this.list, comp);
            }
        }
    }

    public List getList() {
        return this.list;
    }

    public String getDescription() {
        return this.desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resort() {
        if (this.canModify) {
            if (this.synch) {
                List list = this.list;
                synchronized (list) {
                    if (this.comparator != null) {
                        Collections.sort(this.list, this.comparator);
                    } else {
                        Collections.sort(this.list);
                    }
                }
            } else if (this.comparator != null) {
                Collections.sort(this.list, this.comparator);
            } else {
                Collections.sort(this.list);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class XMLConstants {
        public static final String root = "configData";
        public static final String id = "id";
        public static final String listClass = "listClass";
        public static final String synch = "synch";
        public static final String xmlListConverterClass = "xmlListConverterClass";
        public static final String canModify = "canModify";
        public static final String sorted = "sorted";
        public static final String fileWatchTime = "fileWatchTime";
        public static final String comparatorClass = "comparatorClass";
        public static final String comparatorElementName = "comparatorElementName";
        public static final String description = "description";
    }
}

