/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import com.gentlyweb.xml.XmlConversionException;
import java.rmi.server.UID;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class Account
implements JDOMXmlOutputter {
    public static final String DATE_FORMAT = "dateFormat";
    public static final String ADMIN = "admin";
    private String uniqueID = null;
    private String username = "";
    private String password = "";
    private Date dateLastLogin = null;
    private boolean activated = false;
    private String type = "";
    private Map prefs = new HashMap();
    private String name = "";
    private String email = "";
    private int loginFailureCount = 0;
    private long lastAccessed = 0L;
    private TimeZone tz = TimeZone.getDefault();

    public Account() {
    }

    public Account(Element root) throws JDOMException, XmlConversionException {
        JDOMUtils.checkName(root, "account", true);
        this.type = JDOMUtils.getAttributeValue(root, "type");
        this.loginFailureCount = JDOMUtils.getAttributeValueAsInt(root, "loginFailureCount", false);
        this.dateLastLogin = JDOMUtils.getAttributeValueAsDate(root, "lastLogin", false);
        if (root.getAttribute("timeZone") != null) {
            this.tz = TimeZone.getTimeZone(JDOMUtils.getAttributeValue(root, "timeZone"));
        }
        this.activated = JDOMUtils.getAttributeValueAsBoolean(root, "activated");
        this.username = JDOMUtils.getChildElementContent(root, "username");
        this.password = JDOMUtils.getChildElementContent(root, "password");
        this.name = JDOMUtils.getChildElementContent(root, "name");
        this.uniqueID = JDOMUtils.getChildElementContent(root, "uniqueID", false);
        if (this.uniqueID.equals("")) {
            this.uniqueID = null;
        }
        this.email = JDOMUtils.getChildElementContent(root, "email", false);
        Element prefsEl = JDOMUtils.getChildElement(root, "preferences", false);
        if (prefsEl != null) {
            JDOMUtils.buildMap(prefsEl, this.prefs);
        }
    }

    public void setLoginFailureCount(int count) {
        this.loginFailureCount = count;
    }

    public int getLoginFailureCount() {
        return this.loginFailureCount;
    }

    public int incrLoginFailureCount() {
        return ++this.loginFailureCount;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLastLoginDate(Date date) {
        this.dateLastLogin = date;
    }

    public void setActivated(boolean act) {
        this.activated = act;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Date getLastLoginDate() {
        return this.dateLastLogin;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setPreference(String name, String value) {
        this.prefs.put(name, value);
    }

    public void setPreferences(Map prefs) {
        this.prefs = prefs;
    }

    public Map getPreferences() {
        return this.prefs;
    }

    public boolean hasPreference(String name) {
        return this.prefs.containsKey(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEmail(String addr) {
        this.email = addr;
    }

    public String getEmail() {
        return this.email;
    }

    public void createUniqueID() {
        this.uniqueID = new UID().toString();
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(String id) {
        this.uniqueID = id;
    }

    public String getPreference(String name) {
        return (String)this.prefs.get(name);
    }

    public long getLastAccessTime() {
        return this.lastAccessed;
    }

    public void touch() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public Date getTimeZoneAdjustedDate(Date date) {
        Calendar c = Calendar.getInstance(this.tz);
        c.setTime(date);
        return c.getTime();
    }

    public void setTimeZoneID(String tz) {
        this.tz = TimeZone.getTimeZone(tz);
    }

    public TimeZone getTimeZone() {
        return (TimeZone)this.tz.clone();
    }

    public String getTimeZoneID() {
        return this.tz.getID();
    }

    public Element getAsJDOMElement() {
        Element root = new Element("account");
        root.setAttribute("type", this.type);
        root.setAttribute("activated", String.valueOf(this.activated));
        root.setAttribute("loginFailureCount", String.valueOf(this.loginFailureCount));
        if (this.dateLastLogin != null) {
            root.setAttribute("lastLogin", String.valueOf(this.dateLastLogin.getTime()));
        }
        if (this.tz != null) {
            root.setAttribute("timeZone", this.tz.getID());
        }
        Element username = new Element("username");
        username.addContent(this.username);
        root.addContent((Content)username);
        Element password = new Element("password");
        password.addContent(this.password);
        root.addContent((Content)password);
        if (this.uniqueID != null && !this.uniqueID.equals("")) {
            Element uniqueID = new Element("uniqueID");
            uniqueID.addContent(this.uniqueID);
            root.addContent((Content)uniqueID);
        }
        if (!this.name.equals("")) {
            Element name = new Element("name");
            name.addContent(this.name);
            root.addContent((Content)name);
        }
        if (!this.email.equals("")) {
            Element email = new Element("email");
            email.addContent(this.email);
            root.addContent((Content)email);
        }
        if (this.prefs.size() > 0) {
            try {
                root.addContent((Content)JDOMUtils.convertMap(this.prefs));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return root;
    }

    public class XMLConstants {
        public static final String root = "account";
        public static final String username = "username";
        public static final String password = "password";
        public static final String name = "name";
        public static final String email = "email";
        public static final String uniqueID = "uniqueID";
        public static final String activated = "activated";
        public static final String type = "type";
        public static final String loginFailureCount = "loginFailureCount";
        public static final String preferences = "preferences";
        public static final String timeZone = "timeZone";
        public static final String lastLogin = "lastLogin";
    }
}

