/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.datastore.DataStore;
import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.datastore.Searchable;
import com.gentlyweb.utils.GeneralFilter;
import com.gentlyweb.utils.ObjectCache;
import com.gentlyweb.utils.ObjectCacheManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataManager
implements ObjectCacheManager {
    protected DataStore dataStore = null;
    protected ObjectCache cache = null;

    public AbstractDataManager(boolean useCache, int cachePolicy) {
        if (useCache) {
            this.cache = new ObjectCache(cachePolicy);
        }
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeObject(Object key) throws DataStoreException {
        Object ret = null;
        try {
            if (this.dataStore != null) {
                try {
                    ret = this.dataStore.remove(key);
                }
                catch (DataStoreException e) {
                    throw new DataStoreException(e.getMessage(), e.getException());
                }
            }
            Object var5_4 = null;
            if (this.cache != null) {
                this.cache.remove(key);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.cache != null) {
                this.cache.remove(key);
            }
            throw throwable;
        }
        return ret;
    }

    public void putObject(Object key, Object obj) throws DataStoreException {
        if (this.dataStore != null) {
            try {
                this.dataStore.put(key, obj);
            }
            catch (DataStoreException e) {
                if (this.cache != null) {
                    this.cache.remove(key);
                }
                throw new DataStoreException(e.getMessage(), e.getException());
            }
        }
        this.updateCache(key, obj);
    }

    public Object getObject(Object key) throws DataStoreException {
        Object item = null;
        if (this.cache != null) {
            item = this.cache.get(key);
            if (item == null && this.dataStore != null) {
                item = this.dataStore.get(key);
                if (item == null) {
                    return null;
                }
                this.cache.put(key, item);
            }
        } else if (this.dataStore != null) {
            item = this.dataStore.get(key);
        }
        return item;
    }

    public List keys() throws DataStoreException {
        if (this.dataStore == null) {
            return new ArrayList();
        }
        return this.dataStore.keys();
    }

    public List cacheKeys() {
        ArrayList retData = new ArrayList();
        if (this.cache != null) {
            return this.cache.keys();
        }
        return retData;
    }

    public void setCachingOff() {
        if (this.cache != null) {
            this.cache.flush();
            this.cache = null;
        }
    }

    public void setCachingOn(int maxSize, int policy) {
        if (this.cache == null) {
            this.cache = new ObjectCache(policy);
        } else {
            this.cache.setPolicy(policy);
        }
        this.cache.setMaxSize(maxSize);
    }

    public void setPolicy(int policy) {
        if (this.cache != null) {
            this.cache.setPolicy(policy);
        }
    }

    public boolean hasKey(Object key) throws DataStoreException {
        if (this.cache != null && this.cache.get(key) != null) {
            return true;
        }
        if (this.dataStore != null) {
            return this.dataStore.containsKey(key);
        }
        return false;
    }

    private void updateCache(Object key, Object item) {
        if (this.cache != null) {
            this.cache.put(key, item);
        }
    }

    public synchronized void initCache() throws IllegalStateException, DataStoreException {
        if (this.cache == null) {
            throw new IllegalStateException("Cannot init cache when caching is not on.");
        }
        if (this.dataStore == null) {
            throw new IllegalStateException("No DataStore available.");
        }
        List keys = this.dataStore.keys();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            Object key = keys.get(i);
            Object value = this.dataStore.get(key);
            this.cache.put(key, value);
        }
    }

    public synchronized List getObjects(GeneralFilter filter) throws DataStoreException {
        List keys = null;
        if (this.dataStore != null) {
            Searchable searcher = this.dataStore.getSearcher();
            if (searcher != null) {
                keys = searcher.getKeys(filter);
            } else {
                try {
                    keys = filter.filter(this.dataStore.keys());
                }
                catch (Exception e) {
                    throw new DataStoreException("Unable to filter object keys.", e);
                }
            }
        } else if (this.cache != null) {
            keys = this.cache.keys();
        }
        int size = keys.size();
        ArrayList<Object> retData = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = keys.get(i);
            retData.add(this.getObject(key));
        }
        return retData;
    }

    public synchronized List getAllObjects() throws DataStoreException {
        List keys = null;
        if (this.dataStore != null) {
            keys = this.dataStore.keys();
        } else if (this.cache != null) {
            keys = this.cache.keys();
        }
        int size = keys.size();
        ArrayList<Object> retData = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            retData.add(this.getObject(keys.get(i)));
        }
        return retData;
    }

    public int capacity() {
        if (this.cache != null) {
            return this.cache.capacity();
        }
        return -1;
    }

    public boolean isEmpty() {
        if (this.cache != null) {
            return this.cache.isEmpty();
        }
        return true;
    }

    public synchronized void putAll(Map map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public void toMap(Map map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public synchronized void resize(int size) {
        if (this.cache != null && size > 0) {
            this.cache.resize(size);
        }
    }

    public void setMaxSize(int max) {
        if (this.cache != null && max > 0) {
            this.cache.setMaxSize(max);
        }
    }

    public void merge(ObjectCache cache) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public synchronized void flush() {
        if (this.cache != null) {
            this.cache.flush();
        }
    }

    public void refreshCacheForKey(Object key) throws DataStoreException {
        Object item = null;
        if (this.cache != null && this.dataStore != null) {
            item = this.dataStore.get(key);
            if (item == null) {
                return;
            }
            this.cache.put(key, item);
        }
    }
}

