/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ACL
implements JDOMXmlOutputter {
    private Map groups = new HashMap();
    private boolean immutable = true;
    private String id = null;

    public ACL(String id) {
        this.id = id;
        this.immutable = false;
    }

    public ACL(File file, String zipExtension) throws JDOMException, IOException {
        this(JDOMUtils.getFileAsElement(file, zipExtension));
    }

    public ACL(Element root) throws JDOMException {
        JDOMUtils.checkName(root, "acl", true);
        this.immutable = JDOMUtils.getAttributeValueAsBoolean(root, "immutable", false);
        this.id = JDOMUtils.getAttributeValue(root, "id", false);
        List groupEls = JDOMUtils.getChildElements(root, "group", true);
        for (int i = 0; i < groupEls.size(); ++i) {
            Element el = (Element)groupEls.get(i);
            Group g = new Group(el);
            String id = g.id;
            if (this.groups.containsKey(id)) {
                throw new JDOMException("Found repeated group id: " + id + " (path: " + JDOMUtils.getPath(el) + ")");
            }
            this.groups.put(id, g);
        }
    }

    public String getID() {
        return this.id;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void addActionForUser(String group, String user, String action) throws IllegalStateException {
        if (this.isImmutable()) {
            throw new IllegalStateException("ACL is immutable.");
        }
        Group g = (Group)this.groups.get(group);
        if (g != null) {
            g.addActionForUser(user, action);
        }
    }

    public void removeActionForUser(String group, String user, String action) throws IllegalStateException {
        if (this.isImmutable()) {
            throw new IllegalStateException("ACL is immutable.");
        }
        Group g = (Group)this.groups.get(group);
        if (g != null) {
            g.removeActionForUser(user, action);
        }
    }

    public void addUser(String group, String user, List allows) throws IllegalStateException {
        if (this.isImmutable()) {
            throw new IllegalStateException("ACL is immutable.");
        }
        Group g = (Group)this.groups.get(group);
        if (g == null) {
            g = new Group(group);
            this.groups.put(group, g);
        }
        g.addUser(user, allows);
    }

    public void removeUser(String group, String user) throws IllegalStateException {
        if (this.isImmutable()) {
            throw new IllegalStateException("ACL is immutable.");
        }
        Group g = (Group)this.groups.get(group);
        if (g != null) {
            g.removeUser(user);
        }
    }

    public void addGroup(String group, List allows, List disallows) throws IllegalStateException {
        if (this.isImmutable()) {
            throw new IllegalStateException("ACL is immutable.");
        }
        Group g = (Group)this.groups.get(group);
        if (g == null) {
            g = new Group(group);
            this.groups.put(group, g);
        }
        g.setAllows(allows);
        g.setDisallows(disallows);
    }

    public boolean actionAllowed(String group, String user, String action) {
        Group g = (Group)this.groups.get(group);
        if (g != null) {
            return g.allows(user, action);
        }
        return false;
    }

    public Element getAsJDOMElement() {
        Element root = new Element("acl");
        if (this.id != null) {
            root.setAttribute("id", this.id);
        }
        root.setAttribute("immutable", String.valueOf(this.immutable));
        Iterator iter = this.groups.keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Group g = (Group)this.groups.get(id);
            root.addContent((Content)g.getAsJDOMElement());
        }
        return root;
    }

    private static void getValues(Element el, String name, Map map) throws JDOMException {
        if (el.getAttribute(name) != null) {
            StringTokenizer t = new StringTokenizer(JDOMUtils.getAttributeValue(el, name), ",");
            while (t.hasMoreTokens()) {
                map.put(t.nextToken(), "");
            }
        }
        if (el.getChild(name) != null) {
            List vals = JDOMUtils.getChildElementContentSet(el, name, "value", true);
            for (int i = 0; i < vals.size(); ++i) {
                map.put(vals.get(i), "");
            }
        }
    }

    private class User
    implements JDOMXmlOutputter {
        private Map allows = new HashMap();
        private String id = "";

        public User(String id, List allows) {
            this.id = id;
            this.setAllows(allows);
        }

        public User(Element root) throws JDOMException {
            JDOMUtils.checkName(root, "user", true);
            this.id = JDOMUtils.getAttributeValue(root, "id");
            ACL.getValues(root, "allows", this.allows);
        }

        public Element getAsJDOMElement() {
            Element root = new Element("user");
            root.setAttribute("id", this.id);
            if (this.allows.size() > 0) {
                Element allows = new Element("allows");
                root.addContent((Content)allows);
                Iterator iter = this.allows.keySet().iterator();
                while (iter.hasNext()) {
                    Element e = new Element("value");
                    allows.addContent((Content)e);
                    e.addContent((String)iter.next());
                }
            }
            return root;
        }

        public void setAllows(List allows) {
            this.allows.clear();
            for (int i = 0; i < allows.size(); ++i) {
                this.allows.put((String)allows.get(i), "");
            }
        }

        public void removeAction(String action) {
            this.allows.remove(action);
        }

        public void addAction(String action) {
            this.allows.put(action, "");
        }

        public boolean allows(String val) {
            return this.allows.containsKey(val);
        }
    }

    private class Group
    implements JDOMXmlOutputter {
        private Map allows = new HashMap();
        private Map disallows = new HashMap();
        private Map users = new HashMap();
        private String id = "";

        public Group(String id) {
            this.id = id;
        }

        public Group(Element root) throws JDOMException {
            this.id = JDOMUtils.getAttributeValue(root, "id");
            ACL.getValues(root, "allows", this.allows);
            ACL.getValues(root, "disallows", this.disallows);
            if (root.getChild("users") != null) {
                List userEls = JDOMUtils.getChildElementSet(root, "users", "user", true);
                for (int j = 0; j < userEls.size(); ++j) {
                    Element uEl = (Element)userEls.get(j);
                    User u = new User(uEl);
                    String uid = u.id;
                    if (this.users.containsKey(uid)) {
                        throw new JDOMException("Found repeated user id: " + uid + " for group: " + this.id + " (path: " + JDOMUtils.getPath(uEl) + ")");
                    }
                    this.users.put(uid, u);
                }
            }
        }

        public Element getAsJDOMElement() {
            Element e;
            Iterator iter;
            Element root = new Element("group");
            root.setAttribute("id", this.id);
            if (this.allows.size() > 0) {
                Element allows = new Element("allows");
                root.addContent((Content)allows);
                iter = this.allows.keySet().iterator();
                while (iter.hasNext()) {
                    e = new Element("value");
                    allows.addContent((Content)e);
                    e.addContent((String)iter.next());
                }
            }
            if (this.disallows.size() > 0) {
                Element disallows = new Element("disallows");
                root.addContent((Content)disallows);
                iter = this.disallows.keySet().iterator();
                while (iter.hasNext()) {
                    e = new Element("value");
                    disallows.addContent((Content)e);
                    e.addContent((String)iter.next());
                }
            }
            if (this.users.size() > 0) {
                Element users = new Element("users");
                root.addContent((Content)users);
                iter = this.users.keySet().iterator();
                while (iter.hasNext()) {
                    User u = (User)this.users.get(iter.next());
                    users.addContent((Content)u.getAsJDOMElement());
                }
            }
            return root;
        }

        public void removeUser(String user) {
            this.users.remove(user);
        }

        public void addUser(String user, List allows) {
            User u = (User)this.users.get(user);
            if (u == null) {
                u = new User(user, allows);
                this.users.put(user, u);
            } else {
                u.setAllows(allows);
            }
        }

        public void addActionForUser(String user, String action) {
            User u = (User)this.users.get(user);
            if (u != null) {
                u.addAction(action);
            }
        }

        public void removeActionForUser(String user, String action) {
            User u = (User)this.users.get(user);
            if (u != null) {
                u.removeAction(action);
            }
        }

        public void setAllows(List allows) {
            this.allows.clear();
            for (int i = 0; i < allows.size(); ++i) {
                this.allows.put((String)allows.get(i), "");
            }
        }

        public void setDisallows(List disallows) {
            this.disallows.clear();
            for (int i = 0; i < disallows.size(); ++i) {
                this.disallows.put((String)disallows.get(i), "");
            }
        }

        public boolean allows(String user, String val) {
            if (this.disallows.containsKey(val)) {
                return false;
            }
            if (this.allows.containsKey(val)) {
                return true;
            }
            User u = (User)this.users.get(user);
            if (u == null) {
                return false;
            }
            return u.allows(val);
        }
    }

    public class XMLConstants {
        public static final String root = "acl";
        public static final String group = "group";
        public static final String users = "users";
        public static final String id = "id";
        public static final String allows = "allows";
        public static final String disallows = "disallows";
        public static final String user = "user";
        public static final String immutable = "immutable";
        public static final String value = "value";
    }
}

