/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.datastore;

import com.gentlyweb.datastore.DataStore;
import com.gentlyweb.datastore.DataStoreEvent;
import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.datastore.DataStoreListener;
import com.gentlyweb.datastore.DataStoreReader;
import com.gentlyweb.datastore.DataStoreWriter;
import com.gentlyweb.datastore.GeneralDataStoreSearcher;
import com.gentlyweb.datastore.Searchable;
import com.gentlyweb.utils.FileChangeEvent;
import com.gentlyweb.utils.FileChangeListener;
import com.gentlyweb.utils.FileWatcher;
import com.gentlyweb.xml.JDOMUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class XMLFileDataStore
implements DataStore,
DataStoreReader,
DataStoreWriter,
FileChangeListener,
Runnable {
    private static final int SINGLE_CLASS = 1;
    private static final int XPATH = 2;
    private int mode = -1;
    private File dir = null;
    private String xpathLoc = null;
    private Constructor con = null;
    private Map conMappings = new HashMap();
    private ClassLoader classLoader = null;
    private String zipExtension = ".gz";
    private List listeners = new ArrayList();
    private FileWatcher fileWatcher = new FileWatcher();
    private long watchTime = 5000L;
    private boolean watchFiles = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jdom$Element;
    static /* synthetic */ Class class$com$gentlyweb$xml$JDOMXmlOutputter;

    public XMLFileDataStore(File dir, Class c) throws DataStoreException {
        this.dir = dir;
        this.checkDirectory(dir);
        this.con = this.getConstructor(c);
        this.mode = 1;
    }

    public XMLFileDataStore(File dir, String xpathLoc, Map mappings) throws DataStoreException {
        this.checkDirectory(dir);
        this.mode = 2;
        this.dir = dir;
        this.xpathLoc = xpathLoc;
        Iterator iter = mappings.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Class c = (Class)mappings.get(key);
            this.conMappings.put(key, this.getConstructor(c));
        }
    }

    public XMLFileDataStore(File dir, String xpathLoc) throws DataStoreException {
        this.checkDirectory(dir);
        this.mode = 2;
        this.dir = dir;
        this.xpathLoc = xpathLoc;
    }

    public XMLFileDataStore(File dir, String xpathLoc, ClassLoader classLoader, Map mappings) throws DataStoreException {
        this(dir, xpathLoc, mappings);
        this.classLoader = classLoader;
    }

    public XMLFileDataStore(File dir, String xpathLoc, ClassLoader classLoader) throws DataStoreException {
        this(dir, xpathLoc);
        this.classLoader = classLoader;
    }

    public void watchFiles(boolean value) {
        this.watchFiles = value;
        if (!this.watchFiles) {
            this.fileWatcher.stop();
        } else {
            this.fileWatcher.start();
        }
    }

    public void setDataStoreWriter(DataStoreWriter w) {
    }

    public DataStoreWriter getDataStoreWriter() {
        return this;
    }

    public DataStoreReader getDataStoreReader() {
        return this;
    }

    public void setDataStoreReader(DataStoreReader r) {
    }

    public void setFileWatchTime(long time) {
        this.watchTime = time;
        this.fileWatcher.setCheckRepeatTime(time);
    }

    public void addDataStoreListener(DataStoreListener listener, boolean ignoreExternalEvents) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener l = (Listener)this.listeners.get(i);
            if (l.listener != listener) continue;
            l.hideExternalEvents = ignoreExternalEvents;
            return;
        }
        Listener ll = new Listener();
        ll.listener = listener;
        ll.hideExternalEvents = ignoreExternalEvents;
        this.listeners.add(ll);
    }

    public synchronized void removeDataStoreListener(DataStoreListener list) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener l = (Listener)this.listeners.get(i);
            if (l.listener != list) continue;
            this.listeners.remove(i);
            return;
        }
        if (this.listeners.size() == 0) {
            this.fileWatcher.stop();
        }
    }

    public void setZipExtension(String ext) {
        this.zipExtension = ext;
    }

    private void checkDirectory(File dir) throws DataStoreException {
        if (dir == null) {
            throw new DataStoreException("No directory specified");
        }
        if (!dir.exists()) {
            throw new DataStoreException("Directory: " + dir.getPath() + " does not exist.");
        }
        if (!dir.isDirectory()) {
            throw new DataStoreException("File: " + dir.getPath() + " is NOT a directory in the file system.");
        }
        if (!dir.canWrite()) {
            throw new DataStoreException("Cannot write to directory: " + dir.getPath());
        }
        if (!dir.canRead()) {
            throw new DataStoreException("Cannot read from directory: " + dir.getPath());
        }
    }

    private String checkKeyType(Object key) throws DataStoreException {
        if (key == null) {
            throw new DataStoreException("No key specified");
        }
        if (!(key instanceof String)) {
            throw new DataStoreException("Expected key to be of type: " + (class$java$lang$String == null ? (class$java$lang$String = XMLFileDataStore.class$("java.lang.String")) : class$java$lang$String).getName());
        }
        return (String)key;
    }

    public boolean eventsSupported() {
        return true;
    }

    public int getEventsSupported() {
        return 10;
    }

    public boolean containsKey(Object key) throws DataStoreException {
        String id = this.checkKeyType(key);
        File f = new File(this.dir.getPath() + '/' + id);
        return f.exists();
    }

    public boolean isEmpty() throws DataStoreException {
        File[] files = this.dir.listFiles();
        if (files == null) {
            throw new DataStoreException("Unable to read directory contents for: " + this.dir.getPath());
        }
        return files.length == 0;
    }

    public boolean containsValue(Object value) throws DataStoreException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public synchronized void putAll(Map data) throws DataStoreException {
        Iterator iter = data.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = data.get(key);
            this.put(key, value);
        }
    }

    public void toMap(Map map) throws DataStoreException {
        File[] files = this.dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            map.put(files[i].getName(), this.get(files[i].getName()));
        }
    }

    public int size() throws DataStoreException {
        return this.keys().size();
    }

    public void clear() throws DataStoreException {
        List keys = this.keys();
        for (int i = 0; i < keys.size(); ++i) {
            this.remove(keys.get(i));
        }
    }

    public List keys() throws DataStoreException {
        File[] files = this.dir.listFiles();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            data.add(files[i].getName());
        }
        return data;
    }

    public List values() throws DataStoreException {
        File[] files = this.dir.listFiles();
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            data.add(this.get(files[i].getName()));
        }
        return data;
    }

    public boolean externalEventsSupported() {
        return true;
    }

    public Searchable getSearcher() {
        return new GeneralDataStoreSearcher(this);
    }

    public synchronized Object remove(Object key) throws DataStoreException {
        String id = this.checkKeyType(key);
        File f = new File(this.dir.getPath() + '/' + id);
        if (!f.exists()) {
            return null;
        }
        this.fileWatcher.removeFile(f);
        if (!f.delete()) {
            throw new DataStoreException("Unable to remove file: " + f.getPath() + " associated with key: " + id);
        }
        DataStoreEvent e = new DataStoreEvent(this, id, null, 1, null);
        this.fireListeners(e, false);
        return null;
    }

    public Object get(Object key) throws DataStoreException {
        String id = this.checkKeyType(key);
        File f = new File(this.dir.getPath() + '/' + id);
        if (!f.exists()) {
            return null;
        }
        Element root = null;
        try {
            root = JDOMUtils.getFileAsElement(f, this.zipExtension);
        }
        catch (Exception e) {
            throw new DataStoreException("Unable to read file: " + f.getPath() + " into a: " + (class$org$jdom$Element == null ? (class$org$jdom$Element = XMLFileDataStore.class$("org.jdom.Element")) : class$org$jdom$Element).getName(), e);
        }
        if (this.mode == 2) {
            String val = null;
            try {
                val = JDOMUtils.getValueForXPath(root, this.xpathLoc);
            }
            catch (Exception e) {
                throw new DataStoreException("Unable to get value for XPath expression: " + this.xpathLoc + " for file: " + f.getPath(), e);
            }
            if (val == null) {
                throw new DataStoreException("XPath: " + this.xpathLoc + " does not map to a value in the xml file: " + f.getPath() + ", root element: " + root.getName());
            }
            Constructor con = (Constructor)this.conMappings.get(val);
            if (con != null) {
                return this.createInstance(con, root, f);
            }
            Class<?> c = null;
            try {
                c = this.classLoader != null ? this.classLoader.loadClass(val) : Class.forName(val);
            }
            catch (Exception e) {
                throw new DataStoreException("Unable to load class: " + val + ", gained from XPath expression: " + this.xpathLoc + " in file: " + f.getPath(), e);
            }
            con = this.getConstructor(c);
            this.conMappings.put(val, con);
            return this.createInstance(con, root, f);
        }
        if (this.mode == 1) {
            return this.createInstance(this.con, root, f);
        }
        return null;
    }

    private Constructor getConstructor(Class c) throws DataStoreException {
        try {
            Class[] parms = new Class[]{class$org$jdom$Element == null ? (class$org$jdom$Element = XMLFileDataStore.class$("org.jdom.Element")) : class$org$jdom$Element};
            return c.getConstructor(parms);
        }
        catch (Exception e) {
            throw new DataStoreException("Unable to get required constructor (one that takes a single: " + (class$org$jdom$Element == null ? (class$org$jdom$Element = XMLFileDataStore.class$("org.jdom.Element")) : class$org$jdom$Element).getName() + " argument) in class: " + c.getName(), e);
        }
    }

    private Object createInstance(Constructor constr, Element e, File f) throws DataStoreException {
        Object[] args = new Object[]{e};
        try {
            return constr.newInstance(args);
        }
        catch (Exception ee) {
            Throwable t = ee;
            if (ee instanceof InvocationTargetException) {
                t = ((InvocationTargetException)ee).getTargetException();
            }
            throw new DataStoreException("Unable to create new instance of: " + constr.getDeclaringClass().getName() + " from data read from file: " + f.getPath(), t);
        }
    }

    public void put(Object key, Object value) throws DataStoreException {
        if (!(class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = XMLFileDataStore.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter).isAssignableFrom(value.getClass())) {
            throw new DataStoreException("Expected value to be of type: " + (class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = XMLFileDataStore.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter).getName());
        }
        String id = this.checkKeyType(key);
        File f = new File(this.dir.getPath() + '/' + id);
        boolean exists = f.exists();
        try {
            JDOMUtils.writeObjectToFile(value, f, true);
        }
        catch (Exception e) {
            throw new DataStoreException("Cannot write object with key: " + id + " to file: " + f.getPath(), e);
        }
        int type = 4;
        if (exists) {
            type = 0;
        }
        DataStoreEvent event = new DataStoreEvent(this, id, value, type, null);
        this.fireListeners(event, false);
        if (this.watchFiles) {
            this.fileWatcher.addFile(f);
        }
    }

    public void watchAllFiles() throws DataStoreException {
        this.watchFiles = true;
        List keys = this.keys();
        for (int i = 0; i < keys.size(); ++i) {
            String id = (String)keys.get(i);
            File f = new File(this.dir.getPath() + '/' + id);
            this.fileWatcher.addFile(f);
        }
        this.fileWatcher.addFileChangeListener(this);
        this.fileWatcher.start();
    }

    private void fireListeners(DataStoreEvent event, boolean external) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener l = (Listener)this.listeners.get(i);
            if (external && l.hideExternalEvents) continue;
            l.listener.handleEvent(event);
        }
    }

    public synchronized void fileChanged(FileChangeEvent e, int types) {
        File f = e.getFile();
        if (f.getPath().equals(this.dir.getPath())) {
            int type = -1;
            if ((types & 2) == 1) {
                type = 2;
            }
            if ((types & 1) == 1) {
                type = 3;
            }
            if ((types & 0x400) == 1) {
                type = e.getNewFileDetails().isDirectory() ? 3 : 2;
            }
            if (type != -1) {
                DataStoreEvent ev = new DataStoreEvent(this, f.getName(), null, type, e);
                this.fireListeners(ev, false);
            }
            return;
        }
        int type = -1;
        if ((types & 1) == 1) {
            type = 4;
        }
        if ((types & 2) == 1) {
            type = 1;
        }
        if ((types & 0x400) == 1) {
            type = e.getNewFileDetails().isDirectory() ? 1 : 4;
        }
        if ((types & 4) == 1 || (types & 8) == 1 || (types & 0x10) == 1 || (types & 0x20) == 1 || (types & 0x40) == 1 || (types & 0x100) == 1 || (types & 0x200) == 1 || (types & 0x80) == 1 || (types & 0x400) == 1) {
            type = 0;
        }
        DataStoreEvent event = new DataStoreEvent(this, f.getName(), null, type, e);
        this.fireListeners(event, true);
    }

    public void run() {
        this.fileWatcher.stop();
        this.fileWatcher.clearAll();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listener {
        private DataStoreListener listener = null;
        private boolean hideExternalEvents = true;

        private Listener() {
        }
    }
}

