/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.datastore;

import com.gentlyweb.datastore.DataStore;
import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.datastore.Searchable;
import com.gentlyweb.utils.GeneralFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneralDataStoreSearcher
implements Searchable {
    private DataStore ds = null;

    public GeneralDataStoreSearcher(DataStore ds) {
        this.ds = ds;
    }

    private synchronized List filter(GeneralFilter f, List l) throws DataStoreException {
        Class c = f.getFilterClass();
        int size = l.size();
        ArrayList retData = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Object k = l.get(i);
            if (k == null || !c.isAssignableFrom(k.getClass())) continue;
            try {
                if (!f.accept(k)) continue;
                retData.add(k);
                continue;
            }
            catch (Exception e) {
                throw new DataStoreException("Unable to filter object: " + k.toString(), e);
            }
        }
        return retData;
    }

    public synchronized List getKeys(GeneralFilter f) throws DataStoreException {
        return this.filter(f, this.ds.keys());
    }

    public synchronized Map removeKeys(GeneralFilter f) throws DataStoreException {
        List keys = this.getKeys(f);
        return this.removeKeys(keys);
    }

    public synchronized List getValues(GeneralFilter f) throws DataStoreException {
        return this.filter(f, this.ds.values());
    }

    public synchronized Map getValuesForKeys(GeneralFilter f) throws DataStoreException {
        List l = this.getKeys(f);
        return this.getValuesForKeys(l);
    }

    private synchronized List compareTo(Comparable c, List l) {
        int size = l.size();
        ArrayList retData = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Object v = l.get(i);
            try {
                if (c.compareTo(v) != 0) continue;
                retData.add(v);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return retData;
    }

    public synchronized List getKeys(Comparable c) throws DataStoreException {
        List keys = this.ds.keys();
        return this.compareTo(c, keys);
    }

    public synchronized List getValues(Comparable c) throws DataStoreException {
        List values = this.ds.values();
        return this.compareTo(c, values);
    }

    public synchronized Map getValuesForKeys(Comparable c) throws DataStoreException {
        List keys = this.getKeys(c);
        return this.getValuesForKeys(keys);
    }

    private synchronized Map getValuesForKeys(List keys) throws DataStoreException {
        int size = keys.size();
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            Object k = keys.get(i);
            Object v = this.ds.get(k);
            map.put(k, v);
        }
        return map;
    }

    private synchronized Map removeKeys(List keys) throws DataStoreException {
        int size = keys.size();
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            Object key = keys.get(i);
            Object value = this.ds.get(key);
            this.ds.remove(key);
            map.put(key, value);
        }
        return map;
    }

    public synchronized Map removeKeys(Comparable c) throws DataStoreException {
        List keys = this.getKeys(c);
        return this.removeKeys(keys);
    }

    private synchronized List compare(Comparator c, Object ref, List l) {
        int size = l.size();
        ArrayList retData = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Object v = l.get(i);
            try {
                if (c.compare(ref, v) != 0) continue;
                retData.add(v);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return retData;
    }

    public synchronized List getKeys(Comparator c, Object ref) throws DataStoreException {
        List keys = this.ds.keys();
        return this.compare(c, ref, keys);
    }

    public synchronized List getValues(Comparator c, Object ref) throws DataStoreException {
        List keys = this.ds.values();
        return this.compare(c, ref, keys);
    }

    public synchronized Map getValuesForKeys(Comparator c, Object ref) throws DataStoreException {
        List keys = this.getKeys(c, ref);
        return this.getValuesForKeys(keys);
    }

    public synchronized Map removeKeys(Comparator c, Object ref) throws DataStoreException {
        List keys = this.getKeys(c, ref);
        return this.removeKeys(keys);
    }
}

