/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.datastore;

import com.gentlyweb.datastore.DataStore;
import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.datastore.DataStoreListener;
import com.gentlyweb.datastore.DataStoreManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultDataStoreManager
implements DataStoreManager {
    protected DataStore ds = null;

    public DefaultDataStoreManager(DataStore ds) {
        this.ds = ds;
    }

    public void addDataStoreListener(DataStoreListener l, boolean ignoreExternalEvents) {
        this.ds.addDataStoreListener(l, ignoreExternalEvents);
    }

    public int size() throws DataStoreException {
        return this.ds.size();
    }

    public synchronized void merge(DataStore dataStore) throws DataStoreException {
        if (!dataStore.getClass().getName().equals(this.ds.getClass().getName())) {
            throw new DataStoreException("Expected DataStore to be of type: " + this.ds.getClass().getName() + ", got: " + dataStore.getClass().getName());
        }
        List keys = dataStore.keys();
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            Object value = dataStore.get(key);
            this.ds.put(key, value);
        }
    }

    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not supported.");
    }

    public void removeDataStoreListener(DataStoreListener l) {
        this.ds.removeDataStoreListener(l);
    }

    public synchronized void putAll(Map map) throws DataStoreException {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = map.get(key);
            this.ds.put(key, value);
        }
    }

    public boolean isEmpty() throws DataStoreException {
        return this.ds.isEmpty();
    }

    public void toMap(Map map) throws DataStoreException {
        this.ds.toMap(map);
    }

    public int getEventsSupported() {
        return this.ds.getEventsSupported();
    }

    public boolean externalEventsSupported() {
        return this.ds.externalEventsSupported();
    }

    public boolean eventsSupported() {
        return this.ds.eventsSupported();
    }
}

