/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.cron;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RepeatTaskInfo {
    private String timeFormat = null;
    private String dateFormat = "dd MMM yyyy";
    private String id = null;
    private String taskClass = null;
    private int executionCount = 0;
    private int executionLimit = 1;
    private Date startTime = null;
    private boolean runAsDaemon = false;
    private boolean ownTimer = false;
    private String description = null;
    private int repeatTime = 0;
    private int runOnLoad = -1;
    private String units = null;
    private List timings = new ArrayList();

    protected int incrementExecutionCount() {
        return ++this.executionCount;
    }

    protected void addTiming(long val) {
        this.timings.add(new Long(val));
    }

    public String getUnits() {
        if (this.units != null) {
            return new String(this.units);
        }
        return null;
    }

    protected void setUnits(String units) {
        if (units.equals("minute") || units.equals("day") || units.equals("hour")) {
            this.units = new String(units);
        }
    }

    public int getRunOnLoad() {
        return this.runOnLoad;
    }

    protected void setRunOnLoad(int val) {
        if (val > 0) {
            this.runOnLoad = val;
        }
    }

    public int getRepeatTime() {
        return this.repeatTime;
    }

    protected void setRepeatTime(int val) {
        if (val > 0) {
            this.repeatTime = val;
        }
    }

    public String getDescription() {
        if (this.description != null) {
            return new String(this.description);
        }
        return null;
    }

    protected void setDescription(String desc) {
        this.description = new String(desc);
    }

    public String getDateFormat() {
        if (this.dateFormat != null) {
            return new String(this.dateFormat);
        }
        return null;
    }

    protected void setDateFormat(String df) {
        this.dateFormat = new String(df);
    }

    public String getID() {
        if (this.id != null) {
            return new String(this.id);
        }
        return null;
    }

    protected void setID(String id) {
        this.id = new String(id);
    }

    public String getTaskClass() {
        if (this.taskClass != null) {
            return new String(this.taskClass);
        }
        return null;
    }

    protected void setTaskClass(String c) {
        this.taskClass = new String(c);
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    protected void setExecutionCount(int val) {
        this.executionCount = val;
    }

    public int getExecutionLimit() {
        return this.executionLimit;
    }

    protected void setExecutionLimit(int val) {
        if (val > 1) {
            this.executionLimit = val;
        }
    }

    public Date getStartTime() {
        if (this.startTime != null) {
            return new Date(this.startTime.getTime());
        }
        return null;
    }

    protected void setStartTime(Date date) {
        this.startTime = date;
    }

    public boolean isRunAsDaemon() {
        return this.runAsDaemon;
    }

    protected void setRunAsDaemon(boolean val) {
        this.runAsDaemon = val;
    }

    public boolean isOwnTimer() {
        return this.ownTimer;
    }

    protected void setOwnTimer(boolean val) {
        this.ownTimer = val;
    }

    public String getTimeFormat() {
        if (this.timeFormat != null) {
            return new String(this.timeFormat);
        }
        return null;
    }

    protected void setTimeFormat(String tf) {
        this.timeFormat = new String(tf);
    }

    public long getRepeatTimeInMillis() {
        long mult = 0L;
        if (this.units.equals("minute")) {
            mult = 60000L;
        }
        if (this.units.equals("hour")) {
            mult = 3600000L;
        }
        if (this.units.equals("day")) {
            mult = 86400000L;
        }
        return (long)this.repeatTime * mult;
    }

    public long getAverageExecutionTime() {
        if (this.timings.size() > 0) {
            return this.getTotalExecutionTime() / (long)this.timings.size();
        }
        return 0L;
    }

    public long getTotalExecutionTime() {
        long total = 0L;
        for (int i = 0; i < this.timings.size(); ++i) {
            total += ((Long)this.timings.get(i)).longValue();
        }
        return total;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Repeat Task Info\n");
        buf.append("             Task: ");
        buf.append(this.id);
        buf.append("\n");
        buf.append("        Classname: ");
        buf.append(this.taskClass);
        buf.append("\n");
        buf.append("      Description: ");
        buf.append(this.description);
        buf.append("\n");
        if (this.repeatTime > 0) {
            buf.append("      Repeat Time: ");
            buf.append(this.repeatTime);
            buf.append("\n");
            buf.append("            Units: ");
            buf.append(this.units);
            buf.append("\n");
            buf.append("       Start Time: ");
            buf.append(new SimpleDateFormat(this.dateFormat + ", " + this.timeFormat).format(this.startTime));
            buf.append("\n");
        } else {
            buf.append("      Repeat Time: 0 (will only execute once)\n");
        }
        if (this.runOnLoad != -1) {
            buf.append("  Run At Start-up: YES\n");
            buf.append("         Priority: ");
            buf.append(this.runOnLoad);
            buf.append("\n");
        } else {
            buf.append("  Run At Start-up: NO\n");
        }
        buf.append(" Run in Own Timer: ");
        if (this.ownTimer) {
            buf.append("YES\n");
        } else {
            buf.append("NO\n");
        }
        buf.append("    Run as Daemon: ");
        if (this.runAsDaemon) {
            buf.append("YES\n");
        } else {
            buf.append("NO\n");
        }
        buf.append("  Execution limit: ");
        buf.append(this.executionLimit);
        return buf.toString();
    }
}

