/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.StringTokenizer;
import java.util.Vector;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class CSVParser {
    private String m_values;
    private boolean range_allowed = true;
    private static final ILogger log = LoggerFactory.getLogger(CSVParser.class);
    private static final char RANGE_SEPARATOR = '-';

    public CSVParser(String values) {
        this(values, true);
    }

    public CSVParser(String values, boolean range) {
        this.m_values = values;
        this.range_allowed = range;
    }

    public int[] parseInt() throws NumberFormatException {
        int[] ivalues = null;
        Vector<Integer> values = new Vector<Integer>();
        StringTokenizer tokens = new StringTokenizer(this.m_values, ",");
        while (tokens.hasMoreTokens()) {
            String tk = tokens.nextToken().trim();
            int rpos = tk.indexOf(45);
            if (rpos <= 0) {
                try {
                    values.add(new Integer(Integer.parseInt(tk)));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String error = "Error parsing '" + this.m_values + "' : '" + tk + "' is not a valid integer value";
                    throw new NumberFormatException(error);
                }
            }
            if (this.range_allowed) {
                String tkl = tk.substring(0, rpos);
                String tkr = tk.substring(rpos + 1);
                try {
                    int iv = Integer.parseInt(tkl);
                    int fv = Integer.parseInt(tkr);
                    if (iv > fv) {
                        int ii = fv;
                        fv = iv;
                        iv = ii;
                    }
                    int i = iv;
                    while (i <= fv) {
                        values.add(new Integer(i));
                        ++i;
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String error = "Error parsing '" + this.m_values + "' : '" + tk + "' contains not valid integer values";
                    throw new NumberFormatException(error);
                }
            }
            String error = "Error parsing '" + this.m_values + "' : range not allowed";
            throw new NumberFormatException(error);
        }
        ivalues = new int[values.size()];
        int v = 0;
        while (v < values.size()) {
            ivalues[v] = (Integer)values.elementAt(v);
            ++v;
        }
        return ivalues;
    }

    public double[] parseDouble() throws NumberFormatException {
        double[] dvalues = null;
        Vector<Double> values = new Vector<Double>();
        StringTokenizer tokens = new StringTokenizer(this.m_values, ",");
        while (tokens.hasMoreTokens()) {
            String tk = tokens.nextToken().trim();
            int rpos = tk.indexOf(45);
            if (rpos <= 0) {
                try {
                    values.add(new Double(Double.parseDouble(tk)));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String error = "Error parsing '" + this.m_values + "' : '" + tk + "' is not a valid numeric value";
                    throw new NumberFormatException(error);
                }
            }
            String error = "Error parsing '" + this.m_values + "' : range not allowed for not integer values";
            throw new NumberFormatException(error);
        }
        dvalues = new double[values.size()];
        int v = 0;
        while (v < values.size()) {
            dvalues[v] = (Double)values.elementAt(v);
            ++v;
        }
        return dvalues;
    }

    public static void main(String[] args) {
        CSVParser parser = new CSVParser("1.0,-3.6,1.4,15");
        double[] dd = parser.parseDouble();
        log.debug("Double values:");
        if (dd != null) {
            int i = 0;
            while (i < dd.length) {
                log.debug("array[" + i + "] = " + dd[i]);
                ++i;
            }
        }
        parser = new CSVParser("1,-3,4-8,11");
        int[] ii = parser.parseInt();
        log.debug("Integer values:");
        if (ii != null) {
            int i = 0;
            while (i < ii.length) {
                log.debug("array[" + i + "] = " + ii[i]);
                ++i;
            }
        }
    }
}

