/*
 * Decompiled with CFR 0.152.
 */
package org.joone.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.NeuralElement;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.engine.listeners.ConvergenceEvent;
import org.joone.engine.listeners.ConvergenceListener;
import org.joone.engine.listeners.ConvergenceObserver;
import org.joone.exception.JooneRuntimeException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;
import org.joone.structure.PatternForwardedSynapse;

public class Nakayama
implements NeuralNetListener,
NeuralValidationListener,
ConvergenceListener,
Serializable {
    private static final ILogger log = LoggerFactory.getLogger(Nakayama.class);
    private static final int NO_REMOVE = 0;
    private static final int INFO_REMOVE = 1;
    private static final int VARIANCE_REMOVE = 2;
    private static final int CORRELATION_POSSIBLE_REMOVE = 3;
    private static final int CORRELATION_REMOVE = 4;
    private static final int REMOVE_DONE = -1;
    private List layers = new ArrayList();
    private boolean isRunning;
    private NeuralNet net;
    private NeuralNet clone;
    private double epsilon = 0.05;
    private List listeners = new ArrayList();
    private List outputsAfterPattern;
    private List information;
    private double infoMax;
    private List averageOutputs;
    private List variance;
    private double varianceMax;
    private List gamma;
    private boolean optimized = false;

    public Nakayama(NeuralNet aNet) {
        this.net = aNet;
    }

    public void addLayer(Layer aLayer) {
        this.layers.add(aLayer);
    }

    public void addLayers(NeuralNet aNeuralNet) {
        int i = 0;
        while (i < aNeuralNet.getLayers().size()) {
            Object myLayer = aNeuralNet.getLayers().get(i);
            if (myLayer != aNeuralNet.getInputLayer() && myLayer != aNeuralNet.getOutputLayer()) {
                this.layers.add(myLayer);
            }
            ++i;
        }
    }

    public boolean optimize() {
        this.outputsAfterPattern = new ArrayList();
        this.information = new ArrayList();
        this.infoMax = 0.0;
        this.averageOutputs = new ArrayList();
        this.variance = new ArrayList();
        this.varianceMax = 0.0;
        this.gamma = new ArrayList();
        this.optimized = false;
        log.debug("Optimization request [cycle : " + this.net.getMonitor().getCurrentCicle() + "]");
        this.isRunning = this.net.isRunning();
        if (this.isRunning) {
            log.debug("Stopping network...");
            this.removeAllListeners();
            this.net.addNeuralNetListener(this);
            this.net.getMonitor().Stop();
        } else {
            this.runValidation();
        }
        return this.optimized;
    }

    protected void runValidation() {
        this.net.getMonitor().setExporting(true);
        this.clone = this.net.cloneNet();
        this.net.getMonitor().setExporting(false);
        this.clone.removeAllListeners();
        this.clone.getOutputLayer().addOutputSynapse(new PatternForwardedSynapse(this));
        log.debug("Validating network...");
        NeuralNetValidator myValidator = new NeuralNetValidator(this.clone);
        myValidator.addValidationListener(this);
        myValidator.useTrainingData(true);
        myValidator.start();
    }

    protected void doOptimize() {
        log.debug("Optimizing...");
        this.evaluateNeurons();
        this.selectNeurons();
        log.debug("Optimization done.");
        this.cleanUp();
        int i = 0;
        while (i < this.net.getLayers().size()) {
            Layer myLayer = (Layer)this.net.getLayers().get(i);
            log.debug("Layer [" + myLayer.getClass().getName() + "] - neurons : " + myLayer.getRows());
            ++i;
        }
    }

    protected void cleanUp() {
        log.debug("Cleaning up...");
        this.outputsAfterPattern = null;
        this.information = null;
        this.averageOutputs = null;
        this.variance = null;
        this.gamma = null;
        this.clone = null;
        int i = 0;
        while (i < this.layers.size()) {
            Layer myLayer = (Layer)this.layers.get(i);
            if (myLayer.getRows() == 0) {
                log.debug("Remove layer [" + myLayer.getClass().getName() + "]");
                this.net.removeLayer(myLayer);
                this.layers.remove(i);
                --i;
            }
            ++i;
        }
        this.net.removeNeuralNetListener(this);
        this.restoreAllListeners();
        log.debug("Clean ;)");
        if (this.isRunning) {
            log.debug("Restarting net...");
            this.net.start();
            this.net.getMonitor().runAgain();
        }
    }

    protected void selectNeurons() {
        double[] myMinCorrelation;
        int[] myStatus;
        log.debug("Selecting neurons...");
        ArrayList<int[]> myStatuses = new ArrayList<int[]>();
        ArrayList<double[]> myMinCorrelationPointers = new ArrayList<double[]>();
        int i = 0;
        while (i < this.layers.size()) {
            Layer myLayer = (Layer)this.layers.get(i);
            myStatus = new int[myLayer.getRows()];
            int n = 0;
            while (n < myLayer.getRows()) {
                double myScaledVariance;
                double myScaledInfo = ((double[])this.information.get(i))[n] / this.infoMax;
                if (myScaledInfo * (myScaledVariance = ((double[])this.variance.get(i))[n] / this.varianceMax) * (myMinCorrelation = this.getMinCorrelation(i, n))[0] <= this.epsilon) {
                    if (myScaledInfo <= myScaledVariance && myScaledInfo <= myMinCorrelation[0]) {
                        myStatus[n] = 1;
                    } else if (myScaledVariance < myScaledInfo && myScaledVariance <= myMinCorrelation[0]) {
                        myStatus[n] = 2;
                    } else {
                        myStatus[n] = 3;
                        myMinCorrelationPointers.add(myMinCorrelation);
                    }
                }
                ++n;
            }
            myStatuses.add(myStatus);
            ++i;
        }
        ArrayList<int[]> myCorrelations = new ArrayList<int[]>();
        int i2 = 0;
        while (i2 < myMinCorrelationPointers.size()) {
            int mySingleStatus;
            myMinCorrelation = (double[])myMinCorrelationPointers.get(i2);
            if (myMinCorrelation[5] < 0.0 && ((int[])myStatuses.get((int)myMinCorrelation[1]))[(int)myMinCorrelation[2]] == 3) {
                mySingleStatus = ((int[])myStatuses.get((int)myMinCorrelation[3]))[(int)myMinCorrelation[4]];
                if (mySingleStatus == 1 || mySingleStatus == 2 || mySingleStatus == 4) {
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[1])))[(int)myMinCorrelation[2]] = 0;
                } else if (((double[])this.variance.get((int)myMinCorrelation[1]))[(int)myMinCorrelation[2]] <= ((double[])this.variance.get((int)myMinCorrelation[3]))[(int)myMinCorrelation[4]]) {
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[1])))[(int)myMinCorrelation[2]] = 4;
                    myCorrelations.add(new int[]{(int)myMinCorrelation[1], (int)myMinCorrelation[2], (int)myMinCorrelation[3], (int)myMinCorrelation[4]});
                } else {
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[1])))[(int)myMinCorrelation[2]] = 0;
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[3])))[(int)myMinCorrelation[4]] = 4;
                    myCorrelations.add(new int[]{(int)myMinCorrelation[3], (int)myMinCorrelation[4], (int)myMinCorrelation[1], (int)myMinCorrelation[2]});
                }
            } else if (myMinCorrelation[5] > 0.0 && ((int[])myStatuses.get((int)myMinCorrelation[3]))[(int)myMinCorrelation[4]] == 3) {
                mySingleStatus = ((int[])myStatuses.get((int)myMinCorrelation[1]))[(int)myMinCorrelation[2]];
                if (mySingleStatus == 1 || mySingleStatus == 2 || mySingleStatus == 4) {
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[3])))[(int)myMinCorrelation[4]] = 0;
                } else if (((double[])this.variance.get((int)myMinCorrelation[1]))[(int)myMinCorrelation[2]] >= ((double[])this.variance.get((int)myMinCorrelation[3]))[(int)myMinCorrelation[4]]) {
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[3])))[(int)myMinCorrelation[4]] = 4;
                    myCorrelations.add(new int[]{(int)myMinCorrelation[3], (int)myMinCorrelation[4], (int)myMinCorrelation[1], (int)myMinCorrelation[2]});
                } else {
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[3])))[(int)myMinCorrelation[4]] = 0;
                    ((int[])myStatuses.get((int)((int)myMinCorrelation[1])))[(int)myMinCorrelation[2]] = 4;
                    myCorrelations.add(new int[]{(int)myMinCorrelation[1], (int)myMinCorrelation[2], (int)myMinCorrelation[3], (int)myMinCorrelation[4]});
                }
            }
            ++i2;
        }
        int l = 0;
        while (l < myStatuses.size()) {
            myStatus = (int[])myStatuses.get(l);
            int myNeuron = 0;
            int n = 0;
            while (n < myStatus.length) {
                if (myStatus[n] == 1) {
                    log.debug("Remove[info]: " + l + " " + n);
                    this.removeNeuron(l, myNeuron);
                    this.optimized = true;
                    myStatus[n] = -1;
                } else if (myStatus[n] == 2) {
                    log.debug("Remove[variance]: " + l + " " + n);
                    this.weightsUpdateVariance(l, n, myNeuron);
                    this.removeNeuron(l, myNeuron);
                    this.optimized = true;
                    myStatus[n] = -1;
                } else if (myStatus[n] == 4) {
                    log.debug("Remove[correlation]: " + l + " " + n);
                    this.weightsUpdateCorrelation(myStatuses, myCorrelations, l, n);
                    this.removeNeuron(l, myNeuron);
                    this.optimized = true;
                    myStatus[n] = -1;
                } else if (myStatus[n] == 0) {
                    ++myNeuron;
                }
                ++n;
            }
            ++l;
        }
        log.debug("Selection done.");
    }

    protected void weightsUpdateCorrelation(List aStatuses, List aCorrelations, int aLayer, int aNeuron) {
        int[] myCorrelatedNeuron = null;
        int[] myTemp = this.findCorrelation(aCorrelations, aLayer, aNeuron);
        while (myTemp != null) {
            myCorrelatedNeuron = myTemp;
            myTemp = this.findCorrelation(aCorrelations, myCorrelatedNeuron[0], myCorrelatedNeuron[1]);
        }
        int myAdjustedNeuron = this.findIndex(aStatuses, aLayer, aNeuron);
        int myAdjustedCorrelatedNeuron = this.findIndex(aStatuses, myCorrelatedNeuron[0], myCorrelatedNeuron[1]);
        double myAlpha = (double)(this.getGamma(aLayer, aNeuron, myCorrelatedNeuron[0], myCorrelatedNeuron[1]) >= 0.0 ? 1 : -1) * Math.sqrt(((double[])this.variance.get(aLayer))[aNeuron] / ((double[])this.variance.get(aLayer))[myCorrelatedNeuron[1]]);
        Synapse mySynapseCorrelation = null;
        Layer myLayer = (Layer)this.layers.get(aLayer);
        Layer myLayerCorrelation = (Layer)this.layers.get(myCorrelatedNeuron[0]);
        if (myLayer.getAllOutputs().size() != myLayerCorrelation.getAllInputs().size()) {
            throw new JooneRuntimeException("Unable to optimize. #output layers for neuron and correlated neuron are not equal.");
        }
        int i = 0;
        while (i < myLayer.getAllOutputs().size()) {
            NeuralElement myElement = (NeuralElement)myLayer.getAllOutputs().get(i);
            if (!(myElement instanceof Synapse)) {
                throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
            }
            Synapse mySynapse = (Synapse)myElement;
            Layer myOutputLayer = this.findOutputLayer(mySynapse);
            int j = 0;
            while (j < myLayerCorrelation.getAllOutputs().size() && mySynapseCorrelation == null) {
                NeuralElement myElementCorrelation = (NeuralElement)myLayerCorrelation.getAllOutputs().get(j);
                if (myElementCorrelation instanceof Synapse && this.findOutputLayer(mySynapseCorrelation = (Synapse)myElementCorrelation) != myOutputLayer) {
                    mySynapseCorrelation = null;
                }
                ++j;
            }
            if (mySynapseCorrelation == null) {
                throw new JooneRuntimeException("Unable to optimize. Unable to find same output layer for correlated layer.");
            }
            Matrix myBiases = myOutputLayer.getBias();
            Matrix myWeights = mySynapse.getWeights();
            Matrix myWeightsCorrelation = mySynapseCorrelation.getWeights();
            int r = 0;
            while (r < myOutputLayer.getRows()) {
                double[] dArray = myBiases.value[r];
                dArray[0] = dArray[0] + myWeights.value[myAdjustedNeuron][r] * (((double[])this.averageOutputs.get(aLayer))[aNeuron] - myAlpha * ((double[])this.averageOutputs.get(myCorrelatedNeuron[0]))[myCorrelatedNeuron[1]]);
                myBiases.delta[r][0] = 0.0;
                double[] dArray2 = myWeightsCorrelation.value[myAdjustedCorrelatedNeuron];
                int n = r;
                dArray2[n] = dArray2[n] + myWeights.value[myAdjustedNeuron][r];
                myWeightsCorrelation.delta[myAdjustedCorrelatedNeuron][r] = 0.0;
                ++r;
            }
            ++i;
        }
    }

    protected double getGamma(int aLayer1, int aNeuron1, int aLayer2, int aNeuron2) {
        if (aLayer1 > aLayer2 || aLayer1 == aLayer2 && aNeuron1 > aNeuron2) {
            int mySwapLayer = aLayer1;
            int mySwapNeuron = aNeuron1;
            aLayer1 = aLayer2;
            aNeuron1 = aNeuron2;
            aLayer2 = mySwapLayer;
            aNeuron2 = mySwapNeuron;
        }
        return ((double[])((List[])this.gamma.get(aLayer1))[aNeuron1].get(aLayer2))[aNeuron2];
    }

    protected int findIndex(List aStatuses, int aLayer, int aNeuron) {
        int[] myStatusLayer = (int[])aStatuses.get(aLayer);
        int myNewIndex = aNeuron;
        int i = 0;
        while (i < aNeuron) {
            if (myStatusLayer[i] == -1) {
                --myNewIndex;
            }
            ++i;
        }
        return myNewIndex;
    }

    protected int[] findCorrelation(List aCorrelations, int aLayer, int aNeuron) {
        int i = 0;
        while (i < aCorrelations.size()) {
            int[] myCorrelation = (int[])aCorrelations.get(i);
            if (myCorrelation[0] == aLayer && myCorrelation[1] == aNeuron) {
                return new int[]{myCorrelation[2], myCorrelation[3]};
            }
            ++i;
        }
        return null;
    }

    protected void weightsUpdateVariance(int aLayer, int aNeuronOriginal, int aNeuron) {
        Layer myLayer = (Layer)this.layers.get(aLayer);
        int i = 0;
        while (i < myLayer.getAllOutputs().size()) {
            NeuralElement myElement = (NeuralElement)myLayer.getAllOutputs().get(i);
            if (!(myElement instanceof Synapse)) {
                throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
            }
            Synapse mySynapse = (Synapse)myElement;
            Layer myOutputLayer = this.findOutputLayer(mySynapse);
            Matrix myBiases = myOutputLayer.getBias();
            Matrix myWeights = mySynapse.getWeights();
            double myAverageOutput = ((double[])this.averageOutputs.get(aLayer))[aNeuronOriginal];
            int r = 0;
            while (r < myOutputLayer.getRows()) {
                double[] dArray = myBiases.value[r];
                dArray[0] = dArray[0] + myWeights.value[aNeuron][r] * myAverageOutput;
                myBiases.delta[r][0] = 0.0;
                ++r;
            }
            ++i;
        }
    }

    protected void removeNeuron(int aLayer, int aNeuron) {
        Layer myLayer = (Layer)this.layers.get(aLayer);
        if (myLayer.getRows() > 1) {
            Matrix myWeights;
            Synapse mySynapse;
            NeuralElement myElement;
            int i = 0;
            while (i < myLayer.getAllInputs().size()) {
                myElement = (NeuralElement)myLayer.getAllInputs().get(i);
                if (!(myElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Input of layer is not a synapse.");
                }
                mySynapse = (Synapse)myElement;
                myWeights = mySynapse.getWeights();
                myWeights.removeColumn(aNeuron);
                mySynapse.setOutputDimension(mySynapse.getOutputDimension() - 1);
                mySynapse.setWeights(myWeights);
                ++i;
            }
            i = 0;
            while (i < myLayer.getAllOutputs().size()) {
                myElement = (NeuralElement)myLayer.getAllOutputs().get(i);
                if (!(myElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
                }
                mySynapse = (Synapse)myElement;
                myWeights = mySynapse.getWeights();
                myWeights.removeRow(aNeuron);
                mySynapse.setInputDimension(mySynapse.getInputDimension() - 1);
                mySynapse.setWeights(myWeights);
                ++i;
            }
            myWeights = myLayer.getBias();
            myWeights.removeRow(aNeuron);
            myLayer.setRows(myLayer.getRows() - 1);
            myLayer.setBias(myWeights);
        } else {
            Synapse mySynapse;
            NeuralElement myElement;
            int i = 0;
            while (i < myLayer.getAllInputs().size()) {
                myElement = (NeuralElement)myLayer.getAllInputs().get(i);
                if (!(myElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Input of layer is not a synapse.");
                }
                mySynapse = (Synapse)myElement;
                Layer myInputLayer = this.findInputLayer(mySynapse);
                myInputLayer.removeOutputSynapse(mySynapse);
                ++i;
            }
            i = 0;
            while (i < myLayer.getAllOutputs().size()) {
                myElement = (NeuralElement)myLayer.getAllOutputs().get(i);
                if (!(myElement instanceof Synapse)) {
                    throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
                }
                mySynapse = (Synapse)myElement;
                Layer myOutputLayer = this.findOutputLayer(mySynapse);
                myOutputLayer.removeInputSynapse(mySynapse);
                ++i;
            }
            Matrix myWeights = myLayer.getBias();
            myWeights.removeRow(aNeuron);
            myLayer.setRows(myLayer.getRows() - 1);
            myLayer.setBias(myWeights);
        }
    }

    protected Layer findInputLayer(Synapse aSynapse) {
        int i = 0;
        while (i < this.net.getLayers().size()) {
            Layer myLayer = (Layer)this.net.getLayers().get(i);
            if (myLayer.getAllOutputs().contains(aSynapse)) {
                return myLayer;
            }
            ++i;
        }
        return null;
    }

    protected Layer findOutputLayer(Synapse aSynapse) {
        int i = 0;
        while (i < this.net.getLayers().size()) {
            Layer myLayer = (Layer)this.net.getLayers().get(i);
            if (myLayer.getAllInputs().contains(aSynapse)) {
                return myLayer;
            }
            ++i;
        }
        return null;
    }

    protected void evaluateNeurons() {
        Layer myLayer;
        log.debug("Evaluation of neurons...");
        int myNrOfPatterns = this.net.getMonitor().getTrainingPatterns();
        int i = 0;
        while (i < this.layers.size()) {
            myLayer = (Layer)this.layers.get(i);
            double[] myInfo = new double[myLayer.getRows()];
            double[] myAvgOutputs = new double[myLayer.getRows()];
            int n = 0;
            while (n < myLayer.getRows()) {
                double myTempSumWeights = this.getSumAbsoluteWeights(myLayer, n);
                double[] myTempSumOutputs = this.getSumOutputs(i, n);
                myInfo[n] = myTempSumWeights * myTempSumOutputs[1] / (double)myNrOfPatterns;
                if (myInfo[n] > this.infoMax) {
                    this.infoMax = myInfo[n];
                }
                myAvgOutputs[n] = myTempSumOutputs[0] / (double)myNrOfPatterns;
                ++n;
            }
            this.information.add(myInfo);
            this.averageOutputs.add(myAvgOutputs);
            ++i;
        }
        ArrayList myDifferences = new ArrayList();
        int i2 = 0;
        while (i2 < this.layers.size()) {
            myLayer = (Layer)this.layers.get(i2);
            double[] myVariance = new double[myLayer.getRows()];
            ArrayList<double[]> myDifferencesForLayer = new ArrayList<double[]>();
            int p = 0;
            while (p < this.outputsAfterPattern.size()) {
                double[] myTempDifferences = new double[myLayer.getRows()];
                int n = 0;
                while (n < myLayer.getRows()) {
                    List myOutputs = (List)this.outputsAfterPattern.get(p);
                    myTempDifferences[n] = ((double[])myOutputs.get(i2))[n] - ((double[])this.averageOutputs.get(i2))[n];
                    int n2 = n;
                    myVariance[n2] = myVariance[n2] + myTempDifferences[n] * myTempDifferences[n];
                    ++n;
                }
                myDifferencesForLayer.add(myTempDifferences);
                ++p;
            }
            int n = 0;
            while (n < myLayer.getRows()) {
                if (myVariance[n] > this.varianceMax) {
                    this.varianceMax = myVariance[n];
                }
                ++n;
            }
            myDifferences.add(myDifferencesForLayer);
            this.variance.add(myVariance);
            ++i2;
        }
        int l1 = 0;
        while (l1 < this.layers.size()) {
            Layer myLayer1 = (Layer)this.layers.get(l1);
            List[] myNeurons1Pointer = new List[myLayer1.getRows()];
            this.gamma.add(myNeurons1Pointer);
            int n1 = 0;
            while (n1 < myLayer1.getRows()) {
                myNeurons1Pointer[n1] = new ArrayList();
                int l2 = 0;
                while (l2 < this.layers.size()) {
                    Layer myLayer2 = (Layer)this.layers.get(l2);
                    if (l2 < l1) {
                        myNeurons1Pointer[n1].add(new double[0]);
                    } else {
                        double[] myNeurons2Pointer = new double[myLayer2.getRows()];
                        myNeurons1Pointer[n1].add(myNeurons2Pointer);
                        int n2 = l1 == l2 ? n1 + 1 : 0;
                        while (n2 < myLayer2.getRows()) {
                            double myA = 0.0;
                            double myB = 0.0;
                            int p = 0;
                            while (p < myNrOfPatterns) {
                                List myTempDifferencesForLayer1 = (List)myDifferences.get(l1);
                                List myTempDifferencesForLayer2 = (List)myDifferences.get(l2);
                                myA += ((double[])myTempDifferencesForLayer1.get(p))[n1] * ((double[])myTempDifferencesForLayer2.get(p))[n2];
                                ++p;
                            }
                            myB = ((double[])this.variance.get(l1))[n1] * ((double[])this.variance.get(l2))[n2];
                            myNeurons2Pointer[n2] = myA / Math.sqrt(myB);
                            ++n2;
                        }
                    }
                    ++l2;
                }
                ++n1;
            }
            ++l1;
        }
        log.debug("Evaluation done.");
    }

    protected double[] getMinCorrelation(int aLayer, int aNeuron) {
        double myCorrelation;
        double[] myReturnValue = new double[]{2.0, -1.0, -1.0, -1.0, -1.0, 0.0};
        int l = 0;
        while (l <= aLayer) {
            List[] myNeurons = (List[])this.gamma.get(l);
            int n = 0;
            while (n < (l == aLayer ? aNeuron : myNeurons.length)) {
                myCorrelation = 1.0 - Math.abs(((double[])myNeurons[n].get(aLayer))[aNeuron]);
                if (myReturnValue[0] > myCorrelation) {
                    myReturnValue[0] = myCorrelation;
                    myReturnValue[1] = l;
                    myReturnValue[2] = n;
                    myReturnValue[3] = aLayer;
                    myReturnValue[4] = aNeuron;
                    myReturnValue[5] = 1.0;
                }
                ++n;
            }
            ++l;
        }
        List myLayers = ((List[])this.gamma.get(aLayer))[aNeuron];
        int l2 = aLayer;
        while (l2 < myLayers.size()) {
            double[] myNeurons2 = (double[])myLayers.get(l2);
            int n = l2 == aLayer ? aNeuron + 1 : 0;
            while (n < myNeurons2.length) {
                myCorrelation = 1.0 - Math.abs(myNeurons2[n]);
                if (myReturnValue[0] > myCorrelation) {
                    myReturnValue[0] = myCorrelation;
                    myReturnValue[1] = aLayer;
                    myReturnValue[2] = aNeuron;
                    myReturnValue[3] = l2;
                    myReturnValue[4] = n;
                    myReturnValue[5] = -1.0;
                }
                ++n;
            }
            ++l2;
        }
        return myReturnValue;
    }

    protected double[] getSumOutputs(int aLayer, int aNeuron) {
        double[] mySum = new double[2];
        int i = 0;
        while (i < this.outputsAfterPattern.size()) {
            List myOutputs = (List)this.outputsAfterPattern.get(i);
            double myOutput = ((double[])myOutputs.get(aLayer))[aNeuron];
            mySum[0] = mySum[0] + myOutput;
            mySum[1] = mySum[1] + Math.abs(myOutput);
            ++i;
        }
        return mySum;
    }

    protected double getSumAbsoluteWeights(Layer aLayer, int aNeuron) {
        double mySum = 0.0;
        int i = 0;
        while (i < aLayer.getAllOutputs().size()) {
            OutputPatternListener myListener = (OutputPatternListener)aLayer.getAllOutputs().get(i);
            if (!(myListener instanceof Synapse)) {
                throw new JooneRuntimeException("Unable to optimize. Output of layer is not a synapse.");
            }
            Synapse mySynapse = (Synapse)myListener;
            int j = 0;
            while (j < mySynapse.getOutputDimension()) {
                mySum += Math.abs(mySynapse.getWeights().value[aNeuron][j]);
                ++j;
            }
            ++i;
        }
        return mySum;
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
    }

    public void netStopped(NeuralNetEvent e) {
        log.debug("Network stopped.");
        this.runValidation();
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    public void netValidated(NeuralValidationEvent event) {
        log.debug("Network validated.");
        this.doOptimize();
    }

    protected void removeAllListeners() {
        Vector myListeners = this.net.getListeners();
        while (myListeners.size() > 0) {
            NeuralNetListener myListener = (NeuralNetListener)myListeners.get(myListeners.size() - 1);
            this.listeners.add(myListener);
            this.net.removeNeuralNetListener(myListener);
        }
    }

    protected void restoreAllListeners() {
        for (NeuralNetListener myListener : this.listeners) {
            this.net.addNeuralNetListener(myListener);
        }
        this.listeners = new Vector();
    }

    void patternFinished() {
        ArrayList<double[]> myOutputs = new ArrayList<double[]>();
        int i = 0;
        while (i < this.layers.size()) {
            Layer myLayer = this.findClonedLayer((Layer)this.layers.get(i));
            myOutputs.add(myLayer.getLastOutputs());
            ++i;
        }
        this.outputsAfterPattern.add(myOutputs);
    }

    private Layer findClonedLayer(Layer aLayer) {
        int i = 0;
        while (i < this.net.getLayers().size()) {
            if (this.net.getLayers().get(i) == aLayer) {
                return (Layer)this.clone.getLayers().get(i);
            }
            ++i;
        }
        return null;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double anEpsilon) {
        this.epsilon = anEpsilon;
    }

    public void netConverged(ConvergenceEvent anEvent, ConvergenceObserver anObserver) {
        if (!this.optimize()) {
            anObserver.disableCurrentConvergence();
        }
    }
}

