/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class URLInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(URLInputSynapse.class);
    private String URL = "http://";
    private URL cURL;
    private static final long serialVersionUID = -1871585397469526608L;

    public String getURL() {
        return this.URL;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObjectBase(in);
        if (in.getClass().getName().indexOf("xstream") == -1) {
            this.URL = (String)in.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.setURL(this.URL);
        }
    }

    public void setURL(String newURL) {
        if (!this.URL.equals(newURL)) {
            this.resetInput();
            this.setTokens(null);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.writeObjectBase(out);
        if (out.getClass().getName().indexOf("xstream") == -1) {
            out.writeObject(this.URL);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        block3: {
            if (this.URL != null && this.URL != "") {
                try {
                    this.cURL = new URL(this.URL);
                    InputStream is = this.cURL.openStream();
                    StreamInputTokenizer sit = this.getMaxBufSize() > 0 ? new StreamInputTokenizer(new InputStreamReader(is), this.getMaxBufSize()) : new StreamInputTokenizer(new InputStreamReader(is));
                    super.setTokens(sit);
                }
                catch (IOException ioe) {
                    log.warn("Could not extract data from the URL '" + this.URL + "' Message is : " + ioe.getMessage());
                    if (this.getMonitor() == null) break block3;
                    new NetErrorManager(this.getMonitor(), "Could not extract data from the URL '" + this.URL + "' Message is : " + ioe.getMessage());
                }
            }
        }
    }
}

