/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Fifo;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.OutputConverterPlugIn;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public abstract class StreamOutputSynapse
extends Synapse
implements PlugInListener {
    private static final ILogger log = LoggerFactory.getLogger(StreamOutputSynapse.class);
    private char separator = (char)59;
    private static final long serialVersionUID = 7344684413113722785L;
    protected transient Fifo fifo;
    private boolean buffered = true;
    private transient Vector buffered_patterns;
    protected OutputConverterPlugIn nextPlugIn = null;

    protected void backward(double[] pattern) {
    }

    protected void forward(double[] pattern) {
        this.outs = pattern;
    }

    public synchronized void fwdPut(Pattern pattern) {
        block11: {
            if (this.isEnabled()) {
                try {
                    if (this.isBuffered()) {
                        if (pattern.getCount() > -1) {
                            this.m_pattern = pattern;
                            this.inps = pattern.getArray();
                            this.forward(this.inps);
                            this.m_pattern.setArray(this.outs);
                            this.getFifo().push(this.m_pattern.clone());
                            this.items = this.fifo.size();
                        } else {
                            this.getFifo().push(pattern.clone());
                            this.items = this.fifo.size();
                            int num_patterns = this.fifo.size();
                            this.buffered_patterns = new Vector();
                            int i = 0;
                            while (i < num_patterns) {
                                this.buffered_patterns.addElement(((Pattern)this.fifo.pop()).clone());
                                ++i;
                            }
                            if (this.nextPlugIn != null) {
                                this.nextPlugIn.setInputVector(this.buffered_patterns);
                                this.nextPlugIn.convertPatterns();
                            }
                            this.write(this.buffered_patterns);
                        }
                    } else {
                        if (pattern.getCount() > -1) {
                            this.inps = pattern.getArray();
                            this.forward(this.inps);
                            this.items = 1;
                            if (this.nextPlugIn != null) {
                                this.nextPlugIn.setPattern(pattern);
                                this.nextPlugIn.convertPattern();
                            }
                        }
                        this.write(pattern);
                    }
                }
                catch (NumberFormatException nfe) {
                    String error = "NumberFormatException in " + this.getName() + ". Message is : ";
                    log.warn(String.valueOf(error) + nfe.getMessage());
                    if (this.getMonitor() == null) break block11;
                    new NetErrorManager(this.getMonitor(), String.valueOf(error) + nfe.getMessage());
                }
            }
        }
        this.notifyAll();
    }

    private void write(Vector patterns) {
        if (patterns != null) {
            int i = 0;
            while (i < patterns.size()) {
                this.write((Pattern)patterns.elementAt(i));
                ++i;
            }
        }
    }

    public abstract void write(Pattern var1);

    public char getSeparator() {
        return this.separator;
    }

    public synchronized Pattern revGet() {
        return null;
    }

    protected void setArrays(int rows, int cols) {
    }

    protected void setDimensions(int rows, int cols) {
    }

    public void setSeparator(char newSeparator) {
        this.separator = newSeparator;
    }

    public void setBuffered(boolean buf) {
        this.buffered = buf;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.nextPlugIn != null) {
            this.nextPlugIn.check(checks);
        }
        return checks;
    }

    protected Fifo getFifo() {
        if (this.fifo == null) {
            this.fifo = new Fifo();
        }
        return this.fifo;
    }

    public OutputConverterPlugIn getPlugIn() {
        return this.nextPlugIn;
    }

    public boolean setPlugIn(OutputConverterPlugIn newPlugIn) {
        if (newPlugIn == this.nextPlugIn) {
            return false;
        }
        if (newPlugIn == null) {
            this.nextPlugIn.setConnected(false);
        } else {
            if (newPlugIn.isConnected()) {
                return false;
            }
            newPlugIn.setConnected(true);
            newPlugIn.addPlugInListener(this);
            this.buffered = true;
        }
        this.nextPlugIn = newPlugIn;
        this.getFifo().removeAllElements();
        return true;
    }

    public boolean addPlugIn(OutputConverterPlugIn aNewPlugIn) {
        if (this.nextPlugIn == aNewPlugIn) {
            return false;
        }
        if (aNewPlugIn == null) {
            if (this.nextPlugIn != null) {
                this.nextPlugIn.setConnected(false);
            }
            this.nextPlugIn = null;
            this.getFifo().removeAllElements();
            return true;
        }
        if (aNewPlugIn.isConnected()) {
            return false;
        }
        if (this.nextPlugIn == null) {
            aNewPlugIn.setConnected(true);
            aNewPlugIn.addPlugInListener(this);
            this.setBuffered(true);
            this.nextPlugIn = aNewPlugIn;
            this.getFifo().removeAllElements();
            return true;
        }
        return this.nextPlugIn.addPlugIn(aNewPlugIn);
    }

    public void removeAllPlugIns() {
        if (this.nextPlugIn != null) {
            this.nextPlugIn.setConnected(false);
            this.nextPlugIn.removeAllPlugIns();
            this.nextPlugIn = null;
        }
    }

    public void dataChanged(PlugInEvent data) {
        this.getFifo().removeAllElements();
    }
}

