/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.StringTokenizer;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class StreamInputTokenizer
implements PatternTokenizer {
    private static final ILogger log = LoggerFactory.getLogger(StreamInputTokenizer.class);
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private LineNumberReader stream;
    private StringTokenizer tokenizer = null;
    private int numTokens = 0;
    private char m_decimalPoint = (char)46;
    private String m_delim = "; \t\n\r\f";
    private double[] tokensArray;
    private int maxBufSize;

    public StreamInputTokenizer(Reader in) throws IOException {
        this(in, 0x100000);
    }

    public StreamInputTokenizer(Reader in, int maxBufSize) throws IOException {
        this.maxBufSize = maxBufSize;
        this.stream = new LineNumberReader(in, maxBufSize);
        this.stream.mark(maxBufSize);
    }

    public int getLineno() {
        return this.stream.getLineNumber();
    }

    public int getNumTokens() throws IOException {
        return this.numTokens;
    }

    public double getTokenAt(int posiz) throws IOException {
        if (this.tokensArray == null && !this.nextLine()) {
            return 0.0;
        }
        if (this.tokensArray.length <= posiz) {
            return 0.0;
        }
        return this.tokensArray[posiz];
    }

    public double[] getTokensArray() {
        return this.tokensArray;
    }

    public void mark() throws IOException {
        this.stream.mark(this.maxBufSize);
    }

    public boolean nextLine() throws IOException {
        String line = this.stream.readLine();
        if (line != null) {
            this.tokenizer = new StringTokenizer(line, this.m_delim, false);
            this.numTokens = this.tokenizer.countTokens();
            if (this.tokensArray == null) {
                this.tokensArray = new double[this.numTokens];
            } else if (this.tokensArray.length != this.numTokens) {
                this.tokensArray = new double[this.numTokens];
            }
            int i = 0;
            while (i < this.numTokens) {
                this.tokensArray[i] = this.nextToken(this.m_delim);
                ++i;
            }
            return true;
        }
        return false;
    }

    private double nextToken() throws IOException {
        return this.nextToken(null);
    }

    private double nextToken(String delim) throws IOException {
        double v;
        String nt = null;
        if (this.tokenizer == null) {
            this.nextLine();
        }
        nt = delim != null ? this.tokenizer.nextToken(delim) : this.tokenizer.nextToken();
        if (this.m_decimalPoint != '.') {
            nt = nt.replace(this.m_decimalPoint, '.');
        }
        try {
            v = Double.valueOf(nt).floatValue();
        }
        catch (NumberFormatException nfe) {
            log.warn("Warning: Not numeric value at row " + this.getLineno() + ": <" + nt + ">");
            v = 0.0;
        }
        return v;
    }

    public void resetInput() throws IOException {
        this.stream.reset();
        this.tokenizer = null;
    }

    public void setDecimalPoint(char dp) {
        this.m_decimalPoint = dp;
    }

    public char getDecimalPoint() {
        return this.m_decimalPoint;
    }
}

