/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import org.joone.engine.Pattern;
import org.joone.io.InputConnector;
import org.joone.io.InputSwitchSynapse;
import org.joone.io.StreamInputSynapse;

public class MultipleInputSynapse
extends InputSwitchSynapse {
    private int currentInput = 0;
    private int currentPatt = 0;

    public Pattern fwdGet() {
        super.setActiveSynapse((StreamInputSynapse)this.inputs.get(this.currentInput));
        Pattern patt = super.fwdGet();
        return this.elaboratePattern(patt);
    }

    public Pattern fwdGet(InputConnector conn) {
        StreamInputSynapse myInput = null;
        int myFirstRow = conn.getFirstRow();
        int myCurrentRow = conn.getCurrentRow();
        int myLastRow = conn.getLastRow();
        int i = 0;
        while (i < this.inputs.size()) {
            myInput = (StreamInputSynapse)this.inputs.elementAt(i);
            int myNumberOfPatterns = this.getNumberOfPatterns(myInput);
            if (myFirstRow > myNumberOfPatterns) {
                myFirstRow -= myNumberOfPatterns;
                myCurrentRow -= myNumberOfPatterns;
                if (myLastRow > 0) {
                    myLastRow -= myNumberOfPatterns;
                }
            } else if (myCurrentRow > myNumberOfPatterns) {
                myFirstRow = 1;
                myCurrentRow -= myNumberOfPatterns;
                if (myLastRow > 0) {
                    myLastRow -= myNumberOfPatterns;
                }
            } else {
                if (myLastRow > myNumberOfPatterns) {
                    myLastRow = 0;
                }
                InputConnector myInputConnector = new InputConnector();
                myInputConnector.setFirstRow(myFirstRow);
                myInputConnector.setCurrentRow(myCurrentRow);
                myInputConnector.setLastRow(myLastRow);
                this.setActiveSynapse(myInput);
                Pattern myPattern = super.fwdGet(myInputConnector);
                if (myPattern.getCount() != -1) {
                    myPattern.setCount(conn.getCurrentRow() - conn.getFirstRow());
                }
                return myPattern;
            }
            ++i;
        }
        return null;
    }

    protected int getNumberOfPatterns(StreamInputSynapse anInputSynpase) {
        if (anInputSynpase.getLastRow() != 0) {
            return anInputSynpase.getLastRow() - anInputSynpase.getFirstRow() + 1;
        }
        if (anInputSynpase.getInputVector().size() != 0) {
            return anInputSynpase.getInputVector().size();
        }
        if (!anInputSynpase.isBuffered()) {
            anInputSynpase.setBuffered(true);
        }
        anInputSynpase.readAll();
        return anInputSynpase.getInputVector().size();
    }

    private Pattern elaboratePattern(Pattern patt) {
        int count = patt.getCount();
        if (count == -1) {
            this.currentPatt = 0;
            this.currentInput = 0;
        } else {
            patt.setCount(++this.currentPatt);
            if (this.getActiveSynapse().isEOF()) {
                ++this.currentInput;
                if (this.currentInput == this.inputs.size()) {
                    this.currentPatt = 0;
                    this.currentInput = 0;
                }
            }
        }
        return patt;
    }

    public void reset() {
        super.reset();
        this.currentPatt = 0;
        this.currentInput = 0;
    }

    public void setBuffered(boolean newBuffered) {
        int i = 0;
        while (i < this.inputs.size()) {
            StreamInputSynapse myInput = (StreamInputSynapse)this.inputs.elementAt(i);
            myInput.setBuffered(newBuffered);
            ++i;
        }
    }

    public void gotoLine(int aNumLine) throws IOException {
        StreamInputSynapse myInput = null;
        int i = 0;
        while (i < this.inputs.size()) {
            myInput = (StreamInputSynapse)this.inputs.elementAt(i);
            int myNumberOfPatterns = this.getNumberOfPatterns(myInput);
            if (aNumLine < myNumberOfPatterns + myInput.getFirstRow() - 1) {
                this.setActiveSynapse(myInput);
                myInput.gotoLine(aNumLine);
                return;
            }
            aNumLine -= myNumberOfPatterns;
            ++i;
        }
    }

    public void setFirstRow(int newFirstRow) {
        throw new UnsupportedOperationException("Control the first row through the underlying source or any connected input connectors");
    }

    public void setLastRow(int newLastRow) {
        throw new UnsupportedOperationException("Control the last row through the underlying source or any connected input connectors");
    }
}

