/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class JDBCOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(JDBCOutputSynapse.class);
    private String driverName = "";
    private String dbURL = "";
    private String SQLAmendment = "";
    private transient Connection con = null;
    private transient Statement stmt = null;
    private static final long serialVersionUID = 2176832390164459511L;

    public JDBCOutputSynapse() {
    }

    public JDBCOutputSynapse(String newDrivername, String newdbURL, String newSQLAmendment, boolean buffered) {
        this.setBuffered(buffered);
        this.setdriverName(newDrivername);
        this.setdbURL(newdbURL);
        this.setSQLAmendment(newSQLAmendment);
    }

    public String getdriverName() {
        return this.driverName;
    }

    public String getdbURL() {
        return this.dbURL;
    }

    public String getSQLAmendment() {
        return this.SQLAmendment;
    }

    public void setdriverName(String newDriverName) {
        if (!newDriverName.equals(this.driverName)) {
            this.driverName = newDriverName;
        }
    }

    public void setdbURL(String newdbURL) {
        if (!this.dbURL.equals(newdbURL)) {
            this.dbURL = newdbURL;
        }
    }

    public void setSQLAmendment(String newSQLAmendment) {
        if (!this.SQLAmendment.equals(newSQLAmendment)) {
            this.SQLAmendment = newSQLAmendment;
        }
    }

    protected void initStream() throws JooneRuntimeException {
        block13: {
            if (this.driverName != null && !this.driverName.equals(new String(""))) {
                if (this.dbURL != null && !this.dbURL.equals(new String(""))) {
                    if (this.SQLAmendment != null && !this.SQLAmendment.equals(new String(""))) {
                        try {
                            Class.forName(this.driverName);
                            this.con = DriverManager.getConnection(this.dbURL);
                            this.stmt = this.con.createStatement();
                        }
                        catch (ClassNotFoundException ex) {
                            log.error("Could not find Database Driver Class while initializing the JDBCInputStream. Message is : " + ex.getMessage(), ex);
                            if (this.getMonitor() != null) {
                                new NetErrorManager(this.getMonitor(), "Could not find Database Driver Class while initializing the JDBCInputStream. Message is : " + ex.getMessage());
                            }
                            break block13;
                        }
                        catch (SQLException sqlex) {
                            log.error("SQLException thrown while initializing the JDBCInputStream. Message is : " + sqlex.getMessage(), sqlex);
                            if (this.getMonitor() != null) {
                                new NetErrorManager(this.getMonitor(), "SQLException thrown while initializing the JDBCInputStream. Message is : " + sqlex.getMessage());
                            }
                            break block13;
                        }
                    }
                    String err = "The SQL Amendment has not been entered!";
                    log.warn(err);
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "The SQL Amendment has not been entered!");
                    }
                } else {
                    String err = "The Database URL has not been entered!";
                    log.warn(err);
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "The Database URL has not been entered!");
                    }
                }
            } else {
                String err = "The Driver Name has not been entered!";
                log.warn(err);
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "The Driver Name has not been entered!");
                }
            }
        }
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.driverName == null || this.driverName.compareTo("") == 0) {
            checks.add(new NetCheck(0, "Database Driver Name needs to be entered.", this));
        } else {
            try {
                Class.forName(this.driverName);
                if (this.dbURL != null && this.dbURL.compareTo("") != 0) {
                    Connection con = DriverManager.getConnection(this.dbURL);
                    this.stmt = con.createStatement();
                }
            }
            catch (ClassNotFoundException ex) {
                checks.add(new NetCheck(0, "Could not find Database Driver Class. Check Database Driver is in the classpath and is readable.", this));
            }
            catch (SQLException sqlex) {
                checks.add(new NetCheck(0, "The Database URL is incorrect. Connection error is : " + sqlex.toString(), this));
            }
        }
        if (this.dbURL == null || this.dbURL.compareTo("") == 0) {
            checks.add(new NetCheck(0, "Database URL needs to be entered.", this));
        }
        if (this.SQLAmendment == null || this.SQLAmendment.compareTo("") == 0) {
            checks.add(new NetCheck(0, "Database SQL Amendment needs to be entered.", this));
        }
        return checks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(Pattern pattern) throws JooneRuntimeException {
        String Amendment = new String(this.SQLAmendment);
        if (this.con == null || this.stmt == null || pattern.getCount() == 1) {
            this.initStream();
        }
        if (pattern.getCount() == -1) {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                if (this.con == null) return;
                this.con.close();
                return;
            }
            catch (SQLException ex) {
                this.stmt = null;
                this.con = null;
                return;
            }
        }
        try {
            if (Amendment == null) return;
            if (Amendment.equals("")) return;
            int i = 0;
            block4: while (true) {
                if (i >= pattern.getArray().length) {
                    this.stmt.executeUpdate(Amendment);
                    return;
                }
                while (true) {
                    if (Amendment.indexOf("JOONE[" + (i + 1) + "]") < 0) {
                        ++i;
                        continue block4;
                    }
                    StringBuffer buf = new StringBuffer(Amendment);
                    Amendment = buf.replace(Amendment.indexOf("JOONE[" + (i + 1) + "]"), Amendment.indexOf("JOONE[" + (i + 1) + "]") + new String("JOONE[" + (i + 1) + "]").length(), new Double(pattern.getArray()[i]).toString()).toString();
                }
                break;
            }
        }
        catch (SQLException ex) {
            String err = new String("An SQL error occurred while trying to execute [" + Amendment + "], error is " + ex.toString());
            log.error(err);
            if (this.getMonitor() == null) return;
            new NetErrorManager(this.getMonitor(), err);
        }
    }
}

