/*
 * Decompiled with CFR 0.152.
 */
package org.joone.inspection.implementations;

import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.inspection.Inspection;

public class InputsInspection
implements Inspection {
    private Vector inputs = null;

    public InputsInspection(Vector inputsArg) {
        this.inputs = inputsArg;
    }

    public Object[][] getComponent() {
        if (this.inputs != null && this.inputs.size() > 0) {
            Object[][] bigValues = null;
            int i = 0;
            while (i < this.inputs.size()) {
                Pattern pattern = (Pattern)this.inputs.elementAt(i);
                double[] array = pattern.getArray();
                if (bigValues == null) {
                    bigValues = new Object[this.inputs.size()][array.length + 1];
                }
                int j = 1;
                while (j < array.length + 1) {
                    Double d = new Double(array[j - 1]);
                    bigValues[i][j] = d;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.inputs.size()) {
                bigValues[i][0] = new Integer(i + 1);
                ++i;
            }
            return bigValues;
        }
        return null;
    }

    public String getTitle() {
        return "Inputs";
    }

    public Object[] getNames() {
        if (this.inputs != null && this.inputs.size() > 0) {
            Object[] names = null;
            int i = 0;
            while (i < this.inputs.size()) {
                Pattern pattern = (Pattern)this.inputs.elementAt(i);
                double[] array = pattern.getArray();
                if (names == null) {
                    names = new String[array.length + 1];
                }
                names[0] = "Row Number";
                int j = 1;
                while (j < array.length + 1) {
                    names[j] = "Column " + j;
                    ++j;
                }
                ++i;
            }
            return names;
        }
        return null;
    }

    public boolean rowNumbers() {
        return true;
    }

    public void setComponent(Object[][] newValues) {
        int x = 0;
        while (x < this.inputs.size() && x < newValues.length) {
            double[] values = ((Pattern)this.inputs.elementAt(x)).getArray();
            int n = ((Pattern)this.inputs.elementAt(x)).getCount();
            int y = 0;
            while (y < values.length && y < newValues[0].length - 1) {
                values[y] = (Double)newValues[x][y + 1];
                ++y;
            }
            Pattern patt = new Pattern(values);
            patt.setCount(n);
            this.inputs.setElementAt(patt, x);
            ++x;
        }
    }
}

