/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.weights;

import java.util.Random;
import org.joone.engine.Matrix;
import org.joone.engine.weights.WeightInitializer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class RandomWeightInitializer
implements WeightInitializer {
    private static final ILogger log = LoggerFactory.getLogger(RandomWeightInitializer.class);
    private static final long serialVersionUID = 1547731234507850525L;
    private double upperBound = 0.0;
    private double lowerBound = 0.0;
    private Random random = new Random(1999L);

    public RandomWeightInitializer(double aBoundary) {
        if (aBoundary < 0.0) {
            log.warn("Boundary smaller than zero. Domain set to [" + aBoundary + ", " + -aBoundary + "].");
            aBoundary = Math.abs(aBoundary);
        }
        this.upperBound = aBoundary;
        this.lowerBound = -aBoundary;
    }

    public RandomWeightInitializer(double aLowerBound, double anUpperBound) {
        if (aLowerBound > anUpperBound) {
            log.warn("Lower bound is larger than upper bound. Domain set to [" + anUpperBound + ", " + aLowerBound + "].");
            this.upperBound = aLowerBound;
            this.lowerBound = anUpperBound;
        } else {
            this.upperBound = anUpperBound;
            this.lowerBound = aLowerBound;
        }
    }

    public void initialize(Matrix aMatrix) {
        int x = 0;
        while (x < aMatrix.getM_rows()) {
            int y = 0;
            while (y < aMatrix.getM_cols()) {
                if (aMatrix.enabled[x][y] && !aMatrix.fixed[x][y]) {
                    aMatrix.value[x][y] = this.lowerBound + this.random.nextDouble() * (this.upperBound - this.lowerBound);
                }
                ++y;
            }
            ++x;
        }
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double aLowerBound) {
        this.lowerBound = aLowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double anUpperBound) {
        this.upperBound = anUpperBound;
    }
}

