/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.weights;

import java.util.Random;
import org.joone.engine.Matrix;
import org.joone.engine.weights.WeightInitializer;

public class FanInBasedWeightInitializer
implements WeightInitializer {
    private double lowerBound = -2.4;
    private double upperBound = 2.4;
    private boolean sqrtFanIn = false;
    private Random random = new Random(2000L);

    public FanInBasedWeightInitializer() {
    }

    public FanInBasedWeightInitializer(double aBoundary) {
        this.lowerBound = -aBoundary;
        this.upperBound = aBoundary;
    }

    public FanInBasedWeightInitializer(double aLowerBound, double anUpperBound) {
        this.lowerBound = aLowerBound;
        this.upperBound = anUpperBound;
    }

    public void initialize(Matrix aMatrix) {
        int x = 0;
        while (x < aMatrix.getM_rows()) {
            int y = 0;
            while (y < aMatrix.getM_cols()) {
                if (aMatrix.enabled[x][y] && !aMatrix.fixed[x][y]) {
                    aMatrix.value[x][y] = this.lowerBound / (this.isSqrtFanIn() ? Math.sqrt(aMatrix.getM_rows()) : (double)aMatrix.getM_rows()) + this.random.nextDouble() * ((this.upperBound - this.lowerBound) / (this.isSqrtFanIn() ? Math.sqrt(aMatrix.getM_rows()) : (double)aMatrix.getM_rows()));
                }
                ++y;
            }
            ++x;
        }
    }

    public void setSqrtFanIn(boolean aMode) {
        this.sqrtFanIn = aMode;
    }

    public boolean isSqrtFanIn() {
        return this.sqrtFanIn;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double aLowerBound) {
        this.lowerBound = aLowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double anUpperBound) {
        this.upperBound = anUpperBound;
    }
}

