/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class TanhLayer
extends SimpleLayer
implements LearnableLayer {
    private static final long serialVersionUID = -2073914754873517298L;
    private static final ILogger log = LoggerFactory.getLogger(TanhLayer.class);
    private double flatSpotConstant = 0.0;

    public TanhLayer() {
        this.learnable = true;
    }

    public TanhLayer(String name) {
        this();
        this.setLayerName(name);
    }

    public void backward(double[] pattern) {
        super.backward(pattern);
        int n = this.getRows();
        int x = 0;
        while (x < n) {
            this.gradientOuts[x] = pattern[x] * ((1.0 + this.outs[x]) * (1.0 - this.outs[x]) + this.getFlatSpotConstant());
            ++x;
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public void forward(double[] pattern) {
        int n = this.getRows();
        int x = 0;
        while (x < n) {
            this.outs[x] = -1.0 + 2.0 / (1.0 + Math.exp(-2.0 * (pattern[x] + this.bias.value[x][0])));
            ++x;
        }
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }

    public void setFlatSpotConstant(double aConstant) {
        this.flatSpotConstant = aConstant;
    }

    public double getFlatSpotConstant() {
        return this.flatSpotConstant;
    }
}

