/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;

public abstract class SpatialMap
implements Serializable {
    private double InitialGaussianSize = 1.0;
    private double CurrentGaussianSize = 1.0;
    private int map_width = 1;
    private int map_height = 1;
    private int map_depth = 1;
    private int win_x = 0;
    private int win_y = 0;
    private int win_z = 0;
    private int TotalEpochs = 1;
    private int orderingPhase;
    double TimeConstant = 1.0;

    public final void init(int total_epochs) {
        this.updateCurrentGaussianSize(1);
    }

    public final int getTotalEpochs() {
        return this.TotalEpochs;
    }

    public final void setInitialGaussianSize(double size) {
        this.setCurrentGaussianSize(size);
        this.InitialGaussianSize = size;
    }

    public final double getInitialGaussianSize() {
        return this.InitialGaussianSize;
    }

    public final void setCurrentGaussianSize(double size) {
        this.CurrentGaussianSize = size;
    }

    public final double getCurrentGaussianSize() {
        return this.CurrentGaussianSize;
    }

    public final void updateCurrentGaussianSize(int current_epoch) {
        if (current_epoch < this.getOrderingPhase()) {
            this.setCurrentGaussianSize(this.getInitialGaussianSize() * Math.exp(-((double)current_epoch / this.getTimeConstant())));
        } else {
            this.setCurrentGaussianSize(0.01);
        }
    }

    public abstract void ApplyNeighborhoodFunction(double[] var1, double[] var2, boolean var3);

    protected final void extractWinner(double[] distances) {
        int current_output = 0;
        double curDist = 0.0;
        double bestDist = 1.0E15f;
        int z = 0;
        while (z < this.getMapDepth()) {
            int y = 0;
            while (y < this.getMapHeight()) {
                int x = 0;
                while (x < this.getMapWidth()) {
                    current_output = x + y * this.getMapWidth() + z * (this.getMapWidth() * this.getMapHeight());
                    curDist = distances[current_output];
                    if (curDist < bestDist) {
                        bestDist = curDist;
                        this.win_x = x;
                        this.win_y = y;
                        this.win_z = z;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    protected final int getWinnerX() {
        return this.win_x;
    }

    protected final int getWinnerY() {
        return this.win_y;
    }

    protected final int getWinnerZ() {
        return this.win_z;
    }

    public final void setMapDimensions(int x, int y, int z) {
        this.setMapWidth(x);
        this.setMapHeight(y);
        this.setMapDepth(z);
    }

    public final void setMapWidth(int w) {
        this.map_width = w > 0 ? w : 1;
    }

    public final void setMapHeight(int h) {
        this.map_height = h > 0 ? h : 1;
    }

    public final void setMapDepth(int d) {
        this.map_depth = d > 0 ? d : 1;
    }

    public final int getMapWidth() {
        return this.map_width;
    }

    public final int getMapHeight() {
        return this.map_height;
    }

    public final int getMapDepth() {
        return this.map_depth;
    }

    protected final double distanceBetween(int x1, int y1, int z1, int x2, int y2, int z2) {
        int xleg = 0;
        int yleg = 0;
        int zleg = 0;
        xleg = x1 - x2;
        xleg *= xleg;
        yleg = y1 - y2;
        yleg *= yleg;
        zleg = z1 - z2;
        zleg *= zleg;
        return xleg + yleg + zleg;
    }

    public int getOrderingPhase() {
        return this.orderingPhase;
    }

    public void setOrderingPhase(int orderingPhase) {
        this.orderingPhase = orderingPhase;
    }

    public double getTimeConstant() {
        return this.TimeConstant;
    }

    public void setTimeConstant(double TimeConstant) {
        this.TimeConstant = TimeConstant;
    }
}

